/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.daltransform.DataTransformLocator;
import org.gvsig.daltransform.DataTransformManager;
import org.gvsig.daltransform.swing.DataTransformGui;
import org.gvsig.daltransform.swing.impl.AbstractDataTransformWizardPanel;

public class SelectTransformWizardPanel
extends AbstractDataTransformWizardPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -4191590513663444616L;
    private JList transformList;
    private JScrollPane transformScrollPane;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionText;
    private int maxWidth = 315;
    private int maxHeight = 600;

    public SelectTransformWizardPanel() {
        this.initComponents();
        this.addTransforms();
        this.transformList.addListSelectionListener(this);
    }

    private void initComponents() {
        this.transformScrollPane = new JScrollPane();
        this.transformList = new JList();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionText = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.transformScrollPane.setViewportView(this.transformList);
        this.transformList.setModel(new DefaultListModel());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        this.add((Component)this.transformScrollPane, gridBagConstraints);
        this.descriptionText.setColumns(20);
        this.descriptionText.setEditable(false);
        this.descriptionText.setRows(5);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionText.setBackground(this.getBackground());
        Font fnt = this.descriptionText.getFont();
        fnt = fnt.deriveFont(0);
        this.descriptionText.setFont(fnt);
        this.descriptionText.setBorder(null);
        this.descriptionScrollPane.setBorder(null);
        this.descriptionScrollPane.setViewportView(this.descriptionText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.add((Component)this.descriptionScrollPane, gridBagConstraints);
    }

    protected void addTransforms() {
        DataTransformManager featureTransformManager = DataTransformLocator.getDataTransformManager();
        List<DataTransformGui> dataTransformGui = featureTransformManager.getDataTransforms();
        for (int i = 0; i < dataTransformGui.size(); ++i) {
            ((DefaultListModel)this.transformList.getModel()).addElement(new FeatureTransformGuiWrapper(dataTransformGui.get(i)));
            Dimension dimension = dataTransformGui.get(i).getMinDimension();
            if (dimension == null) continue;
            if (dimension.getHeight() > (double)this.maxHeight) {
                this.maxHeight = (int)dimension.getHeight();
            }
            if (!(dimension.getWidth() > (double)this.maxWidth)) continue;
            this.maxWidth = (int)dimension.getWidth();
        }
        this.updatePanel();
    }

    @Override
    public void updatePanel() {
        if (this.transformList.getSelectedIndex() == -1) {
            if (this.transformList.getModel().getSize() > 0) {
                this.transformList.setSelectedIndex(0);
                this.valueChanged(null);
            }
        } else if (this.transformList.getModel().getSize() == 0) {
            this.getDataTransformWizard().setApplicable(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object obj = this.transformList.getSelectedValue();
        if (obj != null) {
            this.descriptionText.setText(((FeatureTransformGuiWrapper)obj).getFeatureTransformGui().getDescription());
        }
    }

    public DataTransformGui getFeatureTransformGui() {
        Object obj = this.transformList.getSelectedValue();
        if (obj != null) {
            return ((FeatureTransformGuiWrapper)obj).getFeatureTransformGui();
        }
        return null;
    }

    @Override
    public String getPanelTitle() {
        return PluginServices.getText((Object)this, (String)"transform_selection");
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    private class FeatureTransformGuiWrapper {
        private DataTransformGui featureTransformGui = null;

        public FeatureTransformGuiWrapper(DataTransformGui featureTransformGui) {
            this.featureTransformGui = featureTransformGui;
        }

        public DataTransformGui getFeatureTransformGui() {
            return this.featureTransformGui;
        }

        public String toString() {
            return this.featureTransformGui.getName();
        }
    }
}

