/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.AbstractStoresRepository;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.gvsig.tools.util.UnmodifiableBasicSetAdapter;

public class BaseStoresRepository
extends AbstractStoresRepository
implements StoresRepository {
    private final Map<String, DataStoreParameters> repository;

    public BaseStoresRepository(String name) {
        this(name, null, null);
    }

    public BaseStoresRepository(String name, String label) {
        this(name, label, null);
    }

    public BaseStoresRepository(String name, String label, DataServerExplorerParameters serverParameters) {
        super(name, label);
        this.setServerParameters(serverParameters);
        this.repository = new HashMap<String, DataStoreParameters>();
    }

    @Override
    protected DataStoreParameters getMyParameters(String name) {
        return this.repository.get(name);
    }

    @Override
    protected boolean isEmptyMyRepository() {
        return this.repository.isEmpty();
    }

    @Override
    protected int getMySize() {
        return this.repository.size();
    }

    @Override
    protected UnmodifiableBasicSet<String> getMyKeySet() {
        Set<String> keyset = this.repository.keySet();
        if (keyset == null || keyset.isEmpty()) {
            return UnmodifiableBasicSet.EMPTY_UNMODIFIABLEBASICSET;
        }
        return new UnmodifiableBasicSetAdapter(keyset);
    }

    @Override
    public PropertiesSupport getProperties(String name) {
        return null;
    }

    @Override
    public void add(String name, DataStoreParameters parameters) {
        this.add(name, parameters, null);
    }

    @Override
    public void add(String name, DataStoreParameters parameters, String label) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters can't be null.");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name can't be blank.");
        }
        if (this.notifyObservers("add", name, parameters).isCanceled()) {
            return;
        }
        this.repository.put(name, parameters);
        this.setLabel(name, label);
    }

    @Override
    public void remove(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            this.LOGGER.warn("parameter name can't be blank");
            return;
        }
        if (this.notifyObservers("remove", name).isCanceled()) {
            return;
        }
        this.repository.remove(name);
    }
}

