/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal;

import java.util.Collection;
import org.gvsig.fmap.dal.DataCache;
import org.gvsig.fmap.dal.DataFactoryUnit;
import org.gvsig.fmap.dal.DataQuery;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.metadata.Metadata;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObject_v2;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.ComplexWeakReferencingObservable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.service.spi.Services;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.gvsig.tools.visitor.Visitable;
import org.gvsig.tools.visitor.Visitor;

public interface DataStore
extends ComplexWeakReferencingObservable,
Persistent,
Metadata,
Disposable,
Visitable,
DataFactoryUnit,
Services,
DynObject_v2 {
    public static final String SHAPE_PROVIDER_NAME = "Shape";
    public static final String DBASE_PROVIDER_NAME = "DBF";
    public static final String CSV_PROVIDER_NAME = "CSV";
    public static final String H2SPATIAL_PROVIDER_NAME = "H2Spatial";
    public static final String GEOPACKAGE_PROVIDER_NAME = "SQLite";
    public static final String MDB_PROVIDER_NAME = "MDB";
    public static final String METADATA_DEFINITION_NAME = "DataProvider";
    public static final String FEATURE_METADATA_DEFINITION_NAME = "FeatureProvider";
    public static final String SPATIAL_METADATA_DEFINITION_NAME = "SpatialProvider";
    public static final String METADATA_PROVIDER = "ProviderName";
    public static final String METADATA_CONTAINERNAME = "ContainerName";
    public static final String METADATA_FEATURETYPE = "FeatureType";
    public static final String METADATA_CRS = "CRS";
    public static final String METADATA_ENVELOPE = "Envelope";

    public static String getFullNameQuietly(DataStore store) {
        try {
            return store.getFullName();
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static String getNameQuietly(DataStore store) {
        try {
            return store.getName();
        }
        catch (Throwable th) {
            return null;
        }
    }

    public String getName();

    public String getFullName();

    public DataStoreParameters getParameters();

    public String getProviderName();

    public void refresh() throws DataException;

    public DataSet getDataSet() throws DataException;

    public DataSet getDataSet(DataQuery var1) throws DataException;

    public void accept(Visitor var1) throws BaseException;

    public void accept(Visitor var1, DataQuery var2) throws BaseException;

    public void getDataSet(Observer var1) throws DataException;

    public void getDataSet(DataQuery var1, Observer var2) throws DataException;

    public DataSet getSelection() throws DataException;

    public void setSelection(DataSet var1) throws DataException;

    public DataSet createSelection() throws DataException;

    public UnmodifiableBasicMap<String, DataStore> getChildren();

    public DataServerExplorer getExplorer() throws DataException, ValidateDataParametersException;

    public DataQuery createQuery();

    public Interval getInterval();

    public Collection getTimes();

    public Collection getTimes(Interval var1);

    public void useCache(String var1, DynObject var2) throws DataException;

    public DataStoreProviderFactory getProviderFactory();

    public DataCache getCache();

    public ResourcesStorage getResourcesStorage();

    public StoresRepository getStoresRepository();
}

