/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.complements;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.complement.Complement;

public interface Search
extends Complement<FeatureType> {
    public static final String COMPLEMENT_MANE = "DAL.Search";
    public static final String DAL_SEARCH_ATTRIBUTE_PRIORITY = "DAL.Search.Attribute.Priority";
    public static final Predicate<FeatureAttributeDescriptor> BASIC_TYPES_FILTER = FeatureType.BASIC_TYPES_FILTER;
    public static final Predicate<FeatureAttributeDescriptor> ALL_FILTER = FeatureType.ALL_FILTER;
    public static final Comparator<FeatureAttributeDescriptor> LABEL_ORDER = new Comparator<FeatureAttributeDescriptor>(){

        @Override
        public int compare(FeatureAttributeDescriptor o1, FeatureAttributeDescriptor o2) {
            return StringUtils.compareIgnoreCase((String)o1.getLabel(), (String)o2.getLabel());
        }
    };
    public static final Comparator<FeatureAttributeDescriptor> STR_INT_LONG_LABEL_ORDER = new Comparator<FeatureAttributeDescriptor>(){

        @Override
        public int compare(FeatureAttributeDescriptor o1, FeatureAttributeDescriptor o2) {
            int t1 = o1.getType();
            int t2 = o2.getType();
            if (t1 == 8) {
                if (t2 == 8) {
                    return StringUtils.compareIgnoreCase((String)o1.getLabel(), (String)o2.getLabel());
                }
                return -1;
            }
            if (t2 == 8) {
                return 1;
            }
            if (t1 == 4 || t1 == 5) {
                if (t2 == 4 || t2 == 5) {
                    return StringUtils.compareIgnoreCase((String)o1.getLabel(), (String)o2.getLabel());
                }
                return -1;
            }
            if (t2 == 4 || t2 == 5) {
                return 1;
            }
            return StringUtils.compareIgnoreCase((String)o1.getLabel(), (String)o2.getLabel());
        }
    };

    public int getPriority(FeatureAttributeDescriptor var1);

    public List<String> getResultColumnNames();

    public List<OrderedAttribute> getOrderedAttributes(Predicate<FeatureAttributeDescriptor> var1, Comparator<FeatureAttributeDescriptor> var2, int var3);

    public List<OrderedAttribute> getOrderedAttributes(Predicate<FeatureAttributeDescriptor> var1, Comparator<FeatureAttributeDescriptor> var2, int var3, List<FeatureAttributeDescriptor> var4);

    public List<FeatureAttributeDescriptor> getFavorites();

    public static interface OrderedAttribute {
        public static final int TYPE_REGURAL = 0;
        public static final int TYPE_RECENT = 1;
        public static final int TYPE_FAVORITE = 2;
        public static final int TYPE_EXTRA = 3;

        public FeatureAttributeDescriptor getDescriptor();

        public int getType();
    }
}

