/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.exception;

import org.gvsig.fmap.dal.exception.DataRuntimeException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;

public class IllegalValueException
extends DataRuntimeException {
    private static final long serialVersionUID = 7398202284121091833L;
    private static final String MESSAGE_FORMAT = "Value %(value) not allowed for the attribute '%(attribute)' of type '%(typename)'.";
    private static final String MESSAGE_KEY = "_IllegalValueException";

    public IllegalValueException(FeatureAttributeDescriptor attribute, Object value) {
        super(MESSAGE_FORMAT, MESSAGE_KEY, 7398202284121091833L);
        this.setValue("attribute", attribute.getName());
        this.setValue("typename", attribute.getFullDataTypeName());
        if (value == null) {
            this.setValue("value", "null");
        } else {
            this.setValue("value", "'" + value.toString() + "'");
        }
    }

    public IllegalValueException(FeatureAttributeDescriptor attribute, Object value, Throwable cause) {
        super(MESSAGE_FORMAT, cause, MESSAGE_KEY, 7398202284121091833L);
        this.setValue("attribute", attribute.getName());
        this.setValue("typename", attribute.getFullDataTypeName());
        if (value == null) {
            this.setValue("value", "{null}");
        } else {
            this.setValue("value", value.toString());
        }
    }
}

