/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import thing.ComponentWalker;
import thing.ThinletDTD;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.ThinletDialog;

public class ComponentChooser {
    private static final Logger log = Logger.getLogger("thing");
    private ThinletDialog dialog;
    private Thinlet thinlet;
    private boolean isCancelled = true;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public ComponentChooser(Frame owner, String title, Object topComponent, String omitName) {
        this.dialog = new ThinletDialog(owner, title);
        this.thinlet = new AntiAliasedThinlet();
        try {
            Object panel = this.thinlet.parse("/thing/componentchooser.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing componentchooser.xml", e);
        }
        this.dialog.setContent(this.thinlet);
        Object list = this.thinlet.find("list");
        String[] names = ComponentChooser.getAllNames(this.thinlet, topComponent, omitName);
        for (int i = 0; i < names.length; ++i) {
            Object item = Thinlet.create((String)"item");
            this.thinlet.setString(item, "text", names[i]);
            this.thinlet.add(list, item);
        }
    }

    public void show() {
        this.dialog.setSize(new Dimension(300, 300));
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void setSelectedComponent(String name) {
        Object lSelected = this.thinlet.find("lSelected");
        if (name == null || name.length() == 0) {
            this.thinlet.setString(lSelected, "text", "null");
            return;
        }
        Object list = this.thinlet.find("list");
        Object[] items = this.thinlet.getItems(list);
        boolean found = false;
        for (int i = 0; i < items.length; ++i) {
            String text = this.thinlet.getString(items[i], "text");
            found = text.equals(name);
            if (!found) continue;
            this.thinlet.setBoolean(items[i], "selected", true);
            break;
        }
        this.thinlet.setString(lSelected, "text", found ? name : name + "?");
    }

    public String getSelectedComponent() {
        Object item = this.thinlet.getSelectedItem(this.thinlet.find("list"));
        if (item != null) {
            return this.thinlet.getString(item, "text");
        }
        return null;
    }

    public boolean isCancelled() {
        return !this.dialog.isVisible() && this.isCancelled;
    }

    public void selectionChanged(Object list, Object lSelected) {
        Object item = this.thinlet.getSelectedItem(list);
        this.thinlet.setString(lSelected, "text", item != null ? this.thinlet.getString(item, "text") : "null");
    }

    public void ok() {
        this.isCancelled = false;
        this.close();
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    private static String[] getAllNames(final Thinlet thinlet, Object topComponent, final String omitName) {
        final TreeSet names = new TreeSet();
        ComponentWalker walker = new ComponentWalker();
        walker.walk(thinlet, topComponent, new ComponentWalker.Visitor(){

            @Override
            public boolean visit(Object component, int depth) {
                String name;
                ThinletDTD.Widget widget = ThinletDTD.getWidget(Thinlet.getClass((Object)component));
                if (widget.hasProperty("name") && (name = thinlet.getString(component, "name")) != null && name.length() > 0 && !name.equals(omitName)) {
                    names.add(name);
                }
                return true;
            }

            @Override
            public void leave(Object component, int depth) {
            }
        });
        return names.toArray(new String[names.size()]);
    }
}

