/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import thing.ComponentWalker;
import thing.Main;
import thing.PropertyManager;
import thing.ThinletDTD;
import thing.ThinletReader;
import thinlet.Thinlet;

public class Generator {
    private static Logger log = Logger.getLogger("thing");
    private static final ResourceBundle res = ResourceBundle.getBundle("thing.generator");
    private String handlerClassname;
    private String interfaceName;
    private String packageName;
    private boolean asThinlet = false;
    private boolean generateMain = false;
    private boolean generateFirstLine = true;
    private File outputDir;
    private Writer interfaceWriter;
    private Writer handlerWriter;
    private TreeSet methods;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public void setHandlerClassname(String name) {
        this.handlerClassname = name != null && name.toLowerCase().endsWith(".java") ? name.substring(0, name.length() - 5) : name;
    }

    public void setInterfaceName(String name) {
        this.interfaceName = name != null && name.toLowerCase().endsWith(".java") ? name.substring(0, name.length() - 5) : name;
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public void setGenerateAsThinlet(boolean asThinlet) {
        this.asThinlet = asThinlet;
    }

    public void setGenerateMain(boolean generateMain) {
        this.generateMain = generateMain;
    }

    public void setOutputDirectory(File outputDir) {
        this.outputDir = outputDir;
        if (Generator.debug()) {
            log.fine("output directory set to: " + (outputDir == null ? "null" : outputDir.getAbsolutePath()));
        }
    }

    public void setWriterForInterface(Writer writer) {
        if (Generator.debug()) {
            log.fine("using custom writer for interface");
        }
        this.interfaceWriter = writer;
    }

    public void setWriterForHandler(Writer writer) {
        if (Generator.debug()) {
            log.fine("using custom writer for handler class");
        }
        this.handlerWriter = writer;
    }

    public void setGenerateFirstLine(boolean generateFirstLine) {
        this.generateFirstLine = generateFirstLine;
    }

    public void generate(final Thinlet thinlet, final Object startComponent, final PropertyManager propmgr, String thinletfilename) throws IOException {
        this.setup();
        this.begin(thinletfilename);
        ComponentWalker walker = new ComponentWalker();
        walker.walk(thinlet, startComponent, new ComponentWalker.Visitor(){

            @Override
            public boolean visit(Object component, int depth) {
                String componentclassname = Thinlet.getClass((Object)component);
                ThinletDTD.Widget widget = ThinletDTD.getWidget(componentclassname);
                ThinletDTD.Property[] props = widget.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    String methodDecl;
                    if (props[i].getType() != 8 || (methodDecl = propmgr.getValueString(component, props[i])) == null || methodDecl.length() <= 0) continue;
                    String componentname = propmgr.getValueString(component, "name");
                    try {
                        Generator.this.method(methodDecl, props[i].getName(), componentname, componentclassname, new HashMap(){

                            @Override
                            public Object get(Object key) {
                                String name = (String)key;
                                Object component = thinlet.find(startComponent, name);
                                if (component == null) {
                                    return null;
                                }
                                String classname = Thinlet.getClass((Object)component);
                                return ThinletDTD.getWidget(classname);
                            }
                        });
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("I/O Error", e);
                    }
                }
                return true;
            }

            @Override
            public void leave(Object component, int depth) {
            }
        });
        this.finish(thinletfilename);
    }

    public void generate(File thinletFile) throws IOException, ParseException {
        if (Generator.debug()) {
            log.fine("thinletFile: " + thinletFile.getAbsolutePath() + " exists: " + thinletFile.exists());
        }
        if (this.outputDir == null) {
            this.outputDir = thinletFile.getParentFile();
        }
        final HashMap namedWidgets = this.getNamedWidgets(thinletFile);
        this.setup();
        this.begin(thinletFile.getName());
        FileReader fileReader = new FileReader(thinletFile);
        ThinletReader thinletReader = new ThinletReader();
        thinletReader.parse(fileReader, new ThinletReader.SAXHandler(){

            @Override
            public void startElement(String componentclassname, Hashtable attributelist) {
                ThinletDTD.Widget widget = ThinletDTD.getWidget(componentclassname);
                ThinletDTD.Property[] props = widget.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    String methodDecl;
                    if (props[i].getType() != 8 || (methodDecl = (String)attributelist.get(props[i].getName())) == null || methodDecl.length() <= 0) continue;
                    String componentname = (String)attributelist.get("name");
                    try {
                        Generator.this.method(methodDecl, props[i].getName(), componentname, componentclassname, namedWidgets);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("I/O Error", e);
                    }
                }
            }

            @Override
            public void endElement() {
            }
        });
        fileReader.close();
        this.finish(thinletFile.getName());
    }

    private HashMap getNamedWidgets(File thinletFile) throws IOException, ParseException {
        final HashMap namedWidgets = new HashMap();
        FileReader fileReader = new FileReader(thinletFile);
        ThinletReader thinletReader = new ThinletReader();
        thinletReader.parse(fileReader, new ThinletReader.SAXHandler(){

            @Override
            public void startElement(String componentclassname, Hashtable attributelist) {
                String name = (String)attributelist.get("name");
                if (name != null) {
                    ThinletDTD.Widget widget = ThinletDTD.getWidget(componentclassname);
                    namedWidgets.put(name, widget);
                }
            }

            @Override
            public void endElement() {
            }
        });
        fileReader.close();
        if (Generator.debug()) {
            log.fine("named widgets: " + namedWidgets);
        }
        return namedWidgets;
    }

    private void method(String methodDecl, String methodpropertyname, String componentname, String componentclassname, HashMap namedWidgets) throws IOException {
        MethodInfo info;
        if (componentname != null && componentname.length() == 0) {
            componentname = null;
        }
        if (this.methods.contains(info = MethodInfo.parseMethodDecl(methodDecl, methodpropertyname, componentname, componentclassname, namedWidgets))) {
            if (Generator.debug()) {
                log.fine("method already in set: " + info);
            }
            info.generalize();
            this.methods.remove(info);
            this.methods.add(info);
        } else {
            if (Generator.debug()) {
                log.fine("adding method \"" + info.getSignature(true) + "\" from " + info.toString());
            }
            this.methods.add(info);
        }
    }

    private void setup() throws IOException {
        if (this.handlerClassname == null && this.interfaceName == null) {
            throw new IllegalArgumentException("specify either handlerClassname or interfaceName, or both");
        }
        if (this.handlerClassname == null && this.asThinlet) {
            throw new IllegalArgumentException("option asThinlet only valid for handler generation");
        }
        if (this.handlerClassname == null && this.generateMain) {
            throw new IllegalArgumentException("option generateMain only valid for handler generation");
        }
        if (this.interfaceName != null && this.interfaceWriter == null) {
            if (this.outputDir == null) {
                throw new IllegalArgumentException("specify either outputDir or interfaceWriter");
            }
            this.interfaceWriter = new FileWriter(new File(this.outputDir, this.interfaceName + ".java"));
        }
        if (this.handlerClassname != null && this.handlerWriter == null) {
            if (this.outputDir == null) {
                throw new IllegalArgumentException("specify either outputDir or handlerWriter");
            }
            this.handlerWriter = new FileWriter(new File(this.outputDir, this.handlerClassname + ".java"));
        }
        this.methods = new TreeSet();
    }

    private void begin(String thinletFilename) throws IOException {
        if (this.interfaceWriter != null) {
            this.writeInterfaceHeader(thinletFilename);
        }
        if (this.handlerWriter != null) {
            this.writeHandlerHeader(thinletFilename);
        }
    }

    private void writeInterfaceHeader(String thinletFilename) throws IOException {
        String javadoc = "Interface for the callback methods in \"<code>" + thinletFilename + "</code>\".";
        this.writeHeader(this.interfaceWriter, javadoc, "");
        this.interfaceWriter.write(Generator.msg("interface.signature", this.interfaceName));
    }

    private void writeHandlerHeader(String thinletFilename) throws IOException {
        String additionalImport = this.generateMain ? "import thinlet.FrameLauncher;" : "";
        String javadoc = this.asThinlet ? "A thinlet with the contents of \"<code>" + thinletFilename + "</code>\"." : "Callback handler class for the methods in \"<code>" + thinletFilename + "</code>\".";
        this.writeHeader(this.handlerWriter, javadoc, additionalImport);
        String extendsClause = this.asThinlet ? " extends Thinlet" : "";
        String implementsClause = this.interfaceName != null ? " implements " + this.interfaceName : "";
        this.handlerWriter.write(Generator.msg("handler.signature", this.handlerClassname, extendsClause, implementsClause));
        if (this.asThinlet) {
            this.handlerWriter.write(Generator.msg("class.asThinlet.constructor", this.handlerClassname, thinletFilename));
        }
    }

    private void writeHeader(Writer writer, String javadocComment, String additionalImport) throws IOException {
        if (this.generateFirstLine) {
            writer.write(Generator.msg("file.header.firstline", new Date()));
        }
        if (this.packageName != null) {
            writer.write(Generator.msg("file.header.package", this.packageName));
        }
        writer.write(Generator.msg("file.header", additionalImport, javadocComment));
    }

    private void writeMethods(Writer writer, boolean asInterface) throws IOException {
        Iterator it = this.methods.iterator();
        while (it.hasNext()) {
            this.writeMethod(writer, (MethodInfo)it.next(), asInterface);
        }
    }

    private void writeMethod(Writer writer, MethodInfo info, boolean asInterface) throws IOException {
        writer.write(info.getJavaDocComment());
        if (asInterface) {
            writer.write(Generator.msg("method.body.interface", info.getSignature(true)));
        } else {
            writer.write(Generator.msg("method.body.handler", info.getSignature(true)));
        }
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write(Generator.msg("file.footer"));
        writer.flush();
        writer.close();
    }

    private void finish(String thinletFilename) throws IOException {
        if (this.interfaceWriter != null) {
            this.writeMethods(this.interfaceWriter, true);
            this.writeFooter(this.interfaceWriter);
            this.interfaceWriter = null;
        }
        if (this.handlerWriter != null) {
            this.writeMethods(this.handlerWriter, false);
            if (this.generateMain) {
                if (this.asThinlet) {
                    this.handlerWriter.write(Generator.msg("main.asThinlet", this.handlerClassname));
                } else {
                    this.handlerWriter.write(Generator.msg("main.notAsThinlet", this.handlerClassname, thinletFilename));
                }
            }
            this.writeFooter(this.handlerWriter);
            this.handlerWriter = null;
        }
    }

    private static String capitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String msg(String key) {
        return Generator.msg(key, null, null, null, null, null);
    }

    private static String msg(String key, Object arg0) {
        return Generator.msg(key, arg0, null, null, null, null);
    }

    private static String msg(String key, Object arg0, Object arg1) {
        return Generator.msg(key, arg0, arg1, null, null, null);
    }

    private static String msg(String key, Object arg0, Object arg1, Object arg2) {
        return Generator.msg(key, arg0, arg1, arg2, null, null);
    }

    private static String msg(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return Generator.msg(key, arg0, arg1, arg2, arg3, null);
    }

    private static String msg(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        try {
            String template = res.getString(key);
            return MessageFormat.format(template, arg0, arg1, arg2, arg3, arg4);
        }
        catch (MissingResourceException e) {
            return "###missing resource key '" + key + "', args=['" + arg0 + "','" + arg1 + "','" + arg2 + "','" + arg3 + "','" + arg4 + "']###";
        }
    }

    public static void main(String[] args) throws IOException, ParseException {
        File thinletFile;
        Generator.initLogging();
        String filename = null;
        String handlerClassname = null;
        String interfaceName = null;
        String packageName = null;
        boolean asThinlet = false;
        boolean generateMain = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.equals("--handler")) {
                    if (i < args.length - 1) {
                        handlerClassname = args[++i];
                        continue;
                    }
                    Generator.error("option --handler must be followed by a class name");
                    continue;
                }
                if (arg.equals("--interface")) {
                    if (i < args.length - 1) {
                        interfaceName = args[++i];
                        continue;
                    }
                    Generator.error("option --interface must be followed by a class name");
                    continue;
                }
                if (arg.equals("--package")) {
                    if (i < args.length - 1) {
                        packageName = args[++i];
                        continue;
                    }
                    Generator.error("option --package must be followed by a package name");
                    continue;
                }
                if (arg.equals("--asThinlet")) {
                    asThinlet = true;
                    continue;
                }
                if (arg.equals("--generateMain")) {
                    generateMain = true;
                    continue;
                }
                if (arg.equals("--help")) {
                    Generator.usage(0);
                    continue;
                }
                Generator.error("unknown option: " + arg);
                continue;
            }
            if (arg.startsWith("-")) {
                Generator.error("unknown option: " + arg);
                continue;
            }
            if (filename != null) {
                Generator.error("specify exactly one thinlet file");
                continue;
            }
            filename = arg;
        }
        if (filename == null) {
            Generator.error("no thinlet file given");
        }
        if (handlerClassname == null && interfaceName == null) {
            Generator.error("specify either --handler or --interface, or both");
        }
        if (handlerClassname == null && asThinlet) {
            Generator.error("option --asThinlet only valid for --handler generation");
        }
        if (handlerClassname == null && generateMain) {
            Generator.error("option --generateMain only valid for --handler generation");
        }
        if (!(thinletFile = new File(filename)).isAbsolute()) {
            thinletFile = new File(System.getProperty("user.dir"), filename);
        }
        File outputDir = thinletFile.getParentFile();
        Generator generator = new Generator();
        generator.setHandlerClassname(handlerClassname);
        generator.setInterfaceName(interfaceName);
        generator.setPackageName(packageName);
        generator.setGenerateAsThinlet(asThinlet);
        generator.setGenerateMain(generateMain);
        generator.setOutputDirectory(outputDir);
        generator.generate(thinletFile);
        System.exit(0);
    }

    private static void error(String msg) {
        System.err.println("Error: " + msg);
        System.err.println();
        System.exit(2);
    }

    private static void usage(int exitStatus) {
        System.out.println("ThinG Generator");
        System.out.println("Usage: java thing.Generator [options] thinlet-file");
        System.out.println("Options:");
        System.out.println("  --handler name     Generate handler class <name>");
        System.out.println("  --interface name   Generate interface <name> for handler class");
        System.out.println("  --package name     Generated code is in package <name>");
        System.out.println("  --asThinlet        Handler class is a Thinlet");
        System.out.println("  --generateMain     Generate main()");
        System.out.println();
        System.out.println("  Either --handler or --interface must be specified, or both.");
        System.out.println("  Options --asThinlet and --generateMain are only valid if --handler is set.");
        System.out.println();
        System.exit(exitStatus);
    }

    private static void initLogging() {
        log = Logger.getLogger("thing");
        InputStream is = Main.class.getResourceAsStream("/logging.properties");
        if (is != null) {
            try {
                LogManager.getLogManager().readConfiguration(is);
                log = Logger.getLogger("thing");
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error reading /logging.properties from classpath", e);
                log.log(Level.SEVERE, "Using default logger.");
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            log.log(Level.SEVERE, "Error reading /logging.properties from classpath; could not find /logging.properties");
            log.log(Level.SEVERE, "Using default logger.");
        }
    }

    private static class MethodInfo
    implements Comparable {
        private String methodDecl;
        private String methodpropertyname;
        private String componentname;
        private String componentclassname;
        private String methodname;
        private ArgInfo[] args;

        private MethodInfo() {
        }

        private static MethodInfo parseMethodDecl(String methodDecl, String methodpropertyname, String componentname, String componentclassname, HashMap namedWidgets) {
            MethodInfo info = new MethodInfo();
            info.methodDecl = methodDecl;
            info.methodpropertyname = methodpropertyname;
            info.componentname = componentname;
            info.componentclassname = componentclassname;
            StringTokenizer st = new StringTokenizer(methodDecl, "(, \r\n\t)");
            int n = st.countTokens();
            info.methodname = st.nextToken();
            info.args = new ArgInfo[n - 1];
            int i = 0;
            while (st.hasMoreTokens()) {
                String arg = st.nextToken();
                info.args[i] = new ArgInfo();
                if ("thinlet".equals(arg)) {
                    info.args[i].isThinlet = true;
                    info.args[i].paramclassname = "Thinlet";
                    info.args[i].paramname = "thinlet";
                } else {
                    ThinletDTD.Widget widget;
                    String compname;
                    int dot = arg.indexOf(46);
                    String string = compname = dot == -1 ? arg : arg.substring(0, dot);
                    if ("item".equals(compname)) {
                        info.args[i].componentclassname = componentclassname;
                        info.args[i].isItem = true;
                        info.args[i].paramname = (componentname != null ? componentname : "a" + Generator.capitalize(componentclassname)) + "Item";
                        if ("list".equals(componentclassname)) {
                            info.args[i].itemclassname = "item";
                        } else if ("tree".equals(componentclassname)) {
                            info.args[i].itemclassname = "node";
                        } else if ("table".equals(componentclassname)) {
                            info.args[i].itemclassname = "row";
                        } else if ("combobox".equals(componentclassname)) {
                            info.args[i].itemclassname = "choice";
                        } else if ("tabbedpane".equals(componentclassname)) {
                            info.args[i].itemclassname = "tab";
                        } else {
                            throw new IllegalArgumentException(componentclassname + " has no item");
                        }
                        widget = ThinletDTD.getWidget(info.args[i].itemclassname);
                    } else if ("this".equals(compname)) {
                        widget = ThinletDTD.getWidget(componentclassname);
                        info.args[i].componentclassname = componentclassname;
                        info.args[i].paramname = componentname != null ? componentname : "a" + Generator.capitalize(componentclassname);
                        info.args[i].reference = componentname;
                    } else {
                        widget = (ThinletDTD.Widget)namedWidgets.get(compname);
                        if (widget == null) {
                            throw new IllegalArgumentException("named component not found: " + compname + ", in method: " + methodDecl);
                        }
                        info.args[i].componentclassname = widget.getClassname();
                        info.args[i].paramname = compname;
                        info.args[i].reference = compname;
                    }
                    if (dot == -1) {
                        info.args[i].isObject = true;
                        info.args[i].paramclassname = "Object";
                    } else {
                        String propName;
                        info.args[i].propertyname = propName = arg.substring(dot + 1);
                        ThinletDTD.Property property = widget.getProperty(propName);
                        if (property == null) {
                            throw new IllegalArgumentException("property not found: " + propName + ", at token: " + arg + ", in method: " + methodDecl);
                        }
                        info.args[i].paramname = info.args[i].paramname + Generator.capitalize(property.getName());
                        switch (property.getType()) {
                            case 0: 
                            case 3: {
                                info.args[i].paramclassname = "String";
                                break;
                            }
                            case 1: {
                                info.args[i].paramclassname = "int";
                                break;
                            }
                            case 2: {
                                info.args[i].paramclassname = "boolean";
                                break;
                            }
                            case 5: {
                                info.args[i].paramclassname = "java.awt.Image";
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("unsupported property type: " + property.getTypeName());
                            }
                        }
                    }
                }
                ++i;
            }
            info.makeParamNamesUnique();
            return info;
        }

        private void makeParamNamesUnique() {
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < this.args.length; ++i) {
                while (names.contains(this.args[i].getParamName())) {
                    ++this.args[i].nameDuplicateCount;
                }
                names.add(this.args[i].getParamName());
            }
        }

        public void generalize() {
            this.componentclassname = null;
            this.methodpropertyname = null;
            this.componentname = null;
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i].generalize();
            }
        }

        public String getSignature(boolean withParamNames) {
            StringBuffer buf = new StringBuffer(this.methodname).append("(");
            for (int i = 0; i < this.args.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.args[i].getSignature(withParamNames));
            }
            buf.append(")");
            return buf.toString();
        }

        public String getJavaDocComment() {
            StringBuffer buf = new StringBuffer();
            buf.append("Callback handler");
            if (this.methodpropertyname != null) {
                buf.append(" for the '").append(this.methodpropertyname).append("' method of ");
                if (this.componentname != null) {
                    buf.append(this.componentclassname).append(" '").append(this.componentname).append("'");
                } else {
                    buf.append("an unnamed ").append(this.componentclassname);
                }
            }
            buf.append(".");
            StringBuffer javadoc = new StringBuffer();
            javadoc.append(Generator.msg("method.javadoc.header", buf.toString()));
            if (this.args.length > 0) {
                javadoc.append(Generator.msg("method.javadoc.param.intro"));
                for (int i = 0; i < this.args.length; ++i) {
                    javadoc.append(Generator.msg("method.javadoc.param", this.args[i].getParamName(), this.args[i].getJavaDocComment()));
                }
            }
            javadoc.append(Generator.msg("method.javadoc.footer"));
            return javadoc.toString();
        }

        public int compareTo(Object obj) {
            MethodInfo other = (MethodInfo)obj;
            return this.getSignature(false).compareTo(other.getSignature(false));
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodInfo) {
                return this.getSignature(false).equals(((MethodInfo)obj).getSignature(false));
            }
            return false;
        }

        public int hashCode() {
            return this.getSignature(false).hashCode();
        }

        public String toString() {
            return new StringBuffer("MethodInfo[methodDecl=").append(this.methodDecl).append(", methodpropertyname=").append(this.methodpropertyname).append(", componentname=").append(this.componentname).append(", componentclassname=").append(this.componentclassname).append(", methodname=").append(this.methodname).append(", args=").append(Arrays.asList(this.args)).append("]").toString();
        }
    }

    private static class ArgInfo {
        String paramclassname;
        String paramname;
        String componentclassname;
        boolean isThinlet = false;
        boolean isItem = false;
        boolean isObject = false;
        String reference;
        String propertyname;
        String itemclassname;
        int nameDuplicateCount = 0;

        private ArgInfo() {
        }

        public String getParamName() {
            return this.nameDuplicateCount == 0 ? this.paramname : this.paramname + this.nameDuplicateCount;
        }

        public String getSignature(boolean withParamNames) {
            StringBuffer buf = new StringBuffer(this.paramclassname);
            if (withParamNames) {
                buf.append(' ').append(this.getParamName());
            }
            return buf.toString();
        }

        public String getJavaDocComment() {
            if (this.isThinlet) {
                return "the thinlet.";
            }
            StringBuffer buf = new StringBuffer();
            if (!this.isObject) {
                buf.append("the ").append(this.propertyname).append(" property of ");
            }
            if (this.isItem) {
                buf.append("the selected ").append(this.itemclassname);
            } else if (this.reference != null) {
                buf.append("the ").append(this.componentclassname).append(" named '").append(this.reference).append("'");
            } else {
                buf.append("a ").append(this.componentclassname);
            }
            buf.append('.');
            return buf.toString();
        }

        public void generalize() {
            this.reference = null;
            this.paramname = this.isItem ? "a" + Generator.capitalize(this.itemclassname) : "a" + Generator.capitalize(this.componentclassname);
            if (!this.isObject) {
                this.paramname = this.paramname + Generator.capitalize(this.propertyname);
            }
        }

        public String toString() {
            return new StringBuffer("ArgInfo[paramclassname=").append(this.paramclassname).append(", paramname=").append(this.getParamName()).append(", componentclassname=").append(this.componentclassname).append(", isThinlet=").append(this.isThinlet).append(", isObject=").append(this.isObject).append(", isItem=").append(this.isItem).append(", reference=").append(this.reference).append(", propertyname=").append(this.propertyname).append(", itemclassname=").append(this.itemclassname).append("]").toString();
        }
    }
}

