/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import thing.ComponentChooser;
import thing.GenerateDialog;
import thing.Main;
import thing.PropertyManager;
import thing.Serializer;
import thing.Settings;
import thing.SettingsDialog;
import thing.ThinletDTD;
import thing.ThinletReader;
import thing.ThinletWorkarounds;
import thinlet.Thinlet;
import thinletcommons.ColorChooser;
import thinletcommons.ExtensionFileFilter;
import thinletcommons.FileChooser;
import thinletcommons.FileFilter;
import thinletcommons.FontChooser;
import thinletcommons.MessageDialog;
import utils.AWTUtils;

public class Handler {
    private static final Logger log = Logger.getLogger("thing");
    private static final int TAB_XML = 0;
    private static final int TAB_PREVIEW = 1;
    private Thinlet thinlet;
    private HashMap components = new HashMap();
    private PropertyManager propmgr;
    private File file;
    private boolean isChanged = false;
    private String clipboard;
    private Object root;
    private Object preview;
    private Object tree;
    private Object props;
    private Object tabs;
    private Object statusbar;
    private Object toolbar;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    Handler(Thinlet thinlet) {
        this.thinlet = thinlet;
        this.init();
        this.setStatusText("ThinG v" + Main.getVersion() + " - created by Dirk Moebius (dmoebius@gmx.net)");
    }

    public void menu_file_new() {
        if (!this.checkForChanges()) {
            return;
        }
        this.setSelectedFile(null);
        this.init();
        this.setChanged(false);
        this.setStatusText("New gui created.");
    }

    public void menu_file_open() {
        if (!this.checkForChanges()) {
            return;
        }
        File selectedFile = Handler.getFile(0, "Load Thinlet XML file...", this.thinlet, this.file);
        if (selectedFile != null) {
            this.setSelectedFile(selectedFile);
            this.load();
        }
    }

    public void menu_file_reload() {
        if (!this.checkForChanges()) {
            return;
        }
        if (this.file != null) {
            this.load();
        }
    }

    public void menu_file_save() {
        this.save(false);
    }

    public void menu_file_save_as() {
        this.save(true);
    }

    public void menu_file_exit() {
        if (this.exit()) {
            System.exit(0);
        }
    }

    public void menu_edit_copy() {
        Object component = this.getSelectedComponent();
        if (component != null) {
            this.clipboard = this.serialize(component);
            StringSelection selection = new StringSelection(this.clipboard);
            this.thinlet.getToolkit().getSystemClipboard().setContents(selection, selection);
            this.updateToolbar(component);
            this.setStatusText("" + ThinletWorkarounds.getTotalCount(this.thinlet, component) + " components copied to system clipboard.");
        }
    }

    public void menu_edit_cut() {
        this.menu_edit_copy();
        this.menu_edit_delete();
    }

    public void menu_edit_paste() {
        if (this.clipboard != null) {
            Object parentTreenode = this.getSelectedTreeNode();
            this.addComponents(parentTreenode, -1, this.clipboard);
            this.setStatusText("Pasted components from internal clipboard.");
        }
    }

    public void menu_edit_paste_systemcb() {
        Transferable transferable = this.thinlet.getToolkit().getSystemClipboard().getContents(this.thinlet);
        if (transferable == null) {
            if (Handler.debug()) {
                log.fine("paste from system clipboard: clipboard is empty");
            }
            this.setStatusText("Note: clipboard is empty");
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            log.warning("paste from system clipboard: clipboard contains something that is not a string");
            this.messagebox("Clipboard Error", "System clipboard does not contain a string.");
            return;
        }
        String text = null;
        try {
            text = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error getting clipboard contents", e);
            this.setStatusText("Error getting clipboard contents: " + e + "   See log for details.");
        }
        if (text != null) {
            Object parentTreenode = this.getSelectedTreeNode();
            this.addComponents(parentTreenode, -1, text);
            this.setStatusText("Pasted components from system clipboard.");
        }
    }

    public void menu_edit_delete() {
        this.removeSelectedComponent();
    }

    public void menu_edit_settings() {
        new SettingsDialog(AWTUtils.getFrame((Component)this.thinlet)).show();
    }

    public void menu_tools_generate() {
        if (this.isEmpty()) {
            this.messagebox("Error", "Nothing to generate.\nPlease add components first.");
        } else {
            new GenerateDialog(AWTUtils.getFrame((Component)this.thinlet), this).show();
        }
    }

    public void menu_help_about() {
        MessageDialog dlg = new MessageDialog(AWTUtils.getFrame((Component)this.thinlet), "About ThinG", AWTUtils.getIcon((Component)this.thinlet, "/thing/icons/thing.gif"), "ThinG v" + Main.getVersion() + "\n" + "\n" + "Created by Dirk Moebius (dmoebius@gmx.net)\n" + "\n" + "ThinG is free software, and you are welcome to redistribute it\n" + "under the terms of the GNU General Public License, Version 2.\n" + "See the license file doc/COPYING.txt for details.\n" + "\n" + "Many thanks to:\n" + "    Robert Bajzat (Thinlet inventor)\n" + "    Wolf Paulus (inventor of the best Thinlet RAD tool available:\n" + "        Theodore, see http://www.carlsbadcubes.com/theodore/)\n");
        dlg.show();
    }

    public void addComponent(Object toolbarButton) {
        String classname = this.getToolbarButtonClassname(toolbarButton);
        Object newNode = null;
        if (this.isEmpty()) {
            newNode = this.addComponentImpl(classname, null, -1, null);
        } else {
            Object parentTreenode = this.getSelectedTreeNode();
            if (parentTreenode != null) {
                newNode = this.addComponentImpl(classname, parentTreenode, -1, null);
            }
        }
        this.setSelectedTreeNode(newNode);
    }

    public void moveComponentUp() {
        this.moveSelectedComponent(-1);
    }

    public void moveComponentDown() {
        this.moveSelectedComponent(1);
    }

    public void treeSelectionChanged() {
        this.thinlet.removeAll(this.props);
        Object component = this.getSelectedComponent();
        if (component != null) {
            this.addTableProperties(component);
        }
        this.updateToolbar(component);
        this.updatePropertyEditor(component, null);
    }

    public void tableSelectionChanged() {
        Object component = this.getSelectedComponent();
        String propName = this.getSelectedPropertyName();
        if (component != null) {
            this.updatePropertyEditor(component, propName);
        }
    }

    public void propEditBooleanChanged(String text, boolean isSelected) {
        boolean value = text.equals("true") && isSelected;
        Object component = this.getSelectedComponent();
        String propName = this.getSelectedPropertyName();
        if (component != null && propName != null) {
            this.propmgr.setValue(component, propName, Boolean.toString(value));
            this.updateTableProperty(component, propName);
            if (Handler.debug()) {
                log.fine("property " + propName + " for component " + ThinletWorkarounds.toString(component) + " changed to " + value);
            }
            this.setStatusText("Component " + ThinletWorkarounds.toString(component) + ": Property " + propName + " changed to " + value);
        }
    }

    public void propEditIntegerChanged(String value) {
        if (value.length() == 0) {
            return;
        }
        Object component = this.getSelectedComponent();
        String propName = this.getSelectedPropertyName();
        if (component != null && propName != null) {
            this.propmgr.setValue(component, propName, value);
            this.updateTableProperty(component, propName);
            if (Handler.debug()) {
                log.fine("property " + propName + " for component " + ThinletWorkarounds.toString(component) + " changed to " + value);
            }
            this.setStatusText("Component " + ThinletWorkarounds.toString(component) + ": Property " + propName + " changed to " + value);
        }
    }

    public void propEditChoiceChanged(Object combobox, int selected) {
        String choice = this.thinlet.getString(this.thinlet.getItem(combobox, selected), "text");
        Object component = this.getSelectedComponent();
        String propName = this.getSelectedPropertyName();
        if (component != null && propName != null && choice != null) {
            this.propmgr.setValue(component, propName, choice);
            this.updateTableProperty(component, propName);
            if (Handler.debug()) {
                log.fine("property " + propName + " for component " + ThinletWorkarounds.toString(component) + " changed to " + choice);
            }
            this.setStatusText("Component " + ThinletWorkarounds.toString(component) + ": Property " + propName + " changed to " + choice);
        }
    }

    public void propEditStringChanged(String text) {
        Object component = this.getSelectedComponent();
        String propName = this.getSelectedPropertyName();
        if (component != null && propName != null && text != null) {
            String classname = Thinlet.getClass((Object)component);
            ThinletDTD.Property property = ThinletDTD.getProperty(classname, propName);
            try {
                switch (property.getType()) {
                    case 0: {
                        this.propmgr.setValue(component, property, text);
                        if (propName.equals("name")) {
                            String nodeText = classname;
                            if (text.length() > 0) {
                                nodeText = nodeText + " [" + text + "]";
                            }
                            this.thinlet.setString(this.getSelectedTreeNode(), "text", nodeText);
                        }
                        break;
                    }
                    case 10: {
                        StringTokenizer st = new StringTokenizer(text, ";");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            int equals = token.indexOf(61);
                            if (equals >= 0) continue;
                            this.messagebox("Input Error", "Token '" + token + "'\nis missing the '=' character.");
                            return;
                        }
                        Enumeration enumx = ThinletWorkarounds.getPropertyKeys(component);
                        while (enumx.hasMoreElements()) {
                            this.thinlet.putProperty(component, (Object)((String)enumx.nextElement()), null);
                        }
                        this.propmgr.setValue(component, property, text);
                        break;
                    }
                    case 7: {
                        this.propmgr.setValue(component, property, text);
                        break;
                    }
                    case 8: {
                        this.propmgr.setValue(component, property, text);
                        break;
                    }
                    case 5: {
                        this.propmgr.setValue(component, property, text);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal property type: " + property.getType());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                StringBuffer errmsg = new StringBuffer("Illegal argument value");
                String exmsg = e.getMessage();
                if (exmsg != null && exmsg.length() > 0) {
                    errmsg.append(" (").append(exmsg).append(").");
                } else {
                    errmsg.append(".");
                }
                this.messagebox("Input Error", errmsg.toString());
                return;
            }
            this.updateTableProperty(component, propName);
            if (Handler.debug()) {
                log.fine("property " + propName + " for component " + ThinletWorkarounds.toString(component) + " changed to " + (text.length() > 20 ? text.substring(0, 20) + "..." : text));
            }
            this.setStatusText("Component " + ThinletWorkarounds.toString(component) + ": Property " + propName + " changed to " + (text.length() > 20 ? text.substring(0, 20) + "..." : text));
        }
    }

    public void propEditChooseButtonClicked() {
        Object component = this.getSelectedComponent();
        String propName = this.getSelectedPropertyName();
        if (component != null && propName != null) {
            String classname = Thinlet.getClass((Object)component);
            ThinletDTD.Property property = ThinletDTD.getProperty(classname, propName);
            switch (property.getType()) {
                case 6: {
                    FontChooser fontchooser = new FontChooser(AWTUtils.getFrame((Component)this.thinlet), "Please choose font:");
                    fontchooser.setSelectedFont(ThinletWorkarounds.getFont(this.thinlet, component, propName));
                    fontchooser.show();
                    Font font = fontchooser.getSelectedFont();
                    if (font == null) break;
                    this.thinlet.setFont(component, propName, font);
                    break;
                }
                case 4: {
                    ColorChooser colorchooser = new ColorChooser(AWTUtils.getFrame((Component)this.thinlet), "Please choose color:");
                    colorchooser.setSelectedColor(ThinletWorkarounds.getColor(component, propName));
                    colorchooser.show();
                    Color color = colorchooser.getSelectedColor();
                    if (color == null) break;
                    this.thinlet.setColor(component, propName, color);
                    break;
                }
                case 11: {
                    ComponentChooser compchooser = new ComponentChooser(AWTUtils.getFrame((Component)this.thinlet), "Please select a named component:", this.getTopComponent(), this.propmgr.getValueString(component, "name"));
                    compchooser.setSelectedComponent(this.propmgr.getValueString(component, property));
                    compchooser.show();
                    if (compchooser.isCancelled()) break;
                    this.propmgr.setValue(component, property, compchooser.getSelectedComponent());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected property type: " + property.getType());
                }
            }
            this.updateTableProperty(component, propName);
            if (Handler.debug()) {
                log.fine("property " + propName + " for component " + ThinletWorkarounds.toString(component) + " changed to " + this.propmgr.getValueString(component, propName));
            }
            this.setStatusText("Component " + ThinletWorkarounds.toString(component) + ": Property " + propName + " changed.");
        }
    }

    public void propEditReset() {
        Object component = this.getSelectedComponent();
        String propName = this.getSelectedPropertyName();
        if (component != null && propName != null) {
            ThinletDTD.Property property = PropertyManager.getProperty(component, propName);
            String defaultValue = PropertyManager.getDefaultValueString(property);
            this.propmgr.setValue(component, property, defaultValue);
            this.updateTableProperty(component, propName);
            this.updatePropertyEditor(component, propName);
            this.setStatusText("Component " + ThinletWorkarounds.toString(component) + ": Property " + propName + " reset to default value \"" + defaultValue + "\".");
        }
    }

    public void tabSelected(int tabNo) {
        if (Handler.debug()) {
            log.fine("tab selected: " + tabNo);
        }
        if (tabNo == 0) {
            Object component = this.getTopComponent();
            Object xmltext = this.thinlet.find("serialize");
            if (component != null) {
                this.thinlet.setString(xmltext, "text", this.serialize(component));
            } else {
                this.thinlet.setString(xmltext, "text", "");
            }
        }
    }

    public void focusgained(Object component) {
        Object treenode = this.getTreeNodeForComponent(component);
        this.setSelectedTreeNode(treenode);
    }

    boolean exit() {
        boolean stateOk = this.checkForChanges();
        if (stateOk) {
            log.info("ThinG exits.");
        }
        return stateOk;
    }

    Object getTopComponent() {
        Object treenode = this.thinlet.getItem(this.tree, 0);
        return treenode != null ? this.getComponentForNode(treenode) : null;
    }

    Thinlet getThinlet() {
        return this.thinlet;
    }

    PropertyManager getPropertyManager() {
        return this.propmgr;
    }

    File getCurrentFile() {
        return this.file;
    }

    void setStatusText(String text) {
        this.thinlet.setString(this.statusbar, "text", text);
    }

    private Object addComponentImpl(String classname, Object parentTreenode, int index, Hashtable attributes) {
        ThinletDTD.Widget widget;
        if (classname.equals("bean")) {
            throw new IllegalArgumentException("Sorry, the <bean> element is not support yet.");
        }
        Object newNode = Thinlet.create((String)"node");
        Object newComponent = Thinlet.create((String)classname);
        if (parentTreenode == null) {
            if (!this.isAddAllowed(classname, null)) {
                throw new IllegalArgumentException("<" + classname + "> may not be added add top-level.");
            }
            this.thinlet.add(this.preview, newComponent);
            this.thinlet.add(this.tree, newNode);
        } else {
            int count;
            Object containerComponent = this.getComponentForNode(parentTreenode);
            if (!this.isAddAllowed(classname, containerComponent)) {
                throw new IllegalArgumentException("<" + classname + "> may not be added to <" + Thinlet.getClass((Object)containerComponent) + ">");
            }
            if ("header".equals(classname)) {
                index = 0;
            } else if ("popupmenu".equals(classname)) {
                index = -1;
            } else if ((index == 0 || index == -1) && (count = this.thinlet.getCount(parentTreenode)) > 0) {
                if (index == 0 && Thinlet.getClass((Object)this.getComponentForNode(this.thinlet.getItem(parentTreenode, index))).equals("header")) {
                    if (++index >= count) {
                        index = -1;
                    }
                } else if (index == -1 && Thinlet.getClass((Object)this.getComponentForNode(this.thinlet.getItem(parentTreenode, count - 1))).equals("popupmenu")) {
                    index = count - 1;
                }
            }
            this.thinlet.add(containerComponent, newComponent, index);
            this.thinlet.add(parentTreenode, newNode, index);
        }
        this.components.put(newNode, newComponent);
        String nodeText = classname;
        if (attributes != null && attributes.get("name") != null) {
            nodeText = nodeText + " [" + attributes.get("name") + "]";
        }
        this.thinlet.setString(newNode, "text", nodeText);
        this.setChanged(true);
        if (attributes != null) {
            Enumeration keys = attributes.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)attributes.get(key);
                this.propmgr.setValue(newComponent, key, value);
            }
        }
        if ((widget = ThinletDTD.getWidget(classname)).isInstanceOf("component")) {
            this.thinlet.setMethod(newComponent, "focusgained", "focusgained(this)", this.root, (Object)this);
        }
        return newNode;
    }

    private void updatePropertyEditor(Object component, String propName) {
        Object propedit_panel = this.thinlet.find("propedit_panel");
        this.thinlet.removeAll(propedit_panel);
        if (propName == null) {
            this.thinlet.setString(this.thinlet.find("propedit_name"), "text", "");
            this.thinlet.setBoolean(this.thinlet.find("propedit_reset"), "enabled", false);
            return;
        }
        String classname = Thinlet.getClass((Object)component);
        ThinletDTD.Property property = ThinletDTD.getProperty(classname, propName);
        Object value = this.propmgr.getValue(component, property);
        if (Handler.debug()) {
            log.fine("setup property: " + propName + " for component: " + ThinletWorkarounds.toString(component));
        }
        this.thinlet.setString(this.thinlet.find("propedit_name"), "text", propName + ":");
        this.thinlet.setBoolean(this.thinlet.find("propedit_reset"), "enabled", true);
        switch (property.getType()) {
            case 0: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                Object textfield = Thinlet.create((String)"textfield");
                this.thinlet.add(propedit_panel, textfield);
                this.thinlet.setString(textfield, "text", this.propmgr.getValueString(component, property));
                this.thinlet.setChoice(textfield, "valign", "center");
                this.thinlet.setInteger(textfield, "weightx", 1);
                this.thinlet.setInteger(textfield, "weighty", 1);
                this.thinlet.setMethod(textfield, "perform", "propEditStringChanged(this.text)", this.root, (Object)this);
                break;
            }
            case 2: {
                Object boolTrue = Thinlet.create((String)"checkbox");
                Object boolFalse = Thinlet.create((String)"checkbox");
                this.thinlet.add(propedit_panel, boolTrue);
                this.thinlet.add(propedit_panel, boolFalse);
                this.thinlet.setString(boolTrue, "text", "true");
                this.thinlet.setString(boolTrue, "group", "propedit_panel");
                this.thinlet.setChoice(boolTrue, "valign", "center");
                this.thinlet.setInteger(boolTrue, "weighty", 1);
                this.thinlet.setInteger(boolTrue, "mnemonic", 0);
                this.thinlet.setMethod(boolTrue, "action", "propEditBooleanChanged(this.text, this.selected)", this.root, (Object)this);
                this.thinlet.setString(boolFalse, "text", "false");
                this.thinlet.setString(boolFalse, "group", "propedit_panel");
                this.thinlet.setChoice(boolFalse, "valign", "center");
                this.thinlet.setInteger(boolFalse, "weighty", 1);
                this.thinlet.setInteger(boolFalse, "mnemonic", 0);
                this.thinlet.setMethod(boolFalse, "action", "propEditBooleanChanged(this.text, this.selected)", this.root, (Object)this);
                if (((Boolean)value).booleanValue()) {
                    this.thinlet.setBoolean(boolTrue, "selected", true);
                    break;
                }
                this.thinlet.setBoolean(boolFalse, "selected", true);
                break;
            }
            case 1: {
                Object spinbox = Thinlet.create((String)"spinbox");
                this.thinlet.add(propedit_panel, spinbox);
                this.thinlet.setString(spinbox, "text", ((Integer)value).toString());
                this.thinlet.setChoice(spinbox, "valign", "center");
                this.thinlet.setInteger(spinbox, "weightx", 1);
                this.thinlet.setInteger(spinbox, "weighty", 1);
                this.thinlet.setMethod(spinbox, "action", "propEditIntegerChanged(this.text)", this.root, (Object)this);
                break;
            }
            case 3: {
                Object combobox = Thinlet.create((String)"combobox");
                this.thinlet.add(propedit_panel, combobox);
                this.thinlet.setString(combobox, "text", (String)value);
                this.thinlet.setBoolean(combobox, "editable", false);
                this.thinlet.setChoice(combobox, "valign", "center");
                this.thinlet.setInteger(combobox, "weightx", 1);
                this.thinlet.setInteger(combobox, "weighty", 1);
                this.thinlet.setMethod(combobox, "action", "propEditChoiceChanged(this, this.selected)", this.root, (Object)this);
                String[] choices = property.getChoices();
                for (int i = 0; i < choices.length; ++i) {
                    Object choice = Thinlet.create((String)"choice");
                    this.thinlet.add(combobox, choice);
                    this.thinlet.setString(choice, "text", choices[i]);
                    if (!((String)value).equals(choices[i])) continue;
                    this.thinlet.setInteger(combobox, "selected", i);
                }
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                Object button = Thinlet.create((String)"button");
                this.thinlet.add(propedit_panel, button);
                this.thinlet.setString(button, "text", "Choose...");
                this.thinlet.setInteger(button, "mnemonic", 0);
                this.thinlet.setMethod(button, "action", "propEditChooseButtonClicked()", this.root, (Object)this);
                Font font = ThinletWorkarounds.getFont(this.thinlet, button, "font");
                font = font.deriveFont(10.0f);
                this.thinlet.setFont(button, font);
                break;
            }
            case 9: {
                Object label = Thinlet.create((String)"label");
                this.thinlet.add(propedit_panel, label);
                this.thinlet.setString(label, "text", this.propmgr.getValueString(component, property));
                this.thinlet.setChoice(label, "valign", "center");
                this.thinlet.setInteger(label, "weightx", 1);
                this.thinlet.setInteger(label, "weighty", 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected property type: " + property.getType());
            }
        }
    }

    private void addTableProperties(Object component) {
        String classname = Thinlet.getClass((Object)component);
        ThinletDTD.Property[] properties = ThinletDTD.getProperties(classname);
        if (Handler.debug()) {
            log.fine("add table properties for component: " + ThinletWorkarounds.toString(component));
        }
        for (int i = 0; i < properties.length; ++i) {
            if (!Handler.shouldShowProperty(classname, properties[i].getName())) continue;
            this.addTableProperty(component, properties[i]);
        }
    }

    private void addTableProperty(Object component, ThinletDTD.Property property) {
        Object row = Thinlet.create((String)"row");
        Object cellName = Thinlet.create((String)"cell");
        Object cellValue = Thinlet.create((String)"cell");
        this.thinlet.add(this.props, row);
        this.thinlet.add(row, cellName);
        this.thinlet.add(row, cellValue);
        this.thinlet.setString(cellName, "text", property.getName());
        this.thinlet.setString(cellValue, "text", this.propmgr.getValueString(component, property));
    }

    private void removeSelectedComponent() {
        Object treenode = this.getSelectedTreeNode();
        Object component = this.getSelectedComponent();
        if (treenode != null && component != null) {
            this.thinlet.remove(treenode);
            this.thinlet.remove(component);
            this.propmgr.removeComponent(component);
            this.components.remove(treenode);
            this.treeSelectionChanged();
            this.setChanged(true);
        }
    }

    private void updateTableProperty(Object component, String propName) {
        Object cellValue = this.getSelectedTableCell(1);
        this.thinlet.setString(cellValue, "text", this.propmgr.getValueString(component, propName));
        this.setChanged(true);
    }

    private static boolean shouldShowProperty(String classname, String prop) {
        if ("for".equals(prop)) {
            return classname.equals("label");
        }
        return !"closable".equals(prop) || !"dialog".equals(classname);
    }

    private Object getComponentForNode(Object treenode) {
        Object component = this.components.get(treenode);
        if (component == null) {
            throw new IllegalArgumentException("something is wrong, no component stored for tree node: " + ThinletWorkarounds.toString(treenode));
        }
        return component;
    }

    private Object getTreeNodeForComponent(Object component) {
        for (Map.Entry entry : this.components.entrySet()) {
            if (entry.getValue() != component) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("something is wrong, no tree node stored for component: " + ThinletWorkarounds.toString(component));
    }

    private void setSelectedTreeNode(Object treenode) {
        ThinletWorkarounds.setSelectedItem(this.thinlet, this.tree, treenode);
        this.treeSelectionChanged();
    }

    private Object getSelectedTreeNode() {
        Object treenode = this.thinlet.getSelectedItem(this.tree);
        return treenode;
    }

    private Object getSelectedComponent() {
        Object treenode = this.getSelectedTreeNode();
        return treenode != null ? this.getComponentForNode(treenode) : null;
    }

    private String getSelectedPropertyName() {
        Object cell = this.getSelectedTableCell(0);
        if (cell != null) {
            return this.thinlet.getString(cell, "text");
        }
        return null;
    }

    private String getSelectedPropertyValue() {
        Object cell = this.getSelectedTableCell(1);
        if (cell != null) {
            return this.thinlet.getString(cell, "text");
        }
        return null;
    }

    private Object getSelectedTableCell(int cellNo) {
        Object row;
        Object treenode = this.getSelectedTreeNode();
        if (treenode != null && (row = this.thinlet.getSelectedItem(this.props)) != null) {
            return this.thinlet.getItem(row, cellNo);
        }
        return null;
    }

    private String getToolbarButtonClassname(Object toolbarButton) {
        if ("separator".equals(Thinlet.getClass((Object)toolbarButton))) {
            return null;
        }
        String classname = (String)this.thinlet.getProperty(toolbarButton, (Object)"classname");
        if (classname == null) {
            String name = this.thinlet.getString(toolbarButton, "name");
            throw new IllegalArgumentException("toolbar button " + name + ": missing classname property");
        }
        return classname;
    }

    private void updateToolbar(Object selectedComponent) {
        String classname;
        ThinletDTD.Widget selectedWidget = null;
        if (selectedComponent != null) {
            selectedWidget = ThinletDTD.getWidget(Thinlet.getClass((Object)selectedComponent));
        }
        Object[] items = this.thinlet.getItems(this.toolbar);
        for (int i = 0; i < items.length; ++i) {
            String classname2 = this.getToolbarButtonClassname(items[i]);
            if (classname2 == null) continue;
            boolean addAllowed = this.isAddAllowed(classname2, selectedComponent, selectedWidget);
            this.thinlet.setBoolean(items[i], "visible", addAllowed);
        }
        this.thinlet.setBoolean(this.thinlet.find("tb_edit_cut"), "enabled", selectedComponent != null);
        this.thinlet.setBoolean(this.thinlet.find("tb_edit_copy"), "enabled", selectedComponent != null);
        this.thinlet.setBoolean(this.thinlet.find("tb_edit_delete"), "enabled", selectedComponent != null);
        this.thinlet.setBoolean(this.thinlet.find("menu_edit_cut"), "enabled", selectedComponent != null);
        this.thinlet.setBoolean(this.thinlet.find("menu_edit_copy"), "enabled", selectedComponent != null);
        this.thinlet.setBoolean(this.thinlet.find("menu_edit_delete"), "enabled", selectedComponent != null);
        this.thinlet.setBoolean(this.thinlet.find("tb_edit_paste"), "enabled", this.clipboard != null);
        this.thinlet.setBoolean(this.thinlet.find("menu_edit_paste"), "enabled", this.clipboard != null);
        this.thinlet.setBoolean(this.thinlet.find("tb_edit_moveup"), "enabled", false);
        this.thinlet.setBoolean(this.thinlet.find("tb_edit_movedown"), "enabled", false);
        if (selectedComponent != null && !"popupmenu".equals(classname = Thinlet.getClass((Object)selectedComponent)) && !"header".equals(classname)) {
            Object treenode = this.getSelectedTreeNode();
            Object parentTreenode = this.thinlet.getParent(treenode);
            int count = this.thinlet.getCount(parentTreenode);
            int index = ThinletWorkarounds.getIndexOfItem(this.thinlet, parentTreenode, treenode);
            String firstNode = count > 0 ? Thinlet.getClass((Object)this.getComponentForNode(this.thinlet.getItem(parentTreenode, 0))) : "";
            String lastNode = count > 0 ? Thinlet.getClass((Object)this.getComponentForNode(this.thinlet.getItem(parentTreenode, count - 1))) : "";
            this.thinlet.setBoolean(this.thinlet.find("tb_edit_moveup"), "enabled", index > 0 && (index != 1 || !firstNode.equals("header")));
            this.thinlet.setBoolean(this.thinlet.find("tb_edit_movedown"), "enabled", index < count - 1 && (index != count - 2 || !lastNode.equals("popupmenu")));
        }
    }

    private void updateTitle() {
        Frame frame = AWTUtils.getFrame((Component)this.thinlet);
        if (frame != null) {
            StringBuffer title = new StringBuffer("ThinG - ");
            if (this.file == null) {
                title.append("[untitled]");
            } else {
                title.append(this.file.getName());
            }
            if (this.isChanged) {
                title.append(" [modified]");
            }
            frame.setTitle(title.toString());
        }
    }

    private boolean isAddAllowed(String classname, Object container) {
        ThinletDTD.Widget containerWidget = null;
        if (container != null) {
            containerWidget = ThinletDTD.getWidget(Thinlet.getClass((Object)container));
        }
        return this.isAddAllowed(classname, container, containerWidget);
    }

    private boolean isAddAllowed(String classname, Object container, ThinletDTD.Widget containerWidget) {
        if (container == null) {
            if (this.thinlet.getCount(this.tree) > 0) {
                return false;
            }
            return "panel".equals(classname) || "desktop".equals(classname) || "dialog".equals(classname) || "splitpane".equals(classname) || "tabbedpane".equals(classname);
        }
        boolean allowed = containerWidget.isSubWidgetAllowed(classname);
        if (!allowed) {
            return false;
        }
        if ("popupmenu".equals(classname) || "header".equals(classname)) {
            return this.thinlet.getWidget(container, classname) == null;
        }
        return true;
    }

    private void init() {
        this.propmgr = new PropertyManager(this.thinlet);
        try {
            if (this.root != null) {
                this.thinlet.remove(this.root);
            }
            this.root = this.thinlet.parse("thing.xml", (Object)this);
            if (Handler.debug()) {
                log.fine("Successfully parsed thing.xml");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing thing.xml", e);
        }
        this.components.clear();
        this.thinlet.add(this.root);
        this.thinlet.repaint(this.root);
        this.preview = this.thinlet.find(this.root, "preview");
        this.tree = this.thinlet.find(this.root, "tree");
        this.props = this.thinlet.find(this.root, "props");
        this.tabs = this.thinlet.find(this.root, "tabs");
        this.statusbar = this.thinlet.find(this.root, "statusbar");
        this.toolbar = this.thinlet.find(this.root, "toolbar");
        this.updateToolbar(null);
        this.updateTitle();
    }

    protected void load() {
        this.init();
        FileReader reader = null;
        try {
            reader = new FileReader(this.file);
            this.addComponents(null, -1, reader);
            this.setChanged(false);
            this.setStatusText(this.file.getAbsolutePath() + " loaded.");
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, "Error loading file " + this.file.getAbsolutePath() + ", at line: " + e.getErrorOffset(), e);
            this.messagebox("I/O Error", "Error loading file\n" + this.file.getAbsolutePath() + ":\n\n" + e.getMessage() + "\nat line: " + e.getErrorOffset() + "\n\nSee log for details.");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading file " + this.file.getAbsolutePath(), e);
            this.messagebox("I/O Error", "Error loading file\n" + this.file.getAbsolutePath() + ":\n\n" + e.toString() + "\n\nSee log for details.");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error closing file " + this.file.getAbsolutePath(), e);
                }
            }
        }
    }

    private void addComponents(Object parentTreenode, int index, String xml) {
        try {
            this.addComponents(parentTreenode, index, new StringReader(xml));
        }
        catch (ParseException e) {
            String text = xml.substring(0, Math.min(100, xml.length())) + (xml.length() >= 100 ? "..." : "");
            log.log(Level.SEVERE, "Error adding components from text, at line: " + e.getErrorOffset() + "\ntext(0,100):\n" + text, e);
            this.messagebox("Error", "Error adding components:\n\n" + e.getMessage() + "\n\nError is at line " + e.getErrorOffset() + " of:\n" + text + "\n\nSee log for details.");
        }
        catch (Exception e) {
            String text = xml.substring(0, Math.min(100, xml.length())) + (xml.length() >= 100 ? "..." : "");
            log.log(Level.SEVERE, "Error adding components from text\ntext(0,100):\n" + text, e);
            this.messagebox("Error", "Error adding components:\n\n" + e.toString() + "\n\nXML:\n" + text + "\n\nSee log for details.");
        }
    }

    private void addComponents(Object parentTreenode, int index, Reader reader) throws Exception {
        ThinletReaderHandler handler = new ThinletReaderHandler(parentTreenode, index);
        ThinletReader thinletreader = new ThinletReader();
        thinletreader.parse(reader, (ThinletReader.SAXHandler)handler);
        this.updateToolbar(this.getSelectedComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean save(boolean askForFile) {
        int answer;
        if (this.isEmpty()) {
            this.messagebox("Save Error", "Cannot save empty document.\nPlease add components first.");
            return false;
        }
        File newFile = this.file;
        if (askForFile || this.file == null) {
            newFile = Handler.getFile(1, "Save As...", this.thinlet, this.file);
        }
        if (newFile == null) {
            return false;
        }
        if (newFile.exists() && !newFile.equals(this.file) && (answer = new MessageDialog(AWTUtils.getFrame((Component)this.thinlet), "File exists", "File exists.\nOverwrite existing file?", 2).show()) != 2) {
            return false;
        }
        this.setSelectedFile(newFile);
        if (this.file.exists() && !this.file.canWrite()) {
            log.severe("Cannot write to file: " + this.file.getAbsolutePath());
            this.messagebox("I/O Error", "Cannot write to file\n" + this.file.getAbsolutePath());
            return false;
        }
        String text = this.serialize(this.getTopComponent());
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.file));
            writer.write(text);
            this.setChanged(false);
            this.setStatusText(this.file.getAbsolutePath() + " saved.");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error saving file " + this.file.getAbsolutePath(), e);
            this.messagebox("I/O Error", "Error saving file\n" + this.file.getAbsolutePath() + ":\n\n" + e.toString() + "\n\nSee log for details.");
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error closing file " + this.file.getAbsolutePath(), e);
                }
            }
        }
        return false;
    }

    protected void setSelectedFile(File selectedFile) {
        this.file = selectedFile;
    }

    private void setChanged(boolean isChanged) {
        Object component;
        int tabNo;
        if (this.isChanged != isChanged) {
            this.isChanged = isChanged;
            this.updateTitle();
        }
        if ((tabNo = this.thinlet.getInteger(this.tabs, "selected")) == 0 && (component = this.getTopComponent()) != null) {
            this.thinlet.setString(this.thinlet.find("serialize"), "text", this.serialize(component));
        }
    }

    private boolean checkForChanges() {
        if (this.isChanged) {
            String msg = this.file == null ? "Save changes?" : "Save changes to " + this.file.getName() + "?";
            int answer = new MessageDialog(AWTUtils.getFrame((Component)this.thinlet), "File not saved", msg, 3).show();
            if (answer == 1) {
                return false;
            }
            if (answer == 2) {
                return this.save(false);
            }
        }
        return true;
    }

    private static File getFile(int mode, String title, Thinlet thinlet, File defaultFile) {
        FileChooser chooser = new FileChooser(AWTUtils.getFrame((Component)thinlet), title, mode);
        chooser.setFileFilters(new FileFilter[]{new ExtensionFileFilter("xml", "XML files (*.xml)"), new FileFilter(){

            @Override
            public boolean accept(File dir) {
                return true;
            }

            @Override
            public String getDescription() {
                return "All files (*.*)";
            }
        }});
        if (defaultFile != null) {
            chooser.setSelectedFile(defaultFile);
        } else {
            String lastDir = Settings.getLastDir();
            if (lastDir != null) {
                chooser.setSelectedFile(new File(lastDir));
            }
        }
        chooser.show();
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        File dir = selectedFile.isDirectory() ? selectedFile : selectedFile.getParentFile();
        Settings.setLastDir(dir.getAbsolutePath());
        return selectedFile;
    }

    private void moveSelectedComponent(int offset) {
        Object treenode = this.getSelectedTreeNode();
        if (treenode == null) {
            this.setStatusText("No selection.");
            return;
        }
        Object parentTreenode = this.thinlet.getParent(treenode);
        int index = ThinletWorkarounds.getIndexOfItem(this.thinlet, parentTreenode, treenode);
        String xml = this.serialize(this.getSelectedComponent());
        this.removeSelectedComponent();
        this.addComponents(parentTreenode, index + offset, xml);
        treenode = this.thinlet.getItem(parentTreenode, index + offset);
        this.setSelectedTreeNode(treenode);
        if (offset > 0) {
            this.setStatusText("Moved selected component(s) down.");
        } else {
            this.setStatusText("Moved selected component(s) up.");
        }
    }

    private boolean isEmpty() {
        return this.thinlet.getCount(this.tree) == 0;
    }

    private String serialize(Object component) {
        if (Handler.debug()) {
            log.fine("serializing " + ThinletWorkarounds.toString(component) + " ...");
        }
        long start = System.currentTimeMillis();
        String text = new Serializer(this.thinlet, this.propmgr).serialize(component, Settings.getSerializeIndentSize(), Settings.getSerializeIndentChar(), Settings.getSerializeHeader());
        long stop = System.currentTimeMillis();
        if (Handler.debug()) {
            log.fine("serialize took " + (stop - start) + "ms.");
        }
        return text;
    }

    private void messagebox(String title, String msg) {
        this.setStatusText(title + ": " + msg.replace('\n', ' ').replace('\r', ' '));
        new MessageDialog(AWTUtils.getFrame((Component)this.thinlet), title, msg).show();
    }

    private class ThinletReaderHandler
    implements ThinletReader.SAXHandler {
        private Stack stack = new Stack();
        private int index = -1;

        public ThinletReaderHandler() {
        }

        public ThinletReaderHandler(Object parentTreenode, int index) {
            this.index = index;
            this.stack.push(parentTreenode);
        }

        @Override
        public void startElement(String name, Hashtable attributelist) {
            if (Handler.debug()) {
                log.fine("add <" + name + "> " + attributelist);
            }
            Object parentTreenode = this.stack.empty() ? null : this.stack.peek();
            Object newTreeNode = Handler.this.addComponentImpl(name, parentTreenode, this.index, attributelist);
            this.stack.push(newTreeNode);
            this.index = -1;
        }

        @Override
        public void endElement() {
            Object treenode = this.stack.pop();
        }
    }
}

