/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.awt.Component;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import thing.Handler;
import thinletcommons.AntiAliasedThinlet;
import utils.AWTUtils;

public class Main
extends AntiAliasedThinlet {
    private static Logger log;
    private Handler handler = new Handler(this);

    Main() {
    }

    public boolean destroy() {
        return this.handler.exit();
    }

    public static void main(String[] args) {
        Main.initLogging(args);
        log.info("Creating ThinG main application window...");
        Main main = new Main();
        Image icon = AWTUtils.getIcon((Component)((Object)main), "icons/thing.gif");
        log.info("ThinG started.");
    }

    static String getVersion() {
        Properties props = new Properties();
        try {
            props.load(Main.class.getResourceAsStream("version.properties"));
            return props.getProperty("version", "#unknown#");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "error get version from version.properties", e);
            return "#unknown#";
        }
    }

    private static void initLogging(String[] args) {
        log = Logger.getLogger("thing");
        boolean success = false;
        File file = new File(System.getProperty("user.home"), ".thing.logging.properties");
        success = success || Main.readLoggingProperties(file, "Error reading logging properties from file: " + file);
        InputStream is = Main.class.getResourceAsStream("/logging.properties");
        boolean bl = success = success || Main.readLoggingProperties(is, "Error reading /logging.properties from classpath");
        if (!success) {
            log.log(Level.SEVERE, "Using default logger.");
        }
        if (Main.isOptionSet(args, "--debug")) {
            Main.setLoggingDebugLevel();
        }
    }

    private static boolean isOptionSet(String[] args, String option) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(option)) continue;
            return true;
        }
        return false;
    }

    private static void setLoggingDebugLevel() {
        log.log(Level.INFO, "--debug option set; FINEST logging level selected.");
        Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            Logger logger = LogManager.getLogManager().getLogger(loggerName);
            if (logger == null) continue;
            java.util.logging.Handler[] handlers = logger.getHandlers();
            for (int j = 0; j < handlers.length; ++j) {
                handlers[j].setLevel(Level.FINEST);
            }
        }
    }

    private static boolean readLoggingProperties(File file, String errorMsg) {
        if (file.exists() && file.canRead()) {
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                return Main.readLoggingProperties(is, errorMsg);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, errorMsg, e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readLoggingProperties(InputStream is, String errorMsg) {
        if (is != null) {
            try {
                LogManager.getLogManager().readConfiguration(is);
                log = Logger.getLogger("thing");
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, errorMsg, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        log.log(Level.SEVERE, errorMsg);
        log.log(Level.SEVERE, "InputStream is null.");
        return false;
    }
}

