/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.util.logging.Level;
import java.util.logging.Logger;
import thing.ComponentWalker;
import thing.PropertyManager;
import thing.ThinletDTD;
import thinlet.Thinlet;

public class Serializer {
    private static final Logger log = Logger.getLogger("thing");
    private Thinlet thinlet;
    private PropertyManager propertyMgr;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public Serializer(Thinlet thinlet, PropertyManager propertyMgr) {
        this.thinlet = thinlet;
        this.propertyMgr = propertyMgr;
    }

    public String serialize(Object component, int indentSize, char indentChar, String xmlheader) {
        StringBuffer buf = new StringBuffer(xmlheader);
        ComponentWalker walker = new ComponentWalker();
        walker.walk(this.thinlet, component, new SerializeVisitor(buf, indentSize, indentChar));
        return buf.toString();
    }

    private class SerializeVisitor
    implements ComponentWalker.Visitor {
        private StringBuffer buf;
        private int indentSize;
        private char indentChar;

        public SerializeVisitor(StringBuffer buf, int indentSize, char indentChar) {
            this.buf = buf;
            this.indentSize = indentSize;
            this.indentChar = indentChar;
        }

        @Override
        public boolean visit(Object component, int depth) {
            this.indent(depth, this.buf);
            this.buf.append('<');
            String classname = Thinlet.getClass((Object)component);
            this.buf.append(classname);
            ThinletDTD.Property[] props = ThinletDTD.getProperties(classname);
            for (int i = 0; i < props.length; ++i) {
                String componentValue = Serializer.this.propertyMgr.getValueString(component, props[i]);
                if (componentValue == null) continue;
                Serializer.this.propertyMgr;
                String defaultValue = PropertyManager.getDefaultValueString(props[i]);
                if (componentValue.equals(defaultValue)) continue;
                this.buf.append(' ').append(props[i].getName()).append("=\"").append(componentValue).append('\"');
            }
            if (this.hasSubItems(component)) {
                this.buf.append('>');
            } else {
                this.buf.append("/>");
            }
            this.buf.append(System.getProperty("line.separator"));
            return true;
        }

        @Override
        public void leave(Object component, int depth) {
            if (this.hasSubItems(component)) {
                this.indent(depth, this.buf).append("</").append(Thinlet.getClass((Object)component)).append('>').append(System.getProperty("line.separator"));
            }
        }

        private boolean hasSubItems(Object component) {
            if (Serializer.this.thinlet.getWidget(component, "popupmenu") != null) {
                return true;
            }
            if (Serializer.this.thinlet.getWidget(component, "header") != null) {
                return true;
            }
            return Serializer.this.thinlet.getCount(component) > 0;
        }

        private StringBuffer indent(int indentLevel, StringBuffer buf) {
            for (int i = this.indentSize * indentLevel; i > 0; --i) {
                buf.append(this.indentChar);
            }
            return buf;
        }
    }
}

