/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.util.prefs.Preferences;

public class Settings {
    private static final String KEY_PREFS = "thing";
    private static final String KEY_ICON_DIR = "iconDir";
    private static final String KEY_LAST_DIR = "lastDir";
    private static final String KEY_SERIALIZE_INDENT_CHAR = "serializeIndentChar";
    private static final String KEY_SERIALIZE_INDENT_SIZE = "serializeIndentSize";
    private static final String KEY_SERIALIZE_HEADER = "serializeHeader";

    public static final String getIconDir() {
        return Settings.getPreferences().get(KEY_ICON_DIR, ".");
    }

    public static final void setIconDir(String iconDir) {
        Settings.getPreferences().put(KEY_ICON_DIR, iconDir);
    }

    public static final String getLastDir() {
        return Settings.getPreferences().get(KEY_LAST_DIR, System.getProperty("user.home"));
    }

    public static final void setLastDir(String lastDir) {
        Settings.getPreferences().put(KEY_LAST_DIR, lastDir);
    }

    public static final char getSerializeIndentChar() {
        return (char)Settings.getPreferences().getInt(KEY_SERIALIZE_INDENT_CHAR, 32);
    }

    public static final void setSerializeIndentChar(char indentChar) {
        Settings.getPreferences().putInt(KEY_SERIALIZE_INDENT_CHAR, indentChar);
    }

    public static final int getSerializeIndentSize() {
        return Settings.getPreferences().getInt(KEY_SERIALIZE_INDENT_SIZE, 4);
    }

    public static final void setSerializeIndentSize(int indentSize) {
        Settings.getPreferences().putInt(KEY_SERIALIZE_INDENT_SIZE, indentSize);
    }

    public static final String getSerializeHeader() {
        return Settings.getPreferences().get(KEY_SERIALIZE_HEADER, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "<!-- generated by ThinG, the Thinlet GUI editor -->" + System.getProperty("line.separator"));
    }

    public static final void setSerializeHeader(String serializeHeader) {
        Settings.getPreferences().put(KEY_SERIALIZE_HEADER, serializeHeader);
    }

    private static Preferences getPreferences() {
        return Preferences.userRoot().node(KEY_PREFS);
    }
}

