/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Hashtable;
import thinlet.Thinlet;
import utils.ReaderInputStream;

public class ThinletReader {
    public void parse(String xml, SAXHandler handler) throws ParseException {
        this.parse(new StringReader(xml), handler);
    }

    public void parse(Reader reader, SAXHandler handler) throws ParseException {
        LineNumberReader lnr = new LineNumberReader(reader);
        try {
            ThinletParser parser = new ThinletParser(handler);
            parser.parse(new ReaderInputStream(lnr));
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = e.getClass().getName();
            }
            ParseException pe = new ParseException(msg, lnr.getLineNumber());
            pe.setStackTrace(e.getStackTrace());
            throw pe;
        }
    }

    private static class ThinletParser
    extends Thinlet {
        private SAXHandler saxhandler;

        public ThinletParser(SAXHandler saxhandler) {
            this.saxhandler = saxhandler;
        }

        public Object parse(InputStream is, Object handler) throws IOException {
            super.parseXML(is);
            return null;
        }

        protected void startElement(String name, Hashtable attributelist) {
            if (attributelist == null) {
                attributelist = new Hashtable();
            }
            this.saxhandler.startElement(name, attributelist);
        }

        protected void endElement() {
            this.saxhandler.endElement();
        }
    }

    public static interface SAXHandler {
        public void startElement(String var1, Hashtable var2);

        public void endElement();
    }
}

