/*
 * Decompiled with CFR 0.152.
 */
package thinletcommons;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.ThinletDialog;
import utils.AWTUtils;

public class MessageDialog {
    private static final Logger log = Logger.getLogger("thinletcommons");
    public static final int MODE_OK = 0;
    public static final int MODE_OK_CANCEL = 1;
    public static final int MODE_YES_NO = 2;
    public static final int MODE_YES_NO_CANCEL = 3;
    public static final int ACTION_OK = 0;
    public static final int ACTION_CANCEL = 1;
    public static final int ACTION_YES = 2;
    public static final int ACTION_NO = 3;
    private Thinlet thinlet;
    private ThinletDialog dialog;
    private String msg;
    private Image icon;
    private int mode;
    private int returnValue;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public MessageDialog(Dialog owner, String title, String msg) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, null, 0);
    }

    public MessageDialog(Dialog owner, String title, Image icon, String msg) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, icon, 0);
    }

    public MessageDialog(Frame owner, String title, String msg) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, null, 0);
    }

    public MessageDialog(Frame owner, String title, Image icon, String msg) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, icon, 0);
    }

    public MessageDialog(Dialog owner, String title, String msg, int mode) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, null, mode);
    }

    public MessageDialog(Dialog owner, String title, Image icon, String msg, int mode) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, icon, mode);
    }

    public MessageDialog(Frame owner, String title, String msg, int mode) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, null, mode);
    }

    public MessageDialog(Frame owner, String title, Image icon, String msg, int mode) {
        this.dialog = new ThinletDialog(owner, title);
        this.init(msg, icon, mode);
    }

    private void init(String msg, Image icon, int mode) {
        this.thinlet = new AntiAliasedThinlet();
        this.msg = msg;
        this.mode = mode;
        this.icon = icon;
        try {
            Object panel = this.thinlet.parse("/thinletcommons/messagedialog.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing messagedialog.xml", e);
        }
        this.dialog.setContent(this.thinlet);
    }

    public int show() {
        try {
            Dimension dim = AWTUtils.getBounds(this.msg, this.dialog);
            if (MessageDialog.debug()) {
                log.fine("msg width=" + dim.getWidth() + " height=" + dim.getHeight());
            }
            Object message = this.thinlet.find("message");
            this.thinlet.setInteger(message, "width", (int)dim.getWidth() + 30);
            this.thinlet.setInteger(message, "height", (int)dim.getHeight() + 30);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception getting bounds", e);
        }
        this.returnValue = 1;
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
        return this.returnValue;
    }

    public void init(Object iconLabel, Object textarea, Object button1, Object button2, Object button3) {
        Object defaultButton;
        this.thinlet.setString(textarea, "text", this.msg);
        if (this.icon != null) {
            this.thinlet.setIcon(iconLabel, "icon", this.icon);
        }
        switch (this.mode) {
            case 0: {
                this.hideButton(button1);
                this.hideButton(button2);
                this.showButton(button3, "cancel", "Ok", 0, "ok.gif", 0);
                defaultButton = button3;
                break;
            }
            case 1: {
                this.hideButton(button1);
                this.showButton(button2, "default", "Ok", 0, "ok.gif", 0);
                this.showButton(button3, "cancel", "Cancel", 0, "cancel.gif", 1);
                defaultButton = button3;
                break;
            }
            case 2: {
                this.hideButton(button1);
                this.showButton(button2, "normal", "Yes", 0, "ok.gif", 2);
                this.showButton(button3, "normal", "No", 0, "cancel.gif", 3);
                defaultButton = button3;
                break;
            }
            case 3: {
                this.showButton(button1, "normal", "Yes", 0, "ok.gif", 2);
                this.showButton(button2, "normal", "No", 0, "cancel.gif", 3);
                this.showButton(button3, "cancel", "Cancel", 0, null, 1);
                defaultButton = button3;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal message dialog mode: " + this.mode);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageDialog.this.thinlet.requestFocus(defaultButton);
            }
        });
    }

    public void buttonPressed(Object button) {
        this.returnValue = Integer.parseInt((String)this.thinlet.getProperty(button, (Object)"action"));
        this.dialog.setVisible(false);
    }

    private void hideButton(Object button) {
        this.thinlet.setBoolean(button, "visible", false);
        this.thinlet.setChoice(button, "type", "normal");
    }

    private void showButton(Object button, String type, String text, int mnemonic, String icon, int action) {
        this.thinlet.setChoice(button, "type", type);
        this.thinlet.setString(button, "text", text);
        this.thinlet.setInteger(button, "mnemonic", mnemonic);
        if (icon != null) {
            this.thinlet.setIcon(button, "icon", AWTUtils.getIcon((Component)this.dialog, "/thinletcommons/icons/" + icon));
        }
        this.thinlet.putProperty(button, (Object)"action", (Object)Integer.toString(action));
    }
}

