/*
 * Decompiled with CFR 0.152.
 */
package thinletcommons;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import thinlet.Thinlet;

public class ThinletDialog
extends Dialog {
    private static final Logger log = Logger.getLogger("thinletcommons");
    private transient Thinlet content;
    private transient Image doublebuffer;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public ThinletDialog(Frame owner) {
        super(owner, true);
        this.addWindowListener(new WindowHandler());
    }

    public ThinletDialog(Frame owner, String title) {
        super(owner, title, true);
        this.addWindowListener(new WindowHandler());
    }

    public ThinletDialog(Dialog owner) {
        super(owner);
        this.setModal(true);
        this.addWindowListener(new WindowHandler());
    }

    public ThinletDialog(Dialog owner, String title) {
        super(owner, title, true);
        this.addWindowListener(new WindowHandler());
    }

    public void setContent(Thinlet content) {
        this.content = content;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this._addImpl((Component)content, "Center");
        this.pack();
    }

    public Thinlet getContent() {
        return this.content;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.doublebuffer == null) {
            Dimension d = this.getSize();
            this.doublebuffer = this.createImage(d.width, d.height);
        }
        Graphics dg = this.doublebuffer.getGraphics();
        dg.setClip(g.getClipBounds());
        super.paint(dg);
        dg.dispose();
        g.drawImage(this.doublebuffer, 0, 0, this);
    }

    @Override
    public void doLayout() {
        if (this.doublebuffer != null) {
            this.doublebuffer.flush();
            this.doublebuffer = null;
        }
        super.doLayout();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.setContent((Thinlet)comp);
    }

    private void _addImpl(Component comp, String constraints) {
        super.addImpl(comp, constraints, -1);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ThinletDialog.this.setVisible(ThinletDialog.this.content != null && !ThinletDialog.this.content.destroy());
        }
    }
}

