/*
 * Decompiled with CFR 0.152.
 */
package thinletcommons;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import thinlet.Thinlet;

public class ThinletTester {
    private static String file = null;
    private static String thinletClassname = "thinlet.Thinlet";
    private static String handlerClassname = null;

    public static void main(String[] args) throws Throwable {
        ThinletTester.getArgs(args);
        ThinletTester.run();
    }

    private static void getArgs(String[] args) {
        if (args.length < 1 || args.length > 5) {
            ThinletTester.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help")) {
                ThinletTester.usage();
                continue;
            }
            if (args[i].equals("--thinlet")) {
                if (i == args.length - 1) {
                    ThinletTester.usage();
                    continue;
                }
                thinletClassname = args[++i];
                continue;
            }
            if (args[i].equals("--handler")) {
                if (i == args.length - 1) {
                    ThinletTester.usage();
                    continue;
                }
                handlerClassname = args[++i];
                continue;
            }
            if (file == null) {
                file = args[i];
                continue;
            }
            ThinletTester.usage();
        }
        if (file == null) {
            ThinletTester.usage();
        }
    }

    private static void usage() {
        System.out.println("ThinletTester, version 1.0");
        System.out.println();
        System.out.println("Usage: java [-cp <classpath>] thinletcommons.ThinletTester [--thinlet <classname>]");
        System.out.println("         [--handler <classname>] thinletfile.xml");
        System.out.println();
        System.out.println("  --thinlet  Thinlet classname, e.g. thinlet.Thinlet");
        System.out.println("  --handler  Handler classname, e.g. foo.bar.MyHandler");
        System.out.println();
        System.out.println("  The classpath must include both the Thinlet class and the handler class (if");
        System.out.println("  given on the commandline) as well as thinlet.jar.");
        System.out.println("  The specified Thinlet class and Handler class must have a default");
        System.out.println("  constructor.");
        System.out.println();
        System.exit(1);
    }

    private static void run() throws Throwable {
        Object result;
        Class<?> thinletClass = Class.forName(thinletClassname);
        Object thinlet = thinletClass.newInstance();
        if (!Thinlet.class.isInstance(thinlet)) {
            System.err.println("error: " + thinletClassname + " is not a Thinlet class.");
            System.exit(2);
        }
        System.out.println("using thinlet class: " + thinletClass.getName());
        Object handler = thinlet;
        if (handlerClassname != null) {
            Class<?> handlerClass = Class.forName(handlerClassname);
            handler = handlerClass.newInstance();
            System.out.println("using handler class: " + handlerClass.getName());
        }
        InputStream is = ThinletTester.getInputStream(file);
        System.out.println("parsing file " + file + " ...");
        Method parseMethod = thinletClass.getMethod("parse", InputStream.class, Object.class);
        try {
            result = parseMethod.invoke(thinlet, is, handler);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        Method addMethod = thinletClass.getMethod("add", Object.class);
        try {
            addMethod.invoke(thinlet, result);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        System.out.println("showing frame...");
        System.out.println("done.");
    }

    private static InputStream getInputStream(String filename) throws Exception {
        return new BufferedInputStream(new FileInputStream(filename));
    }
}

