/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.complexlegend.impl;

import java.text.NumberFormat;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.complexlegend.ComplexLegendItem;
import org.gvsig.complexlegend.impl.ComplexLegendUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComplexLegendItem
implements ComplexLegendItem,
Persistent {
    public static final Logger logger = LoggerFactory.getLogger(DefaultComplexLegendItem.class);
    public static final String COMPLEX_LEGEND_ITEM_PERSISTENCE_DEFINITION_NAME = "ComplexLegendItem";
    private ILegend legend;
    private double maxScale;
    private double minScale;
    private Expression filter;

    public ILegend getLegend() {
        return this.legend;
    }

    public void setLegend(ILegend legend) {
        this.legend = legend;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double maxScale) {
        this.maxScale = maxScale;
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double minScale) {
        this.minScale = minScale;
    }

    public String toString() {
        ILegendPanel legPanel;
        String panel = "";
        if (this.legend != null && (legPanel = ComplexLegendUtils.getLegendPanel(this.legend)) != null) {
            panel = " " + legPanel.getTitle();
        }
        Double mind = this.getMinScale();
        String min = "0";
        if (mind >= 0.0) {
            int mini = mind.intValue();
            min = NumberFormat.getIntegerInstance().format(mini);
        }
        Double maxd = this.getMaxScale();
        String max = "inf";
        if (maxd >= 0.0) {
            int maxi = maxd.intValue();
            max = NumberFormat.getIntegerInstance().format(maxi);
        }
        return "[1:" + min + " - 1:" + max + "]" + panel;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setLegend((ILegend)state.get("legend"));
        this.setMinScale(state.getDouble("minScale"));
        this.setMaxScale(state.getDouble("maxScale"));
        this.setFeatureFilter((Expression)state.get("featureFilter"));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("legend", (Persistent)this.getLegend());
        state.set("minScale", this.getMinScale());
        state.set("maxScale", this.getMaxScale());
        state.set("featureFilter", (Persistent)this.getFeatureFilter());
    }

    public Expression getFeatureFilter() {
        return this.filter;
    }

    public void setFeatureFilter(Expression filter) {
        this.filter = filter;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultComplexLegendItem cloned = (DefaultComplexLegendItem)super.clone();
        cloned.legend = (ILegend)this.legend.clone();
        return cloned;
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(DefaultComplexLegendItem.COMPLEX_LEGEND_ITEM_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(DefaultComplexLegendItem.class, DefaultComplexLegendItem.COMPLEX_LEGEND_ITEM_PERSISTENCE_DEFINITION_NAME, "ComplexLegendItem Persistence definition", null, null);
                definition.addDynFieldObject("legend").setMandatory(true).setClassOfValue(ILegend.class);
                definition.addDynFieldDouble("minScale").setMandatory(true);
                definition.addDynFieldDouble("maxScale").setMandatory(true);
                definition.addDynFieldObject("featureFilter").setMandatory(false).setClassOfValue(Expression.class);
            }
            return Boolean.TRUE;
        }
    }
}

