/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.complexlegend.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cresques.cts.ICoordTrans;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.complexlegend.ComplexLegendItem;
import org.gvsig.complexlegend.VectorComplexLegend;
import org.gvsig.complexlegend.impl.DefaultComplexLegendItem;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.operations.IHasImageLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.LegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractVectorialLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.SimpleMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;

public class DefaultVectorComplexLegend
extends AbstractVectorialLegend
implements VectorComplexLegend,
Persistent {
    public static final String COMPLEX_LEGEND_PERSISTENCE_DEFINITION_NAME = "ComplexLegendPersistence";
    public static final String COMPLEX_LEGEND_NAME = "ComplexLegend";
    public static final String COMPLEX_LEGEND_FIELD = "Legends";
    private List<ComplexLegendItem> legends;
    private boolean useDefault;
    private int shapeType;
    private ISymbol defaultSymbol;
    private int currentLegend;
    private LegendContentsChangedListener changeListener;
    private boolean allowOverlap;

    public DefaultVectorComplexLegend() {
        SymbolManager manager = MapContextLocator.getSymbolManager();
        this.defaultSymbol = manager.createSymbol(3);
        this.allowOverlap = true;
        this.currentLegend = -1;
        this.changeListener = new LegendContentsChangedListener(){

            public boolean symbolChanged(SymbolLegendEvent e) {
                DefaultVectorComplexLegend.this.fireDefaultSymbolChangedEvent(e);
                return true;
            }

            public void legendCleared(LegendClearEvent event) {
                DefaultVectorComplexLegend.this.fireDefaultSymbolChangedEvent(new ComplexLegendChangedEvent());
            }
        };
    }

    public List<ComplexLegendItem> getLegends() {
        if (this.legends == null) {
            this.legends = new ArrayList<ComplexLegendItem>();
        }
        return Collections.unmodifiableList(this.legends);
    }

    public List<ComplexLegendItem> getEditedLegends() {
        if (this.legends == null) {
            this.legends = new ArrayList<ComplexLegendItem>();
        }
        return this.legends;
    }

    public boolean isOverlapped(ComplexLegendItem legend) {
        for (ComplexLegendItem aux : this.getLegends()) {
            if (aux.getMinScale() == -1.0 && aux.getMaxScale() > legend.getMinScale()) {
                return true;
            }
            if (aux.getMaxScale() == -1.0 && aux.getMinScale() < legend.getMaxScale()) {
                return true;
            }
            if (aux.getMinScale() >= legend.getMaxScale() || aux.getMaxScale() <= legend.getMinScale()) continue;
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultVectorComplexLegend cloned = (DefaultVectorComplexLegend)((Object)super.clone());
        cloned.defaultSymbol = (ISymbol)this.defaultSymbol.clone();
        cloned.legends = new ArrayList<ComplexLegendItem>();
        if (this.legends != null) {
            for (ComplexLegendItem legend : this.legends) {
                cloned.add((ComplexLegendItem)legend.clone());
            }
        }
        return cloned;
    }

    public boolean add(ComplexLegendItem legend) {
        if (this.legends == null) {
            this.getLegends();
        }
        boolean result = this.legends.add(legend);
        Collections.sort(this.legends, new Comparator<ComplexLegendItem>(){

            @Override
            public int compare(ComplexLegendItem o1, ComplexLegendItem o2) {
                if (o1.getMinScale() == o2.getMinScale()) {
                    return 0;
                }
                return o1.getMinScale() < o2.getMinScale() ? -1 : 1;
            }
        });
        legend.getLegend().addLegendListener(this.changeListener);
        this.fireDefaultSymbolChangedEvent(new ComplexLegendChangedEvent());
        return result;
    }

    public boolean remove(ComplexLegendItem legend) {
        if (this.legends == null) {
            this.getLegends();
        }
        boolean result = this.legends.remove(legend);
        legend.getLegend().removeLegendListener(this.changeListener);
        this.fireDefaultSymbolChangedEvent(new ComplexLegendChangedEvent());
        return result;
    }

    public ComplexLegendItem getLegend(double scale) {
        for (ComplexLegendItem cleg : this.getLegends()) {
            if (!this.isLegendInScale(cleg, scale)) continue;
            return cleg;
        }
        return null;
    }

    private boolean isLegendInScale(ComplexLegendItem cleg, double scale) {
        if (cleg.getMinScale() == -1.0 && cleg.getMaxScale() >= scale) {
            return true;
        }
        if (cleg.getMinScale() <= scale && cleg.getMaxScale() >= scale) {
            return true;
        }
        return cleg.getMinScale() <= scale && cleg.getMaxScale() == -1.0;
    }

    public List<ComplexLegendItem> getLegendsInScale(double scale) {
        Iterator<ComplexLegendItem> it = this.getLegends().iterator();
        ArrayList<ComplexLegendItem> legendsInScale = new ArrayList<ComplexLegendItem>();
        while (it.hasNext()) {
            ComplexLegendItem cleg = it.next();
            if (!this.isLegendInScale(cleg, scale)) continue;
            legendsInScale.add(cleg);
        }
        return legendsInScale;
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, FeatureQuery fquery, PrintAttributes properties) throws LegendException {
        List<ComplexLegendItem> legendsToDraw;
        if (this.getAllowOverlap()) {
            legendsToDraw = this.getLegendsInScale(scale);
        } else {
            legendsToDraw = new ArrayList<ComplexLegendItem>();
            ComplexLegendItem legendInScale = this.getLegend(scale);
            legendsToDraw.add(legendInScale);
        }
        int n = 0;
        for (ComplexLegendItem legend : legendsToDraw) {
            if (legend == null || legend.getLegend() == null) continue;
            this.setCurrentLegend(n);
            if (!(legend.getLegend() instanceof AbstractVectorialLegend)) continue;
            ((AbstractVectorialLegend)legend.getLegend()).print(g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, fquery, properties);
        }
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, PrintAttributes properties) throws LegendException {
        this.print(g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, null, properties);
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore) throws LegendException {
        int n = 0;
        for (ComplexLegendItem legendItem : this.getLegends()) {
            if (legendItem != null && this.isLegendInScale(legendItem, scale)) {
                this.setCurrentLegend(n);
                FeatureQuery query = null;
                Expression filter = legendItem.getFeatureFilter();
                if (!ExpressionUtils.isEmpty((Expression)filter)) {
                    query = featureStore.createFeatureQuery();
                    query.addFilter(filter);
                }
                if (legendItem.getLegend() instanceof AbstractVectorialLegend) {
                    ((AbstractVectorialLegend)legendItem.getLegend()).draw(image, g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, query);
                }
                if (!this.getAllowOverlap()) break;
            }
            ++n;
        }
    }

    protected void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, FeatureQuery featureQuery, double dpi) throws LegendException {
        int n = 0;
        for (ComplexLegendItem legendItem : this.getLegends()) {
            if (legendItem != null && this.isLegendInScale(legendItem, scale)) {
                this.setCurrentLegend(n);
                FeatureQuery query = null;
                Expression filter = legendItem.getFeatureFilter();
                if (!ExpressionUtils.isEmpty((Expression)filter)) {
                    query = featureQuery.getCopy();
                    query.addFilter(filter);
                }
                if (legendItem.getLegend() instanceof AbstractVectorialLegend) {
                    ((AbstractVectorialLegend)legendItem.getLegend()).draw(image, g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, query);
                }
                if (!this.getAllowOverlap()) break;
            }
            ++n;
        }
    }

    private IVectorLegend getCurrentLegend() {
        if (this.currentLegend >= 0 && this.getLegends() != null && !this.getLegends().isEmpty()) {
            return (IVectorLegend)this.getLegends().get(this.currentLegend).getLegend();
        }
        return null;
    }

    private void setCurrentLegend(int legend) {
        this.currentLegend = legend;
    }

    public boolean getAllowOverlap() {
        return this.allowOverlap;
    }

    public void setAllowOverlap(boolean allowOverlap) {
        this.allowOverlap = allowOverlap;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        try {
            this.allowOverlap = state.getBoolean("allowOverlay");
        }
        catch (Exception e) {
            this.allowOverlap = false;
        }
        this.setLegends(state.getList(COMPLEX_LEGEND_FIELD));
    }

    private void setLegends(List list) {
        this.legends = list;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("allowOverlay", this.allowOverlap);
        state.set(COMPLEX_LEGEND_FIELD, this.getEditedLegends());
    }

    public ISymbol getSymbolByFeature(Feature feat) throws MapContextException {
        if (this.getCurrentLegend() != null && this.getCurrentLegend() instanceof IVectorLegend) {
            return this.getCurrentLegend().getSymbolByFeature(feat);
        }
        return null;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int shapeType) {
        this.shapeType = shapeType;
        SymbolManager manager = MapContextLocator.getSymbolManager();
        this.defaultSymbol = manager.createSymbol(shapeType);
    }

    public void setDefaultSymbol(ISymbol s) {
        this.defaultSymbol = s;
    }

    public boolean isUseDefaultSymbol() {
        return this.useDefault;
    }

    public void useDefaultSymbol(boolean b) {
        this.useDefault = b;
    }

    public boolean isSuitableForShapeType(int shapeType) {
        return true;
    }

    public ISymbol getDefaultSymbol() {
        return this.defaultSymbol;
    }

    protected String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (ComplexLegendItem legend : this.legends) {
            if (legend == null || legend.getLegend() == null || !(legend.getLegend() instanceof AbstractVectorialLegend)) continue;
            if (legend.getLegend() instanceof IClassifiedLegend) {
                String[] classifiedDescriptions;
                for (String description : classifiedDescriptions = ((IClassifiedLegend)legend.getLegend()).getDescriptions()) {
                    descriptions.add(description);
                }
                continue;
            }
            descriptions.add(null);
        }
        if (descriptions.isEmpty()) {
            descriptions.add(null);
        }
        return descriptions.toArray(new String[0]);
    }

    public ISymbol[] getSymbols() {
        ArrayList<SimpleImageMarkerSymbol> symbols = new ArrayList<SimpleImageMarkerSymbol>();
        for (ComplexLegendItem legend : this.legends) {
            if (legend == null || legend.getLegend() == null || !(legend.getLegend() instanceof AbstractVectorialLegend)) continue;
            if (legend.getLegend() instanceof IHasImageLegend) {
                symbols.add(new SimpleImageMarkerSymbol((IHasImageLegend)legend.getLegend()));
                continue;
            }
            if (legend.getLegend() instanceof IClassifiedLegend) {
                ISymbol[] classifiedSymbols;
                for (ISymbol classifiedSymbol : classifiedSymbols = ((IClassifiedLegend)legend.getLegend()).getSymbols()) {
                    symbols.add((SimpleImageMarkerSymbol)classifiedSymbol);
                }
                continue;
            }
            symbols.add((SimpleImageMarkerSymbol)((IVectorLegend)legend.getLegend()).getDefaultSymbol());
        }
        if (symbols.isEmpty()) {
            if (this.getDefaultSymbol() != null) {
                symbols.add((SimpleImageMarkerSymbol)this.getDefaultSymbol());
            } else {
                SymbolManager manager = MapContextLocator.getSymbolManager();
                symbols.add((SimpleImageMarkerSymbol)manager.createSymbol(this.shapeType));
            }
        }
        return symbols.toArray(new ISymbol[0]);
    }

    public Object[] getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (ComplexLegendItem legend : this.legends) {
            if (legend == null || legend.getLegend() == null || !(legend.getLegend() instanceof AbstractVectorialLegend)) continue;
            if (legend.getLegend() instanceof IClassifiedLegend) {
                Object[] classifiedValues;
                for (Object classifiedValue : classifiedValues = ((IClassifiedLegend)legend).getValues()) {
                    values.add(classifiedValue);
                }
                continue;
            }
            values.add(null);
        }
        if (values.isEmpty()) {
            values.add(null);
        }
        return values.toArray(new Object[0]);
    }

    private static class SimpleImageMarkerSymbol
    extends SimpleMarkerSymbol {
        private final IHasImageLegend legend;

        public SimpleImageMarkerSymbol(IHasImageLegend legend) {
            this.legend = legend;
        }

        public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature feature, Cancellable cancel) {
            g.drawImage(this.legend.getImageLegend(), 0, 0, null);
        }

        public double getSize() {
            return this.legend.getImageLegend().getWidth(null);
        }
    }

    private static class ComplexLegendChangedEvent
    extends SymbolLegendEvent {
        public ComplexLegendChangedEvent() {
            super(null, null);
        }

        public int getEventType() {
            return 200;
        }
    }

    public static class RegisterLegend
    implements Callable {
        public Object call() throws Exception {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLegend(DefaultVectorComplexLegend.COMPLEX_LEGEND_NAME, DefaultVectorComplexLegend.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(DefaultVectorComplexLegend.COMPLEX_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(DefaultVectorComplexLegend.class, DefaultVectorComplexLegend.COMPLEX_LEGEND_PERSISTENCE_DEFINITION_NAME, "ComplexLegendPersistence Persistence definition", null, null);
                definition.extend(manager.getDefinition("VectorialLegend"));
                definition.addDynFieldList(DefaultVectorComplexLegend.COMPLEX_LEGEND_FIELD).setClassOfItems(DefaultComplexLegendItem.class);
                definition.addDynFieldBoolean("allowOverlay");
            }
            return Boolean.TRUE;
        }
    }
}

