/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.spi.dynformset;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormSet;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynform.AbstractJDynForm;
import org.gvsig.tools.dynform.spi.dynformfield.VisitableSet;
import org.gvsig.tools.dynform.spi.dynformset.ActionStore;
import org.gvsig.tools.dynform.spi.dynformset.DefaultVisitableSet;
import org.gvsig.tools.dynform.spi.dynformset.JDynFormSetFactory;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDynFormSet
implements JDynFormSet {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractJDynFormSet.class);
    private final DynFormSPIManager manager;
    private final JDynFormSetFactory factory;
    private final DynFormDefinition definition;
    protected JComponent contents = null;
    protected List<DynObject> values = null;
    protected VisitableSet listeners = null;
    protected boolean readOnly = false;
    protected boolean autosave = true;
    protected int layoutMode = -1;
    protected int formWidth = -1;
    protected int formHeight = -1;
    protected List<ActionStore> actionsBuffer = new ArrayList<ActionStore>();
    private boolean useScrollBars = true;
    private boolean _allowUpdate;
    private boolean _allowDelete;
    private boolean _allowNew;
    private boolean _allowSearch;
    private boolean _allowClose;
    private boolean _isInNewState = false;
    private final JDynForm.DynFormContext context;
    private final Tags contextTags;

    public AbstractJDynFormSet(DynFormSPIManager manager, JDynFormSetFactory factory, JDynForm.DynFormContext context, DynFormDefinition definition, Tags contextTags) {
        this.manager = manager;
        this.factory = factory;
        this.context = context;
        this.definition = definition;
        this.contextTags = contextTags;
        this.listeners = new DefaultVisitableSet();
    }

    public JDynForm getForm() {
        return null;
    }

    public void fireEvent(String action, Object value) {
    }

    protected JDynFormSetFactory getFactory() {
        return this.factory;
    }

    protected DynFormDefinition getDefinition() {
        return this.definition;
    }

    protected JDynForm.DynFormContext getContext() {
        return this.context;
    }

    public DynFormSPIManager getManager() {
        return this.manager;
    }

    public void loadDefaultValueFromTags(Tags tags) {
        this.setLayoutMode(AbstractJDynForm.getLayoutFromTags(tags));
        this.formWidth = tags.getInt("dynform.width", this.formWidth);
        this.formHeight = tags.getInt("dynform.height", this.formHeight);
        this.readOnly = tags.getBoolean("dynform.readonly", this.readOnly);
        this.autosave = tags.getBoolean("dynform.autosave", this.autosave);
        this.useScrollBars = tags.getBoolean("dynform.useScrollBars", this.useScrollBars);
        this.setAllowNew(tags.getBoolean("dynform.action.new", this._allowNew));
        this.setAllowUpdate(tags.getBoolean("dynform.action.update", this._allowNew));
        this.setAllowDelete(tags.getBoolean("dynform.action.delete", this._allowNew));
        this.setAllowSearch(tags.getBoolean("dynform.action.search", this._allowNew));
        this.setAllowClose(tags.getBoolean("dynform.action.close", this._allowNew));
    }

    public boolean isInNewState() {
        return this._isInNewState;
    }

    protected void enterStateNew() {
        this._isInNewState = true;
    }

    protected void leaveTheNewState() {
        this._isInNewState = false;
    }

    public void addListener(JDynFormSet.JDynFormSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(JDynFormSet.JDynFormSetListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMessageEvent(final String message) {
        try {
            this.listeners.accept(new Visitor(){

                public void visit(Object listener) throws VisitCanceledException, BaseException {
                    ((JDynFormSet.JDynFormSetListener)listener).formMessage(message);
                }
            });
        }
        catch (Exception e) {
            LOGGER.info("Error calling to the form message event.", (Throwable)e);
        }
    }

    protected void fireCloseEvent() {
        try {
            this.listeners.accept(new Visitor(){

                public void visit(Object listener) throws VisitCanceledException, BaseException {
                    ((JDynFormSet.JDynFormSetListener)listener).formClose();
                }
            });
        }
        catch (Exception e) {
            LOGGER.info("Error calling to the form close event.", (Throwable)e);
        }
    }

    protected void fireFormMovedToEvent(final int position) {
        try {
            this.listeners.accept(new Visitor(){

                public void visit(Object listener) throws VisitCanceledException, BaseException {
                    ((JDynFormSet.JDynFormSetListener)listener).formMovedTo(position);
                }
            });
        }
        catch (Exception e) {
            LOGGER.info("Error calling to the form moved to event.", (Throwable)e);
        }
    }

    public int getLayoutMode() {
        if (this.layoutMode == -1) {
            this.loadDefaultValueFromTags(this.definition.getTags());
        }
        return this.layoutMode;
    }

    public void setLayoutMode(int layoutMode) {
        if (layoutMode < 0 || layoutMode > 2) {
            throw new IllegalArgumentException("layoutMode (" + layoutMode + ") out of range. Valid values are 0 .. " + 2 + ".");
        }
        this.layoutMode = layoutMode;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isAutosave() {
        return this.autosave;
    }

    public void setAutosave(boolean autosave) {
        this.autosave = autosave;
    }

    protected int confirmDialog(String message, String title, int optionType, int messageType) {
        return JOptionPane.showConfirmDialog(this.contents, message, title, optionType, messageType);
    }

    public void setFormSize(int width, int height) {
        this.formHeight = height;
        this.formWidth = width;
    }

    public int countValues() {
        return this.values.size();
    }

    public void setValues(DynObjectSet values) {
        DisposableIterator it;
        ArrayList<DynObject> x = new ArrayList<DynObject>();
        try {
            it = values.iterator();
        }
        catch (BaseException e) {
            LOGGER.info("Uf! o se que hacer con este error, lo relanzo sin mas.", (Throwable)e);
            throw new RuntimeException(e);
        }
        while (it.hasNext()) {
            DynObject obj = (DynObject)it.next();
            if (obj instanceof Cloneable) {
                try {
                    obj = (DynObject)((Cloneable)obj).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            x.add(obj);
        }
        this.values = x;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public DynObject get(int position) {
        return this.values.get(position);
    }

    public void addActionToPopupMenu(DataType tipo, String name, Action action) {
        try {
            this.actionsBuffer.add(new ActionStore(tipo, name, action));
        }
        catch (Exception ex) {
            String s = tipo == null ? "(null)" : tipo.getName();
            LOGGER.warn("Can't add popup menu '" + name + "' to the fields of type '" + s + "' of the form.", (Throwable)ex);
        }
    }

    public void addSeparatorToPopupMenu(DataType tipo) {
        try {
            this.actionsBuffer.add(new ActionStore(tipo));
        }
        catch (Exception ex) {
            String s = tipo == null ? "(null)" : tipo.getName();
            LOGGER.warn("Can't add separator to the popup menu to the fields of type '" + s + "' of the form.", (Throwable)ex);
        }
    }

    public void setUseScrollBars(boolean usesScrolls) {
        this.useScrollBars = usesScrolls;
    }

    public boolean getUseScrollBars() {
        return this.useScrollBars;
    }

    public DynFormSPIManager getServiceManager() {
        return this.manager;
    }

    public void message() {
    }

    public void message(String msg) {
    }

    public boolean allowUpdate() {
        return this._allowUpdate;
    }

    public boolean allowClose() {
        return this._allowClose;
    }

    public boolean allowDelete() {
        return this._allowDelete;
    }

    public boolean allowNew() {
        return this._allowNew;
    }

    public boolean allowSearch() {
        return this._allowSearch;
    }

    public void setAllowUpdate(boolean allowUpdate) {
        this._allowUpdate = allowUpdate;
    }

    public void setAllowDelete(boolean allowDelete) {
        this._allowDelete = allowDelete;
    }

    public void setAllowNew(boolean allowNew) {
        this._allowNew = allowNew;
    }

    public void setAllowSearch(boolean allowSearch) {
        this._allowSearch = allowSearch;
    }

    public void setAllowClose(boolean allowClose) {
        this._allowClose = allowClose;
    }

    public void getFormValues(DynObject values) {
        throw new UnsupportedOperationException();
    }

    protected int getTagValueAsInt(String tagname, int defaultVaue) {
        if (this.definition.getTags().has(tagname)) {
            try {
                int value = this.definition.getTags().getInt(tagname);
                return value;
            }
            catch (CoercionException ex) {
                LOGGER.warn("Can't parse tag '" + tagname + "' as int for text field '" + this.definition.getName() + "'.", (Throwable)ex);
            }
        }
        return defaultVaue;
    }

    protected boolean getTagValueAsBoolean(String tagname, boolean defaultVaue) {
        if (this.definition.getTags().has(tagname)) {
            try {
                boolean value = this.definition.getTags().getBoolean(tagname);
                return value;
            }
            catch (CoercionException ex) {
                LOGGER.warn("Can't parse tag '" + tagname + "' as boolean for text field '" + this.definition.getName() + "'.", (Throwable)ex);
            }
        }
        return defaultVaue;
    }

    protected void callUserEvent(String name, Object ... args) {
        JDynForm form = this.getForm();
        form.callUserEvent(name, args);
    }
}

