/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.split.operation;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.vectorediting.lib.prov.split.operation.SplitOperation;

public class CurveSplitOperation
implements SplitOperation {
    @Override
    public Geometry split(Geometry geometryToBeSplitted, Geometry splitter) throws GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        Curve curveToBeSplitted = (Curve)geometryToBeSplitted.cloneGeometry();
        Geometry intersection = geometryToBeSplitted.intersection(splitter);
        if (intersection instanceof Complex) {
            intersection = ((Complex)intersection).createAggregate(7, t -> t.getGeometryType().getType() == 7 || t.getGeometryType().getType() == 1);
        }
        MultiCurve multicurveSplitted = null;
        if (intersection instanceof MultiPoint) {
            MultiPoint intersectionMultiPoint = (MultiPoint)intersection;
            Point firstVertex = intersectionMultiPoint.getPointAt(0);
            Point lastVertex = intersectionMultiPoint.getPointAt(intersectionMultiPoint.getPrimitivesNumber() - 1);
            MultiCurve difference = (MultiCurve)geometryToBeSplitted.difference(splitter);
            if (difference == null) {
                return geometryToBeSplitted;
            }
            if (!(curveToBeSplitted instanceof Line)) {
                curveToBeSplitted = (Curve)curveToBeSplitted.toLines().getPrimitiveAt(0);
            }
            if (!firstVertex.equals(curveToBeSplitted.getVertex(0)) && !lastVertex.equals(curveToBeSplitted.getVertex(0)) && this.isClosed(curveToBeSplitted)) {
                int i;
                Curve firstCurve = difference.getCurveAt(0);
                Curve lastCurve = difference.getCurveAt(difference.getPrimitivesNumber() - 1);
                Line union = GeometryLocator.getGeometryManager().createLine(geometryToBeSplitted.getGeometryType().getSubType());
                for (i = 0; i < lastCurve.getNumVertices(); ++i) {
                    union.addVertex(lastCurve.getVertex(i));
                }
                for (i = 0; i < firstCurve.getNumVertices(); ++i) {
                    union.addVertex(firstCurve.getVertex(i));
                }
                multicurveSplitted = GeometryLocator.getGeometryManager().createMultiCurve(geometryToBeSplitted.getGeometryType().getSubType());
                multicurveSplitted.addCurve((Curve)union);
                for (i = 1; i < difference.getPrimitivesNumber() - 1; ++i) {
                    multicurveSplitted.addCurve(difference.getCurveAt(i));
                }
            }
        }
        if (multicurveSplitted == null) {
            return geometryToBeSplitted.difference(splitter);
        }
        return multicurveSplitted;
    }

    private boolean isClosed(Curve curveToBeSplitted) {
        Point firstPoint = curveToBeSplitted.getVertex(0);
        Point lastPoint = curveToBeSplitted.getVertex(curveToBeSplitted.getNumVertices() - 1);
        return firstPoint.equals(lastPoint);
    }
}

