/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.buffer;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import java.io.File;
import javax.swing.JOptionPane;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.geoprocess.algorithm.buffer.AbstractDistance;
import org.gvsig.geoprocess.algorithm.buffer.BufferOperation;
import org.gvsig.geoprocess.algorithm.buffer.BufferParametersPanel;
import org.gvsig.geoprocess.algorithm.buffer.ConstantDistance;
import org.gvsig.geoprocess.algorithm.buffer.FieldDistance;
import org.gvsig.geoprocess.algorithm.buffer.FuseOperation;
import org.gvsig.geoprocess.algorithm.buffer.InBufferOperation;
import org.gvsig.geoprocess.algorithm.buffer.InOutBufferOperation;
import org.gvsig.geoprocess.algorithm.buffer.OutBufferOperation;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class BufferAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    public static final String SELECTED_GEOM = "SELECTED_GEOM";
    public static final String DISTANCE = "DISTANCE";
    public static final String FIELD = "FIELD";
    public static final String DISSOLVE = "DISSOLVE";
    public static final String ROUND_BORDER = "ROUND_BORDER";
    public static final String AREA = "AREA";
    public static final String RING_NUMBER = "RING_NUMBER";
    public static final byte BUFFER_OUTSIDE_POLY = 0;
    public static final byte BUFFER_INSIDE_POLY = 1;
    public static final byte BUFFER_INSIDE_OUTSIDE_POLY = 2;
    public static final byte SOURCE_FIELDS = 0;
    public static final byte FID_DIST_FIELDS = 1;
    public static final byte FID_FROM_TO_FIELDS = 2;
    protected byte tableFields = (byte)-1;
    private int inflArea = 0;
    protected boolean dissolve = false;
    protected int rings = 0;
    protected boolean selectedGeom = false;
    protected FeatureStore inputStore = null;
    protected FeatureStore outputStore = null;
    protected IVectorLayer sextanteInputLayer = null;
    protected boolean round_border = false;
    public static String[] sOptions = new String[]{GeoProcessLocator.getGeoProcessManager().getTranslation("poly_out"), GeoProcessLocator.getGeoProcessManager().getTranslation("poly_in"), GeoProcessLocator.getGeoProcessManager().getTranslation("poly_inandout")};

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Buffer"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addBoolean(SELECTED_GEOM, this.getTranslation("Selected_geometries"), false);
            this.m_Parameters.addNumericalValue(DISTANCE, this.getTranslation("area_distance"), 0.0, 2);
            this.m_Parameters.addTableField(FIELD, this.getTranslation("area_field"), LAYER);
            this.m_Parameters.addBoolean(DISSOLVE, this.getTranslation("Dissolve_entities"), false);
            this.m_Parameters.addBoolean(ROUND_BORDER, this.getTranslation("Round_border"), true);
            this.m_Parameters.addSelection(AREA, this.getTranslation("Builds_influence_area"), sOptions);
            this.m_Parameters.addSelection(RING_NUMBER, this.getTranslation("Number_of_rings"), new String[]{"1", "2", "3"});
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT, this.getTranslation("Buffer"), 2);
    }

    protected void readParameters() throws WrongParameterTypeException, NullParameterValueException, WrongParameterIDException {
        this.sextanteInputLayer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.selectedGeom = this.m_Parameters.getParameter(SELECTED_GEOM).getParameterValueAsBoolean();
        this.rings = this.m_Parameters.getParameterValueAsInt(RING_NUMBER);
        this.dissolve = this.m_Parameters.getParameter(DISSOLVE).getParameterValueAsBoolean();
        this.round_border = this.m_Parameters.getParameter(ROUND_BORDER).getParameterValueAsBoolean();
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        double distanceValue = this.m_Parameters.getParameter(DISTANCE).getParameterValueAsDouble();
        String attributeName = this.m_Parameters.getParameterValueAsString(FIELD);
        this.inflArea = this.m_Parameters.getParameterValueAsInt(AREA);
        this.readParameters();
        if (this.sextanteInputLayer.getShapeType() != 2 && this.inflArea != 0) {
            JOptionPane.showMessageDialog(null, this.getTranslation("Wrong_type_for_this_shapetype"), "Error", 2);
            this.inflArea = 0;
        }
        if (!(this.sextanteInputLayer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        this.inputStore = ((FlyrVectIVectorLayer)this.sextanteInputLayer).getFeatureStore();
        try {
            AbstractDistance distance = null;
            distance = distanceValue == 0.0 ? new FieldDistance(attributeName) : new ConstantDistance(distanceValue);
            BufferOperation operation = null;
            switch (this.inflArea) {
                case 0: {
                    operation = new OutBufferOperation(distance, this.inputStore, this, this.getTableFieldsStructure());
                    break;
                }
                case 1: {
                    operation = new InBufferOperation(distance, this.inputStore, this, this.getTableFieldsStructure());
                    break;
                }
                case 2: {
                    operation = new InOutBufferOperation(distance, this.inputStore, this, this.getTableFieldsStructure());
                }
            }
            operation.setTypeOfCap(this.round_border ? (byte)1 : 0);
            operation.setGeoProcess(this, 100);
            this.outputStore = this.buildOutPutStore(6, this.getTranslation("Buffer"), RESULT);
            if (!this.dissolve) {
                this.computesBufferAlgWithoutDissolve(operation);
            } else {
                this.computesBufferAlgWithDissolve(operation);
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.getTaskMonitor().isCanceled();
    }

    private void computesOneRingBufferWithDissolve(BufferOperation operation, FuseOperation fuseOp, String idFile, int initialPosition, int ringPosition) throws ValidateDataParametersException, DataException {
        String file = System.getProperty("java.io.tmpdir") + File.separator + idFile + ".shp";
        FeatureStore outAuxFeatStore = this.buildTemporalStore(3, file, this.inputStore.getDefaultFeatureType().getDefaultSRS());
        operation.getDistance().setNumberOfRings(ringPosition + 1);
        operation.setNumberOfRadialBuffers(1);
        operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
        this.m_Task.setProgressText(this.getTranslation("calc_buffer") + " [Ring:" + (this.rings - ringPosition) + "]");
        operation.computesGeometryOperation(this.inputStore, outAuxFeatStore, this.attrNames, this.selectedGeom, false, true);
        outAuxFeatStore = this.open(file, this.inputStore.getDefaultFeatureType().getDefaultSRS());
        this.m_Task.setProgressText(this.getTranslation("fuse_spatially") + " [Ring:" + (this.rings - ringPosition) + "]");
        fuseOp.computesGeometryOperation(outAuxFeatStore, this.outputStore, this.attrNames, ringPosition == initialPosition);
        outAuxFeatStore.dispose();
    }

    protected void computesBufferAlgWithDissolve(BufferOperation operation) throws DataException {
        int i;
        long fileTmpId = System.currentTimeMillis();
        FuseOperation fuseOp = new FuseOperation(this);
        if (this.inflArea == 0 || this.inflArea == 2) {
            try {
                for (i = this.rings; i >= 0; --i) {
                    this.computesOneRingBufferWithDissolve(operation, fuseOp, fileTmpId + (long)i + "", this.rings, i);
                }
            }
            catch (ValidateDataParametersException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        if (this.inflArea == 1) {
            try {
                for (i = 0; i < this.rings + 1; ++i) {
                    this.computesOneRingBufferWithDissolve(operation, fuseOp, fileTmpId + (long)i + "", 0, i);
                }
            }
            catch (ValidateDataParametersException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        fuseOp.end();
    }

    protected void computesBufferAlgWithoutDissolve(BufferOperation operation) throws DataException {
        operation.setNumberOfRadialBuffers(this.rings + 1);
        operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
        operation.computesGeometryOperation(this.inputStore, this.outputStore, this.attrNames, this.selectedGeom, false, true);
    }

    protected byte getTableFieldsStructure() {
        if (this.tableFields == -1) {
            this.tableFields = !this.dissolve ? (byte)0 : (this.inflArea == 2 ? (byte)2 : (byte)1);
        }
        return this.tableFields;
    }

    private FeatureStore open(String file, IProjection proj) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        DataManager manager = DALLocator.getDataManager();
        DataStoreParameters params = manager.createStoreParameters("Shape");
        params.setDynValue("shpfile", (Object)file);
        params.setDynValue("crs", (Object)proj);
        FeatureStore featureStore = (FeatureStore)manager.openStore(params.getDataStoreName(), params);
        return featureStore;
    }

    protected FeatureStore buildOutPutStore(int shapeType, String sextanteLayerName, String sextanteLayerLabel) throws DataException {
        FeatureType featureType = this.inputStore.getDefaultFeatureType();
        if (this.getTableFieldsStructure() == 0) {
            return super.buildOutPutStore(featureType, shapeType, sextanteLayerName, sextanteLayerLabel);
        }
        Class[] types = null;
        if (this.getTableFieldsStructure() == 2) {
            types = new Class[]{Integer.class, Double.class, Double.class};
            this.attrNames = new String[]{"FID", "FROM", "TO"};
        }
        if (this.getTableFieldsStructure() == 1) {
            types = new Class[]{Integer.class, Double.class};
            this.attrNames = new String[]{"FID", "DIST"};
        }
        try {
            IVectorLayer output = this.getNewVectorLayer(sextanteLayerLabel, sextanteLayerName, shapeType, types, this.attrNames);
            return ((FlyrVectIVectorLayer)output).getFeatureStore();
        }
        catch (UnsupportedOutputChannelException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeoAlgorithmExecutionException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return null;
    }

    protected FeatureStore buildTemporalStore(int shapeType, String file, IProjection crs) throws DataException, ValidateDataParametersException {
        FeatureType featureType = this.inputStore.getDefaultFeatureType();
        int[] types = null;
        if (this.getTableFieldsStructure() == 0) {
            FeatureAttributeDescriptor[] desc = featureType.getAttributeDescriptors();
            types = new int[desc.length - 1];
            this.attrNames = new String[desc.length - 1];
            int attrCount = 0;
            for (int i = 0; i < desc.length; ++i) {
                if (desc[i].getType() == 66) continue;
                types[attrCount] = desc[i].getType();
                this.attrNames[attrCount] = desc[i].getName();
                ++attrCount;
            }
        }
        if (this.getTableFieldsStructure() == 2) {
            types = new int[]{4, 8, 8};
            this.attrNames = new String[]{"FID", "FROM", "TO"};
        }
        if (this.getTableFieldsStructure() == 1) {
            types = new int[]{4, 8};
            this.attrNames = new String[]{"FID", "DIST"};
        }
        return this.create(file, types, this.attrNames, crs);
    }

    public FeatureStore create(String sFilename, int[] types, String[] attrNames, IProjection crs) {
        try {
            DataManager manager = DALLocator.getDataManager();
            FilesystemServerExplorerParameters explorerParams = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            explorerParams.setRoot(new File(sFilename).getParent());
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)manager.createServerExplorer((DataServerExplorerParameters)explorerParams);
            NewFeatureStoreParameters newParams = (NewFeatureStoreParameters)explorer.getAddParameters(new File(sFilename));
            EditableFeatureType ft = newParams.getDefaultFeatureType();
            for (int i = 0; i < attrNames.length; ++i) {
                ft.add(attrNames[i], types[i], 7);
            }
            ft.add("GEOMETRY", 66).setGeometryType(3).setGeometrySubType(0);
            newParams.setDefaultFeatureType((FeatureType)ft);
            newParams.setDynValue("CRS", (Object)crs);
            newParams.setDynValue("geometryType", (Object)3);
            manager.newStore("FilesystemExplorer", newParams.getDataStoreName(), (NewDataStoreParameters)newParams, true);
            FeatureStore featureStore = (FeatureStore)manager.openStore(newParams.getDataStoreName(), (DataStoreParameters)newParams);
            featureStore.edit(2);
            return featureStore;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return BufferParametersPanel.class;
    }
}

