/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.buffer;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gvsig.geoprocess.algorithm.buffer.BufferAlgorithm;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;

public class BufferParametersPanel
extends GeoAlgorithmParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final int marginSides = 15;
    private final int marginBottom = 8;
    private GeoAlgorithm m_Algorithm = null;
    private JComboBox layers = null;
    private JComboBox fields = null;
    private JComboBox influenceAreas = null;
    private JComboBox radialBuffers = null;
    private JCheckBox selectionOnly = null;
    private JCheckBox dissolveEntities = null;
    private JCheckBox roundBorder = null;
    private JTextField distance = null;
    private JRadioButton selectDistance = null;
    private JRadioButton selectField = null;
    private List<String> fieldList = new ArrayList<String>();
    private AlgorithmOutputPanel algorithmOutputPanel = null;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;
    private JPanel outputPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.add(this.getMainJScrollPane(), "Center");
    }

    private JScrollPane getMainJScrollPane() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 15, 0, 15);
        panel.add((Component)this.getInputPanel(), gbc);
        gbc.gridy = 1;
        panel.add((Component)this.getOptionsPanel(), gbc);
        gbc.gridy = 2;
        panel.add((Component)this.getOutputsPanel(), gbc);
        JScrollPane scrollPane = new JScrollPane(panel);
        return scrollPane;
    }

    private JPanel getOutputChannelSelectionPanel() {
        if (this.outputPanel == null) {
            try {
                this.outputPanel = new JPanel();
                this.outputPanel.setLayout(new BorderLayout());
                OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
                Output out = ooSet.getOutput("RESULT");
                this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
                this.outputPanel.add((Component)new JLabel(" " + GeoProcessLocator.getGeoProcessManager().getTranslation("Buffer") + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Vectorial") + "]               "), "West");
                this.outputPanel.add((Component)this.outputChannelSelectionPanel, "Center");
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.outputPanel;
    }

    private AlgorithmOutputPanel getAlgorithmOutputPanel() {
        if (this.algorithmOutputPanel == null) {
            this.algorithmOutputPanel = new AlgorithmOutputPanel();
        }
        return this.algorithmOutputPanel;
    }

    public JPanel getOutputsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        panel.setBorder(BorderFactory.createTitledBorder(GeoProcessLocator.getGeoProcessManager().getTranslation("outputs")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 15, 8, 15);
        panel.add((Component)this.getOutputChannelSelectionPanel(), gbc);
        return panel;
    }

    public JPanel getInputPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        panel.setBorder(BorderFactory.createTitledBorder(GeoProcessLocator.getGeoProcessManager().getTranslation("input")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 15, 8, 15);
        panel.add((Component)this.getComboLayers(), gbc);
        return panel;
    }

    public JPanel getOptionsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        panel.setBorder(BorderFactory.createTitledBorder(GeoProcessLocator.getGeoProcessManager().getTranslation("options")));
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRadioSelectDistance());
        group.add(this.getRadioSelectField());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 15, 8, 15);
        panel.add((Component)this.getRadioSelectField(), gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 25, 8, 15);
        panel.add((Component)this.getComboFields(), gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 15, 8, 15);
        panel.add((Component)this.getRadioSelectDistance(), gbc);
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 25, 8, 15);
        panel.add((Component)this.getTextDistance(), gbc);
        gbc.gridy = 4;
        gbc.insets = new Insets(0, 15, 8, 15);
        panel.add((Component)this.getCheckSelectedGeom(), gbc);
        gbc.gridy = 5;
        panel.add((Component)this.getCheckDissolveEntities(), gbc);
        gbc.gridy = 6;
        panel.add((Component)this.getCheckRoundBorder(), gbc);
        gbc.gridy = 7;
        panel.add((Component)this.getComboInfluenceAreas(), gbc);
        gbc.gridy = 8;
        panel.add((Component)this.getComboRadialBuffers(), gbc);
        this.checkLineLayer();
        return panel;
    }

    public JComboBox getComboLayers() {
        if (this.layers == null) {
            this.layers = new JComboBox();
            DefaultComboBoxModel<ObjectAndDescription> comboModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayerList());
            this.layers.setModel(comboModel);
            this.layers.addActionListener(this);
        }
        return this.layers;
    }

    public JComboBox getComboInfluenceAreas() {
        if (this.influenceAreas == null) {
            this.influenceAreas = new JComboBox();
            for (int i = 0; i < BufferAlgorithm.sOptions.length; ++i) {
                this.influenceAreas.addItem(BufferAlgorithm.sOptions[i]);
            }
            this.influenceAreas.addActionListener(this);
        }
        return this.influenceAreas;
    }

    public JComboBox getComboRadialBuffers() {
        if (this.radialBuffers == null) {
            this.radialBuffers = new JComboBox();
            this.radialBuffers.addItem("1");
            this.radialBuffers.addItem("2");
            this.radialBuffers.addItem("3");
            this.radialBuffers.addActionListener(this);
        }
        return this.radialBuffers;
    }

    public JCheckBox getCheckSelectedGeom() {
        if (this.selectionOnly == null) {
            this.selectionOnly = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("Selected_geometries"));
        }
        return this.selectionOnly;
    }

    public JCheckBox getCheckDissolveEntities() {
        if (this.dissolveEntities == null) {
            this.dissolveEntities = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("Dissolve_entities"));
        }
        return this.dissolveEntities;
    }

    public JCheckBox getCheckRoundBorder() {
        if (this.roundBorder == null) {
            this.roundBorder = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("Round_border"));
        }
        return this.roundBorder;
    }

    public JComboBox getComboFields() {
        if (this.fields == null) {
            this.fields = new JComboBox();
            this.loadFieldsInAreaCombo();
            this.fields.setEnabled(true);
        }
        return this.fields;
    }

    private void loadFieldsInAreaCombo() {
        List<String> fieldList = this.getFieldList();
        this.getComboFields().removeAllItems();
        for (int i = 0; i < fieldList.size(); ++i) {
            this.getComboFields().addItem(fieldList.get(i));
        }
    }

    private void checkLineLayer() {
        IVectorLayer vectorLyr = this.getSelectedVectorLayer();
        if (vectorLyr.getShapeType() == 1 || vectorLyr.getShapeType() == 0) {
            this.getComboInfluenceAreas().setSelectedIndex(0);
            this.getComboInfluenceAreas().setEnabled(false);
        } else {
            this.getComboInfluenceAreas().setEnabled(true);
        }
    }

    public JTextField getTextDistance() {
        if (this.distance == null) {
            this.distance = new JTextField("0.0");
            this.distance.setEnabled(false);
        }
        return this.distance;
    }

    public JRadioButton getRadioSelectDistance() {
        if (this.selectDistance == null) {
            this.selectDistance = new JRadioButton(GeoProcessLocator.getGeoProcessManager().getTranslation("area_distance"));
            this.selectDistance.addActionListener(this);
            this.selectDistance.setSelected(false);
        }
        return this.selectDistance;
    }

    public JRadioButton getRadioSelectField() {
        if (this.selectField == null) {
            this.selectField = new JRadioButton(GeoProcessLocator.getGeoProcessManager().getTranslation("area_field"));
            this.selectField.addActionListener(this);
            this.selectField.setSelected(true);
        }
        return this.selectField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getRadioSelectDistance()) {
            this.getTextDistance().setEnabled(true);
            this.getComboFields().setEnabled(false);
        }
        if (e.getSource() == this.getRadioSelectField()) {
            this.getTextDistance().setEnabled(false);
            this.getTextDistance().setText("0.0");
            this.getComboFields().setEnabled(true);
        }
        if (e.getSource() == this.getComboLayers()) {
            this.loadFieldsInAreaCombo();
            this.checkLineLayer();
        }
    }

    public void assignParameters() {
        try {
            ParametersSet params = this.m_Algorithm.getParameters();
            params.getParameter("LAYER").setParameterValue((Object)this.getSelectedVectorLayer());
            params.getParameter("FIELD").setParameterValue((Object)this.getFieldPosition());
            params.getParameter("FIELD").setParameterValue((Object)this.getFieldName());
            params.getParameter("SELECTED_GEOM").setParameterValue((Object)this.getCheckSelectedGeom().isSelected());
            double dist = 0.0;
            try {
                dist = new Double(this.getTextDistance().getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            params.getParameter("DISTANCE").setParameterValue((Object)dist);
            params.getParameter("DISSOLVE").setParameterValue((Object)this.getCheckDissolveEntities().isSelected());
            params.getParameter("ROUND_BORDER").setParameterValue((Object)this.getCheckRoundBorder().isSelected());
            params.getParameter("AREA").setParameterValue((Object)this.getComboInfluenceAreas().getSelectedIndex());
            params.getParameter("RING_NUMBER").setParameterValue((Object)this.getComboRadialBuffers().getSelectedIndex());
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            out.setOutputChannel(this.outputChannelSelectionPanel.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private ObjectAndDescription[] getLayerList() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    private IVectorLayer getSelectedVectorLayer() {
        if (this.layers.getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.layers.getSelectedItem()).getObject();
        }
        return null;
    }

    public List<String> getFieldList() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        ArrayList<String> data = new ArrayList<String>();
        this.fieldList.clear();
        for (int i = 0; i < layer.getFieldCount(); ++i) {
            Class type = layer.getFieldType(i);
            this.fieldList.add(layer.getFieldName(i));
            if (!Number.class.isAssignableFrom(type)) continue;
            data.add(layer.getFieldName(i));
        }
        return data;
    }

    private int getFieldPosition() {
        if (this.getComboFields().getSelectedItem() != null) {
            String label = this.getComboFields().getSelectedItem().toString();
            for (int i = 0; i < this.fieldList.size(); ++i) {
                if (!this.fieldList.get(i).equals(label)) continue;
                return i;
            }
        }
        return -1;
    }

    private String getFieldName() {
        if (this.getComboFields().getSelectedItem() != null) {
            String label = this.getComboFields().getSelectedItem().toString();
            return label;
        }
        return null;
    }
}

