/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.mainplugin.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AttributeEditorBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AttributeEditorPointListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class AttributeEditorExtension
extends Extension {
    private static final String TAG_ATTRIBUTEEDITOR_LOADONINSERT = "attributeeditor.loadoninsert";
    private Observer editingObserver;

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String actionCommand, Object[] args) {
        MapControl mapControl;
        Arguments arguments = Arguments.create((Object[])args);
        if (!actionCommand.equalsIgnoreCase("attribute-editor")) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view != null && (mapControl = view.getMapControl()).getMapContext().hasActiveVectorLayers()) {
            if (!mapControl.hasTool("attributeEditorTool")) {
                this.createMapTool(mapControl);
            }
            mapControl.setTool("attributeEditorTool");
            Behavior behavior = mapControl.getTool("attributeEditorTool");
            int modifiers = (Integer)arguments.get("awtmodifiers", Integer.class, (Object)0);
            ((AttributeEditorPointListener)behavior.getListener()).showOrUpdateForm((modifiers & 1) == 1);
        }
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"attribute-editor", (Object)((Object)this));
    }

    public void postInitialize() {
        this.editingObserver = new Observer(){

            public void update(Observable o, Object notification) {
                Tags tags;
                FeatureType featureType;
                if (!AttributeEditorExtension.this.isEnabled()) {
                    return;
                }
                EditingNotification n = (EditingNotification)notification;
                if (n.getType().equalsIgnoreCase("AFTER_INSERT_FEATURE") && n.getFeature() != null && n.getFeatureStore() != null && (featureType = n.getFeatureStore().getDefaultFeatureTypeQuietly()) != null && (tags = featureType.getTags()).getBoolean(AttributeEditorExtension.TAG_ATTRIBUTEEDITOR_LOADONINSERT, false)) {
                    AttributeEditorExtension.this.doShowFeature(n.getFeatureStore(), n.getFeature());
                }
            }
        };
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        editingNotificationManager.addObserver(this.editingObserver);
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        dynObjectManager.registerTag(TAG_ATTRIBUTEEDITOR_LOADONINSERT, "Indicates if the attribute editor should be opened when creating a feature of this type. By default false.", new String[]{"true", "false"});
    }

    public boolean isEnabled() {
        ViewDocument viewDoc = this.getActiveViewDocument();
        if (viewDoc == null) {
            return false;
        }
        FLayer[] layers = viewDoc.getMapContext().getLayers().getActives();
        return layers != null && layers.length == 1;
    }

    public boolean isVisible() {
        return this.getActiveViewDocument() != null;
    }

    private ViewDocument getActiveViewDocument() {
        return (ViewDocument)ApplicationLocator.getManager().getActiveDocument(ViewManager.TYPENAME);
    }

    private void createMapTool(MapControl mapControl) {
        ApplicationManager application = ApplicationLocator.getManager();
        AttributeEditorBehavior attributeEditorBehavior = new AttributeEditorBehavior(mapControl);
        attributeEditorBehavior.getListener().setRefreshCallback(store -> {
            application.refreshDocument(store);
            return true;
        });
        mapControl.addBehavior("attributeEditorTool", (Behavior)attributeEditorBehavior);
    }

    private void doShowFeature(FeatureStore store, Feature feature) {
        Expression filter = feature.createFilter();
        if (filter == null) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view != null) {
            MapControl mapControl = view.getMapControl();
            Behavior tool = mapControl.getTool("attributeEditorTool");
            if (tool == null) {
                this.createMapTool(mapControl);
                tool = mapControl.getTool("attributeEditorTool");
            }
            AttributeEditorPointListener listener = (AttributeEditorPointListener)tool.getListener();
            listener.showOrUpdateForm(store.getLabel(), store, store.createFeatureQuery(filter));
        }
    }
}

