/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.addo;

import java.io.File;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gvsig.addo.BuildingOverviewsException;
import org.gvsig.addo.IOverviewIncrement;
import org.gvsig.addo.WritingException;

public class Jaddo
implements IOverviewIncrement {
    public static final int NEAREST = 0;
    public static final int AVERAGE = 1;
    public static final int AVERAGE_MP = 2;
    public static final int AVERAGE_MAGPHASE = 3;
    public static final int MODE = 4;
    private IOverviewIncrement incrementListener = null;
    private int value = 0;

    public void buildOverviews(int resamplingAlg, String file, int[] overviews) throws BuildingOverviewsException, WritingException {
        File f = new File(file);
        if (!f.exists() || !f.isFile()) {
            throw new BuildingOverviewsException("File does not exist.");
        }
        if (!f.canWrite()) {
            throw new WritingException("File is not writeable");
        }
        Dataset data = gdal.Open((String)file);
        if (data.BuildOverviews(overviews) >= 0) {
            throw new BuildingOverviewsException("Problems building overviews");
        }
    }

    @Override
    public int getPercent() {
        return this.value;
    }

    @Override
    public void setPercent(int value) {
        this.value = value;
        if (this.incrementListener != null) {
            this.incrementListener.setPercent(value);
        }
    }

    public void setIncrementListener(IOverviewIncrement incr) {
        this.incrementListener = incr;
    }
}

