/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jgdal;

import java.awt.Color;
import org.gdal.gdal.ColorTable;
import org.gvsig.jgdal.GdalColorEntry;
import org.gvsig.jgdal.GdalException;

public class GdalColorTable {
    private ColorTable ct;

    public GdalColorTable(ColorTable ct) {
        this.ct = ct;
    }

    public int getColorEntryCount() throws GdalException {
        return this.ct.GetCount();
    }

    public GdalColorEntry getColorEntryAsRGB(int pos) throws GdalException {
        if (pos < 0 || pos >= this.getColorEntryCount()) {
            throw new GdalException("Entrada de la tabla de color fuera de rango");
        }
        GdalColorEntry entry = new GdalColorEntry();
        Color values = this.ct.GetColorEntry(pos);
        if (values == null) {
            throw new GdalException("Error en getColorEntryAsRGB(). Posici\u00f3n de la tabla de color inexistente.");
        }
        entry.c1 = (short)values.getRed();
        entry.c2 = (short)values.getGreen();
        entry.c3 = (short)values.getBlue();
        entry.c4 = (short)values.getAlpha();
        return entry;
    }
}

