/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jgdal;

import java.io.File;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gvsig.jgdal.GdalDataset;
import org.gvsig.jgdal.GdalException;
import org.gvsig.jgdal.Options;

public class GdalDriver {
    private Driver driver;

    public GdalDriver(Driver drv) {
        this.driver = drv;
    }

    public GdalDataset createCopy(String file, GdalDataset src, boolean bstrict) throws GdalException {
        String path = file.substring(0, file.lastIndexOf(File.separator));
        File f = new File(path);
        if (!f.canWrite()) {
            throw new GdalException("Ruta de archivo incorrecta.");
        }
        f = null;
        if (src == null) {
            throw new GdalException("El objeto Gdal es null");
        }
        Dataset data = gdal.Open((String)file, (int)(bstrict ? 1 : 0));
        Dataset copyDataset = this.driver.CreateCopy(file, data, bstrict ? 1 : 0);
        return new GdalDataset(copyDataset);
    }

    private Options selectOptions(String[] params) {
        if (params == null) {
            return null;
        }
        Options opc = new Options(params.length);
        for (int i = 0; i < params.length; ++i) {
            StringTokenizer st = new StringTokenizer(params[i], "=");
            String var = st.nextToken();
            String dato = st.nextToken();
            opc.addOption(var, dato);
        }
        return opc;
    }

    public GdalDataset createCopy(String file, GdalDataset src, boolean bstrict, String[] params) throws GdalException {
        String path = file.substring(0, file.lastIndexOf(File.separator));
        File f = new File(path);
        if (!f.canWrite()) {
            throw new GdalException("Ruta de archivo incorrecta.");
        }
        f = null;
        Dataset data = gdal.Open((String)file, (int)(bstrict ? 1 : 0));
        Dataset copyDataset = this.driver.CreateCopy(file, src.getDataset(), bstrict ? 1 : 0, params);
        if (copyDataset == null) {
            throw new GdalException("No se ha podido crear la copia");
        }
        return new GdalDataset(copyDataset);
    }

    public GdalDataset create(String filename, int nXSize, int nYSize, int nBands, int nType, String[] params) throws GdalException {
        byte[] ptext = filename.getBytes(Charset.forName("ISO_8859_1"));
        String value = new String(ptext, Charset.forName("UTF-8"));
        Dataset data = this.driver.Create(value, nXSize, nYSize, nBands, nType, GdalDriver.StringArrayToVector(params));
        return new GdalDataset(data);
    }

    private static Vector StringArrayToVector(String[] options) {
        if (options == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < options.length; ++i) {
            v.addElement(options[i]);
        }
        return v;
    }
}

