/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.io;

import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICRSFactory;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.jgdal.GdalException;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.gdal.io.GdalDataParameters;
import org.gvsig.raster.gdal.io.GdalDataSource;
import org.gvsig.raster.gdal.io.GdalFilesystemServerExplorer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.tile.FileTileServer;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreMetadata;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdalProvider
extends AbstractRasterProvider {
    public static String NAME = "Gdal Store";
    public static String DESCRIPTION = "Gdal Raster file";
    public static final String METADATA_DEFINITION_NAME = "GdalStore";
    private static final Logger logger = LoggerFactory.getLogger(GdalProvider.class);
    public static final String FORMAT_GTiff = "GTiff";
    public static final String FORMAT_VRT = "VRT";
    public static final String FORMAT_NITF = "NITF";
    public static final String FORMAT_HFA = "HFA";
    public static final String FORMAT_ELAS = "ELAS";
    public static final String FORMAT_MEM = "MEM";
    public static final String FORMAT_BMP = "BMP";
    public static final String FORMAT_PCIDSK = "PCIDSK";
    public static final String FORMAT_ILWIS = "ILWIS";
    public static final String FORMAT_HDF4 = "HDF4Image";
    public static final String FORMAT_PNM = "PNM";
    public static final String FORMAT_ENVI = "ENVI";
    public static final String FORMAT_EHDR = "EHdr";
    public static final String FORMAT_PAUX = "PAux";
    public static final String FORMAT_MFF = "MFF";
    public static final String FORMAT_MFF2 = "MFF2";
    public static final String FORMAT_BT = "BT";
    public static final String FORMAT_IDA = "IDA";
    public static final String FORMAT_RMF = "RMF";
    public static final String FORMAT_RST = "RST";
    public static final String FORMAT_LEVELLER = "Leveller";
    public static final String FORMAT_TERRAGEN = "Terragen";
    public static final String FORMAT_ERS = "ERS";
    public static final String FORMAT_INGR = "INGR";
    public static final String FORMAT_GSAG = "GSAG";
    public static final String FORMAT_GSBG = "GSBG";
    public static final String FORMAT_ADRG = "ADRG";
    public static final String FORMAT_JP2 = "JPEG2000";
    public static final String FORMAT_GRD = "GRD";
    public static final int BAND_HEIGHT = 64;
    protected GdalDataSource file = null;
    private Extent viewRequest = null;
    protected static String[][] formatList = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        GdalProvider.registerFormats();
        ExtensionPoint point = extensionPoints.get("DefaultRasterProvider");
        point.append("reader", NAME, GdalProvider.class);
        RasterLocator.getManager().getProviderServices().registerFileProvidersTiled(GdalProvider.class);
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, GdalProvider.class, GdalDataParameters.class);
        }
        if (DALFileLocator.getFilesystemServerExplorerManager() != null) {
            DALFileLocator.getFilesystemServerExplorerManager().registerProvider(NAME, DESCRIPTION, GdalFilesystemServerExplorer.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    private static void registerFormats() {
        formatList = new String[][]{{"bmp", "image/bmp"}, {"gif", "image/gif"}, {"tif", "image/tiff"}, {"tiff", "image/tiff"}, {"jpg", "image/jpeg"}, {"jpeg", "image/jpeg"}, {"png", "image/png"}, {"vrt", "image/vrt"}, {"dat", "image/dat"}, {"lan", "image/lan"}, {"gis", "image/gis"}, {"img", "image/img"}, {"pix", "image/pix"}, {"aux", "image/aux"}, {"adf", "image/adf"}, {"mpr", "image/mpr"}, {"mpl", "image/mpl"}, {"map", "image/map"}, {"asc", "image/asc"}, {"pgm", "image/pgn"}, {"ppm", "image/ppm"}, {"rst", "image/rst"}, {"rmf", "image/rmf"}, {"nos", "image/nos"}, {"kap", "image/kap"}, {"hdr", "image/hdr"}, {"raw", "image/raw"}, {"ers", "image/ers"}, {"xml", "image/xml"}, {"grd", "image/grd"}, {"txt", "image/txt"}};
        for (int i = 0; i < formatList.length; ++i) {
            RasterLocator.getManager().getProviderServices().addFormat(formatList[i][0], GdalProvider.class);
        }
    }

    public String[] getFormatList() {
        String[] fl = new String[formatList.length];
        for (int i = 0; i < fl.length; ++i) {
            fl[i] = formatList[i][0];
        }
        return fl;
    }

    public boolean isExtensionSupported(String ext) {
        if (ext.indexOf(".") != -1) {
            ext = ext.substring(ext.lastIndexOf(".") + 1, ext.length());
        }
        for (int i = 0; i < formatList.length; ++i) {
            if (formatList[i][0].compareTo(ext) != 0) continue;
            return true;
        }
        return false;
    }

    public GdalProvider() {
    }

    public GdalProvider(String params) throws NotSupportedExtensionException, OpenException {
        super(params);
        logger.info("Deprecated use of GdalProvider constructor");
        if (params instanceof String) {
            URI uriParam;
            GdalDataParameters p = new GdalDataParameters();
            try {
                uriParam = new URI(params);
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create uri from " + params, (Throwable)e);
            }
            p.setURI(uriParam);
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init((AbstractRasterDataParameters)p, null);
        }
    }

    public GdalProvider(URI uri) throws NotSupportedExtensionException {
        super(uri);
        GdalDataParameters p = new GdalDataParameters();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((AbstractRasterDataParameters)p, null);
    }

    public GdalProvider(GdalDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((AbstractRasterDataParameters)params, storeServices);
    }

    public GdalProvider(AbstractRasterDataParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        super(params, storeServices, metadata);
    }

    public void init(AbstractRasterDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        try {
            block16: {
                String wktEsri;
                File prjFile;
                this.setParam(storeServices, (DataStoreParameters)params);
                String fname = this.getFileName((RasterDataParameters)params);
                this.setFName(fname);
                this.file = new GdalDataSource(fname);
                this.setColorInterpretation((ColorInterpretation)this.file.colorInterpr);
                this.setColorTable((ColorTable)this.file.palette);
                this.noData = this.file.getNoDataValue();
                ICRSFactory crsFactory = CRSFactory.getCRSFactory();
                IProjection proj = params.getSRS();
                if (proj == null && (prjFile = this.getPrjFile(params.getURI())).exists() && (wktEsri = this.loadPrj(prjFile)) != null) {
                    try {
                        proj = crsFactory.get("wkt_esri", wktEsri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (proj == null) {
                    String wktProjection = this.file.getProjectionRef();
                    if (!StringUtils.isEmpty((CharSequence)wktProjection)) {
                        try {
                            proj = crsFactory.get("wkt", wktProjection);
                            if (StringUtils.isEmpty((CharSequence)proj.getAbrev())) {
                                proj = null;
                                break block16;
                            }
                            this.setProjection(proj, true);
                        }
                        catch (Exception e) {
                            proj = null;
                            logger.info("Error reading WKT from the raster provider", (Throwable)e);
                        }
                    }
                } else {
                    this.setProjection(proj, false);
                }
            }
            this.ownTransformation = this.file.getOwnTransformation();
            this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
            this.load();
            if (this.file != null) {
                this.bandCount = this.file.getRasterCount();
            }
        }
        catch (GdalException e) {
            throw new NotSupportedExtensionException("Extension not supported", (Exception)e);
        }
        catch (Exception e) {
            System.out.println("Error en GdalOpen");
            e.printStackTrace();
            this.file = null;
        }
        int[] dt = new int[this.file.getDataType().length];
        for (int i = 0; i < dt.length; ++i) {
            dt[i] = GdalDataSource.getRasterBufTypeFromGdalType(this.file.getDataType()[i]);
        }
        this.setDataType(dt);
        super.init();
        try {
            this.loadFromRmf(this.getRmfBlocksManager());
        }
        catch (ParsingException e) {
            logger.debug("Problems reading from the RMF file", (Throwable)e);
        }
    }

    private String getFileName(RasterDataParameters params) throws GdalException {
        File f = new File(params.getURI());
        this.validRmf(f.getAbsolutePath());
        return this.translateFileName(f.getAbsolutePath());
    }

    public String getMimeType() {
        try {
            File f = ((FilesystemStoreParameters)this.getDataStoreParameters()).getFile();
            String ext = FilenameUtils.getExtension((String)f.getName());
            for (int i = 0; i < formatList.length; ++i) {
                if (!ext.equalsIgnoreCase(formatList[i][0])) continue;
                return formatList[i][1];
            }
        }
        catch (Exception ex) {
            logger.warn("Can't get mime type for GDAL archive.", (Throwable)ex);
        }
        return "image";
    }

    private void validRmf(String file) throws GdalException {
        if (file.endsWith(".rmf")) {
            File f = new File(file);
            try {
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                char[] buffer = new char[5];
                br.read(buffer);
                StringBuffer st = new StringBuffer(new String(buffer));
                br.close();
                fr.close();
                if (st.toString().equals("<?xml")) {
                    throw new GdalException("RasterMetaFile");
                }
            }
            catch (FileNotFoundException e) {
                throw new GdalException("File Not Found");
            }
            catch (IOException e) {
                throw new GdalException("");
            }
        }
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.file != null && this.file.isOpen();
    }

    public URI translateURI(URI uri) {
        String absolutePath = new File(uri).getAbsolutePath();
        if ("hdr".equalsIgnoreCase(FilenameUtils.getExtension((String)absolutePath))) {
            File file = new File(FilenameUtils.removeExtension((String)absolutePath));
            return file.toURI();
        }
        return uri;
    }

    public void setView(Extent e) {
        this.viewRequest = new ExtentImpl(e);
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        return this.file.width;
    }

    public double getHeight() {
        return this.file.height;
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        if ((double)line > this.getHeight() || band > this.getBandCount()) {
            throw new InvalidSetViewException("Request out of grid");
        }
        try {
            return this.file.readCompleteLine(line, band);
        }
        catch (GdalException e) {
            throw new RasterDriverException("Error reading data from Gdal library");
        }
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        if (pos < 0) {
            throw new InvalidSetViewException("Request out of grid");
        }
        if ((double)(pos + blockHeight) > this.getHeight()) {
            blockHeight = Math.abs((int)this.getHeight() - pos);
        }
        try {
            return this.file.readBlock(pos, blockHeight, scale);
        }
        catch (GdalException e) {
            throw new RasterDriverException("Error reading data from Gdal library");
        }
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        if (this.file != null) {
            if (x < 0 || y < 0 || x >= this.file.width || y >= this.file.height) {
                throw new InvalidSetViewException("Request out of grid");
            }
            Object[] data = this.file.getData(x, y);
            return data[band];
        }
        throw new FileNotOpenException("GdalNative not exist");
    }

    public void loadBuffer(SpiRasterQuery q) throws ProcessInterruptedException, RasterDriverException {
        this.setView(q.getAdjustedRequestBoundingBox());
        try {
            this.file.readWindow(q.getBufferForProviders(), q.getBandList(), q.getAdjustedRequestBoundingBox(), q.getAdjustedRequestPxWindow(), q.getTaskStatus());
        }
        catch (GdalException e) {
            throw new RasterDriverException("Error reading data", (Exception)e);
        }
    }

    public int getBlockSize() {
        if (this.file != null) {
            return this.file.getBlockSize();
        }
        return 0;
    }

    public DataStoreMetadata getMetadata() {
        if (this.file != null) {
            return this.file.metadata;
        }
        return null;
    }

    public Transparency getTransparency() {
        return this.file.fileTransparency;
    }

    public boolean isGeoreferenced() {
        if (this.file != null) {
            return this.file.georeferenced;
        }
        return false;
    }

    public boolean isSupersampling() {
        if (this.file != null) {
            return this.file.isSupersampling;
        }
        return false;
    }

    protected GdalDataSource getNative() {
        return this.file;
    }

    public void setAffineTransform(AffineTransform t) {
        super.setAffineTransform(t);
        this.file.setExternalTransform(t);
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        try {
            return this.file.getRasterBand(band + 1).getOverviewCount();
        }
        catch (GdalException e) {
            throw new RasterDriverException("");
        }
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        try {
            if (overview >= this.file.getRasterBand(band + 1).getOverviewCount()) {
                throw new BandAccessException("Wrong overview count");
            }
            return this.file.getRasterBand(band + 1).getOverview(overview).getRasterBandXSize();
        }
        catch (GdalException e) {
            throw new RasterDriverException("");
        }
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        try {
            if (overview >= this.file.getRasterBand(band + 1).getOverviewCount()) {
                throw new BandAccessException("Wrong overview count");
            }
            return this.file.getRasterBand(band + 1).getOverview(overview).getRasterBandYSize();
        }
        catch (GdalException e) {
            throw new RasterDriverException("");
        }
    }

    public boolean isOverviewsSupported() {
        return true;
    }

    public boolean isReproyectable() {
        return true;
    }

    public boolean needEnhanced() {
        return this.getDataType()[0] != 0;
    }

    public String getProviderName() {
        return NAME;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof GdalProvider) {
            // empty if block
        }
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new FileTileServer((RasterDataStore)store);
        }
        return this.tileServer;
    }

    public void close() {
        if (this.file != null) {
            this.file.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.file = null;
        this.viewRequest = null;
        if (formatList != null) {
            for (int i = 0; i < formatList.length; ++i) {
                GdalProvider.formatList[i] = null;
            }
            formatList = null;
        }
        super.finalize();
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }

    private File getPrjFile(URI uri) {
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            String uriPath = new File(uri).getAbsolutePath();
            String prjPath = FilenameUtils.removeExtension((String)uriPath) + ".prj";
            return new File(prjPath);
        }
        return null;
    }

    private String loadPrj(File prjFile) {
        if (prjFile.exists()) {
            try {
                return FileUtils.readFileToString((File)prjFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

