/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.io;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.jgdal.GdalDataset;
import org.gvsig.jgdal.GdalDriver;
import org.gvsig.jgdal.GdalException;
import org.gvsig.raster.gdal.io.GdalProvider;
import org.gvsig.raster.gdal.io.GdalWriter;
import org.gvsig.raster.gdal.io.features.JpegFeatures;
import org.gvsig.raster.impl.store.WriteFileFormatFeatures;
import org.gvsig.raster.impl.store.writer.DefaultRasterWriter;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class JpegWriter
extends DefaultRasterWriter {
    private GdalWriter gdalWriter = null;
    private String outTif = null;
    private String outJpg = null;

    public static void register() {
        DefaultProviderServices pInfo = (DefaultProviderServices)RasterLocator.getManager().getProviderServices();
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        point.append("jpg", "", JpegWriter.class);
        pInfo.getFileFeature().put("jpg", new JpegFeatures());
    }

    public void loadParams(String ident) {
        WriteFileFormatFeatures wfff = (WriteFileFormatFeatures)this.pInfo.getFileFeature().get(ident);
        wfff.loadParams();
        this.driverParams = wfff.getParams();
    }

    public String getProviderName() {
        return GdalProvider.NAME;
    }

    public JpegWriter(String fileName) {
        this.ident = this.fileUtil.getExtensionFromFileName(fileName);
        this.driver = ((WriteFileFormatFeatures)this.pInfo.getFileFeature().get(this.ident)).getDriverName();
        this.gdalWriter = new GdalWriter(fileName);
        this.loadParams(this.ident);
    }

    public JpegWriter(DataServerWriter dataWriter, String outFileName, Integer nBands, AffineTransform at, Integer outSizeX, Integer outSizeY, Integer dataType, Params params, IProjection proj, Boolean geo) throws GdalException, IOException {
        this.ident = this.fileUtil.getExtensionFromFileName(outFileName);
        this.driver = ((WriteFileFormatFeatures)this.pInfo.getFileFeature().get(this.ident)).getDriverName();
        this.outJpg = outFileName;
        this.outTif = outFileName.substring(0, outFileName.lastIndexOf("."));
        this.outTif = this.outTif + ".tif";
        this.gdalWriter = new GdalWriter(dataWriter, this.outTif, nBands, at, outSizeX, outSizeY, dataType, params, proj, geo);
        if (params == null) {
            this.loadParams(this.ident);
        } else {
            this.driverParams = params;
        }
    }

    public void setDriverType(String drvType) {
        this.gdalWriter.setDriverType(drvType);
    }

    public void fileWrite() throws IOException, ProcessInterruptedException {
        this.gdalWriter.fileWrite();
    }

    public static void createCopy(GdalDriver driverDst, String dst, String src, boolean bstrict, String[] params) throws IOException, GdalException {
        GdalWriter.createCopy(driverDst, dst, src, bstrict, params);
    }

    public void dataWrite() throws IOException, ProcessInterruptedException {
        if (this.colorInterp != null) {
            this.gdalWriter.setColorBandsInterpretation(this.colorInterp.getValues());
        }
        this.gdalWriter.dataWrite();
        if (this.gdalWriter.isWrite()) {
            this.gdalWriter.writeClose();
            if (this.outTif != null) {
                GdalDriver driver = null;
                try {
                    driver = GdalDataset.getDriverByName("JPEG");
                    GdalWriter.createCopy(driver, this.outJpg, this.outTif, false, this.gdalWriter.gdalParamsFromRasterParams(this.driverParams));
                }
                catch (GdalException exc) {
                    throw new IOException("No se ha podido obtener el driver.");
                }
                File file = new File(this.outTif);
                file.delete();
            }
        }
    }

    public void writeCancel() {
        this.gdalWriter.setWrite(false);
    }

    public void setParams(Params params) {
        this.driverParams = params;
        if (this.gdalWriter != null) {
            this.gdalWriter.setParams(params);
        }
    }

    public void writeClose() {
    }

    public void setWkt(String wkt) {
    }
}

