/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.alg;

import java.util.LinkedList;
import java.util.Stack;
import org.javanetworkanalyzer.alg.BFS;
import org.javanetworkanalyzer.alg.CentralityAlg;
import org.javanetworkanalyzer.data.UnweightedPathLengthData;
import org.javanetworkanalyzer.data.VUCent;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.jgrapht.Graph;

public class BFSForCentrality<E extends EdgeSPT>
extends BFS<VUCent, E>
implements CentralityAlg<VUCent, E, UnweightedPathLengthData> {
    private final Stack<VUCent> stack;
    private final UnweightedPathLengthData pathsFromStartNode;

    public BFSForCentrality(Graph<VUCent, E> graph, Stack<VUCent> stack) {
        super(graph);
        this.stack = stack;
        this.pathsFromStartNode = new UnweightedPathLengthData();
    }

    @Override
    protected void init(VUCent startNode) {
        super.init(startNode);
        this.stack.clear();
        this.pathsFromStartNode.clear();
    }

    @Override
    protected VUCent dequeueStep(LinkedList<VUCent> queue) {
        VUCent current = queue.poll();
        this.stack.push(current);
        return current;
    }

    @Override
    protected void firstTimeFoundStep(VUCent current, VUCent neighbor) {
        this.pathsFromStartNode.addSPLength(neighbor.getDistance());
    }

    @Override
    protected void shortestPathStep(VUCent current, VUCent neighbor, E e) {
        super.shortestPathStep(current, neighbor, e);
        neighbor.accumulateSPCount(current.getSPCount());
    }

    @Override
    public UnweightedPathLengthData getPaths() {
        return this.pathsFromStartNode;
    }
}

