/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.alg;

import org.javanetworkanalyzer.alg.GraphSearchAlgorithm;
import org.javanetworkanalyzer.data.VDFS;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.jgrapht.Graph;

public class DFS<V extends VDFS, E extends EdgeSPT>
extends GraphSearchAlgorithm<V, E> {
    private int time = 0;

    public DFS(Graph<V, E> graph) {
        super(graph);
    }

    public void calculate() {
        for (VDFS node : this.graph.vertexSet()) {
            if (node.getDiscoveryTime() >= 0) continue;
            this.calculate((V)node);
        }
    }

    @Override
    public void calculate(V startNode) {
        this.init(startNode);
        this.visit(startNode);
    }

    protected void visit(V node) {
        ++this.time;
        ((VDFS)node).setDiscoveryTime(this.time);
        for (VDFS neighbor : this.successorListOf(node)) {
            if (neighbor.getDiscoveryTime() >= 0) continue;
            neighbor.addPredecessor(node);
            neighbor.addPredecessorEdge(this.graph.getEdge(node, (Object)neighbor));
            this.visit(neighbor);
        }
        ++this.time;
        ((VDFS)node).setFinishingTime(this.time);
    }
}

