/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.analyzers;

import java.util.Set;
import org.javanetworkanalyzer.alg.DijkstraForAccessibility;
import org.javanetworkanalyzer.analyzers.GeneralizedGraphAnalyzer;
import org.javanetworkanalyzer.data.VAccess;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.graph.EdgeReversedGraph;

public class AccessibilityAnalyzer<E extends EdgeSPT>
extends GeneralizedGraphAnalyzer<VAccess, E> {
    private Set<VAccess> destinations;

    public AccessibilityAnalyzer(Graph<VAccess, E> graph, Set<VAccess> destinations) {
        super(graph);
        this.destinations = destinations;
        this.verifyDestinations();
    }

    public void compute() {
        Object g = this.graph instanceof DirectedGraph ? new EdgeReversedGraph((DirectedGraph)this.graph) : this.graph;
        DijkstraForAccessibility dijkstra = new DijkstraForAccessibility(g);
        for (VAccess dest : this.destinations) {
            dest.setClosestDestinationId(dest.getID());
            dest.setDistanceToClosestDestination(0.0);
            dijkstra.calculate(dest);
        }
    }

    private void verifyDestinations() {
        for (VAccess dest : this.destinations) {
            if (this.graph.containsVertex((Object)dest)) continue;
            throw new IllegalArgumentException("Destination " + dest.getID() + " is not contained " + "in the graph.");
        }
    }
}

