/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.tile.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.HashMap;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.pool.AtomicTask;
import org.gvsig.raster.cache.tile.pool.TilePipe;
import org.gvsig.raster.cache.tile.provider.Downloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileImpl
implements Tile {
    private boolean corrupt = false;
    private int level = 0;
    private int col = 0;
    private int row = 0;
    private String var = "V";
    private String z = "Z";
    private String time = "T";
    private int widthPx = 0;
    private int heightPx = 0;
    private Point2D ul = null;
    private Point2D lr = null;
    private Rectangle2D coordPx = null;
    private File file = null;
    private Downloader downloader = null;
    private HashMap<String, Object> downloaderParams = new HashMap();
    private TilePipe sharedPipe = null;
    private int priority = 0;
    private Object[] data = null;
    protected CancelTaskImpl cancelDownloading = null;
    private static Logger logger = LoggerFactory.getLogger(TileImpl.class);

    public TileImpl(int level, int col, int row) {
        this.level = level;
        this.col = col;
        this.row = row;
        this.cancelDownloading = new CancelTaskImpl();
    }

    public TileImpl(int wPx, int hPx, int row, int col, Point2D ul, Point2D lr) {
        this.row = row;
        this.col = col;
        this.ul = ul;
        this.lr = lr;
        this.widthPx = wPx;
        this.heightPx = hPx;
        this.cancelDownloading = new CancelTaskImpl();
    }

    public Object[] getDownloadingImage() {
        return this.downloader.getDownloadingImage(this.getWidthPx(), this.getHeightPx());
    }

    public Object[] getCrashImage() {
        return this.downloader.getCrashImage(this.getWidthPx(), this.getHeightPx());
    }

    public Object getDownloadingARGB() {
        Object[] result = this.downloader.getDownloadingImage(this.getWidthPx(), this.getHeightPx());
        if (result != null && result.length >= 1) {
            return result[0];
        }
        return null;
    }

    public Object getCrashARGB() {
        Object[] result = this.downloader.getCrashImage(this.getWidthPx(), this.getHeightPx());
        if (result != null && result.length >= 1) {
            return result[0];
        }
        return null;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        double psX = (this.lr.getX() - this.ul.getX()) / (double)this.widthPx;
        double psY = (this.lr.getY() - this.ul.getY()) / (double)this.heightPx;
        AffineTransform t = new AffineTransform(psX, 0.0, 0.0, psY, this.ul.getX() - psX / 2.0, this.ul.getY() + psY / 2.0);
        try {
            t.inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public Tile cloneTile() {
        TileImpl newTile = new TileImpl(this.widthPx, this.heightPx, this.row, this.col, (Point2D)this.ul.clone(), (Point2D)this.lr.clone());
        newTile.file = this.file;
        return newTile;
    }

    public String getVariable() {
        return this.var;
    }

    public String getZ() {
        return this.z;
    }

    public String getTimeInstant() {
        return this.time;
    }

    public void setVariable(String var) {
        this.var = var;
    }

    public void setZ(String z) {
        this.z = z;
    }

    public int getLevel() {
        return this.level;
    }

    public void setTimeInstant(String t) {
        this.time = t;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Rectangle2D getCoordsPx() {
        return this.coordPx;
    }

    public void setCoordsPx(Rectangle2D r) {
        this.coordPx = r;
    }

    public int getWidthPx() {
        return this.widthPx;
    }

    public void setWidthPx(int widthPx) {
        this.widthPx = widthPx;
    }

    public int getHeightPx() {
        return this.heightPx;
    }

    public void setHeightPx(int heightPx) {
        this.heightPx = heightPx;
    }

    public Rectangle2D getExtent() {
        return new Rectangle2D.Double(this.ul.getX(), this.ul.getY(), Math.abs(this.ul.getX() - this.lr.getX()), Math.abs(this.ul.getY() - this.lr.getY()));
    }

    public Point2D getUl() {
        return this.ul;
    }

    public void setUl(Point2D ul) {
        this.ul = ul;
    }

    public Point2D getLr() {
        return this.lr;
    }

    public void setLr(Point2D lr) {
        this.lr = lr;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    public Object getDownloaderParams(String key) {
        return this.downloaderParams.get(key.toUpperCase());
    }

    public void setDownloaderParams(String key, Object value) {
        this.downloaderParams.put(key.toUpperCase(), value);
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isCorrupt() {
        boolean c = this.corrupt;
        this.corrupt = false;
        return c;
    }

    public void run() {
        try {
            this.downloader.downloadTile((Tile)this);
            this.corrupt = false;
        }
        catch (Exception e) {
            if (this.getFile().exists()) {
                this.getFile().delete();
            }
            this.corrupt = true;
            logger.warn("Canceling tile....." + this.getId(), (Throwable)e);
        }
        finally {
            if (this.sharedPipe != null) {
                this.sharedPipe.setAtomicTask((AtomicTask)this);
            }
        }
    }

    public void cancelTask() {
        ((CancelTaskImpl)this.getCancelled()).setCanceled(true);
        this.sharedPipe = null;
    }

    public ICancellable getCancelled() {
        return this.cancelDownloading;
    }

    public TilePipe getSharedPipe() {
        return this.sharedPipe;
    }

    public void setSharedPipe(TilePipe sharedPipe) {
        this.sharedPipe = sharedPipe;
    }

    public String getId() {
        return this.getLevel() + "_" + this.getRow() + "_" + this.getCol();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setData(Object[] data) {
        this.data = data;
    }

    public Object[] getData() {
        return this.data;
    }

    public int compareTo(AtomicTask o) {
        if (this.getPriority() > o.getPriority()) {
            return 1;
        }
        if (this.getPriority() < o.getPriority()) {
            return -1;
        }
        return 0;
    }

    public boolean dataIsLoaded() {
        return this.getData() != null && this.getData().length > 0;
    }

    public class CancelTaskImpl
    implements ICancellable {
        private boolean cancel = false;

        public Object getID() {
            return this;
        }

        public boolean isCanceled() {
            return this.cancel;
        }

        public void setCanceled(boolean cancel) {
            this.cancel = cancel;
        }
    }
}

