/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.tile.impl.layer;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.disk.ITileFileSystemStrategy;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.impl.TileCacheImpl;
import org.gvsig.raster.cache.tile.impl.TileImpl;
import org.gvsig.raster.cache.tile.impl.layer.TimerOneTile;
import org.gvsig.raster.cache.tile.impl.layer.TimerTilePool;
import org.gvsig.raster.cache.tile.impl.pool.ThreadPoolImpl;
import org.gvsig.raster.cache.tile.layer.TiledLayer;
import org.gvsig.raster.cache.tile.pool.AtomicTask;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.cache.tile.provider.TileListener;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.tools.task.TaskStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiledLayerImpl
implements TiledLayer {
    private TileServer provider = null;
    private TileCacheImpl tileCache = null;
    private String basePath = null;
    private String pathToDirLayer = null;
    private String idLayer = null;
    private ThreadPoolImpl pool = null;
    private ITileFileSystemStrategy strategy = null;
    private TimerOneTile timerOneTile = null;
    private TimerTilePool timerTilePool = null;

    public TiledLayerImpl(TileCacheImpl tileCache, TileServer provider, ITileFileSystemStrategy strategy) {
        this.tileCache = tileCache;
        this.provider = provider;
        this.basePath = tileCache.getBaseDirectory();
        this.strategy = strategy;
    }

    private TimerOneTile getTimerOneTile() {
        if (this.timerOneTile == null) {
            this.timerOneTile = new TimerOneTile();
        }
        return this.timerOneTile;
    }

    private TimerTilePool getTimerTilePool() {
        if (this.timerTilePool == null) {
            this.timerTilePool = new TimerTilePool(this.getThreadPool());
        }
        return this.timerTilePool;
    }

    public ThreadPoolImpl getThreadPool() {
        if (this.pool == null) {
            this.pool = new ThreadPoolImpl(false);
        }
        return this.pool;
    }

    public void updateBaseDirectory(String dir) {
        this.basePath = dir;
        this.pathToDirLayer = null;
    }

    public Tile getTile(Tile tile) throws TileGettingException {
        this.assignPathTile(tile);
        this.provider.getDownloader().readTileFromDisk(tile);
        if (tile.dataIsLoaded()) {
            if (!tile.isCorrupt()) {
                return tile;
            }
            return null;
        }
        this.getTimerOneTile().setTile(tile);
        this.getTimerOneTile().start();
        this.provider.getDownloader().downloadTile(tile);
        this.getTimerOneTile().stop();
        this.tileCache.updateSize(tile.getFile().length());
        this.tileCache.saveSize();
        if (!tile.isCorrupt()) {
            return tile;
        }
        return null;
    }

    public void getTiles(List<Tile> tiles, TileListener listener, TaskStatus status) throws TileGettingException {
        Tile tile;
        int i;
        int nTilesToDownload = 0;
        this.getThreadPool().getInputTaskList().clear();
        this.getThreadPool().getTilePipe().clear();
        for (i = 0; i < tiles.size(); ++i) {
            tile = tiles.get(i);
            this.assignPathTile(tile);
            try {
                ((TileImpl)tile).setDownloader(this.provider.getDownloader());
                this.provider.getDownloader().readTileFromDisk(tile);
            }
            catch (TileGettingException tileGettingException) {
                // empty catch block
            }
            if (tile.dataIsLoaded()) {
                listener.tileReady(tile);
                continue;
            }
            ((TileImpl)tile).setSharedPipe(this.getThreadPool().getTilePipe());
            this.getThreadPool().addTask((AtomicTask)tile);
            ++nTilesToDownload;
        }
        for (i = 0; i < nTilesToDownload; ++i) {
            tile = (Tile)this.getThreadPool().getTilePipe().getAtomicTask();
            if (tile == null) {
                if (this.getThreadPool().isPoolValid()) break;
                this.pool = null;
                break;
            }
            this.tileCache.updateSize(tile.getFile().length());
            if (status != null && status.isCancellationRequested()) {
                this.getThreadPool().emptyPool();
                break;
            }
            if (status != null && status.isCancellationRequested()) continue;
            listener.tileReady(tile);
        }
        this.tileCache.saveSize();
    }

    public String getBaseLayerDirectory() {
        CacheStruct struct = this.provider.getStruct();
        int maxLevel = struct.getNumberOfLevels() - 1;
        if (this.pathToDirLayer == null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(new String(struct.getServerURL() + struct.getLayerName() + struct.getFileSuffix() + struct.getWorldWidthOfTileMatrixByLevel(maxLevel) + struct.getWorldHeightOfTileMatrixByLevel(maxLevel) + struct.getTileSizeByLevel(maxLevel)[0] + struct.getTileSizeByLevel(maxLevel)[1] + struct.getNumberOfLevels() + struct.getEPSG() + struct.getFileSize()).getBytes());
                this.idLayer = this.convertToHex(md.digest());
            }
            catch (NoSuchAlgorithmException e) {
                this.idLayer = new String(struct.getServerURL() + struct.getLayerName() + struct.getFileSuffix() + struct.getWorldWidthOfTileMatrixByLevel(maxLevel) + struct.getWorldHeightOfTileMatrixByLevel(maxLevel) + struct.getTileSizeByLevel(maxLevel)[0] + struct.getTileSizeByLevel(maxLevel)[1] + struct.getNumberOfLevels() + struct.getEPSG() + struct.getFileSize());
            }
            int begin = struct.getLayerName().lastIndexOf(File.separator) + 1;
            int end = struct.getLayerName().lastIndexOf(".");
            end = end < 0 ? struct.getLayerName().length() : end;
            String name = struct.getLayerName().substring(begin, end);
            this.idLayer = this.idLayer + "-" + name;
            this.pathToDirLayer = this.basePath + File.separator + this.idLayer;
        }
        return this.pathToDirLayer;
    }

    public String getID() {
        if (this.idLayer == null) {
            this.getBaseLayerDirectory();
        }
        return this.idLayer;
    }

    public long delete() {
        File f = new File(this.getBaseLayerDirectory());
        if (f.exists() && f.isDirectory()) {
            return this.deleteDirectory(f);
        }
        return 0L;
    }

    private long deleteDirectory(File f) {
        long size = 0L;
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            size = files[i].isDirectory() ? (size += this.deleteDirectory(files[i])) : (size += files[i].length());
            files[i].delete();
        }
        return size;
    }

    public String assignPathTile(Tile tile) {
        String file = this.getBaseLayerDirectory() + File.separator + this.strategy.getRelativeToLayerDirTilePath(tile.getRow(), tile.getCol(), tile.getLevel(), tile.getVariable(), tile.getZ(), tile.getTimeInstant()) + "." + this.provider.getFileSuffix();
        String path = file.substring(0, file.lastIndexOf(File.separator));
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        tile.setFile(new File(file));
        return file;
    }

    private String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

