/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.tile.impl.pool;

import java.util.Collections;
import java.util.LinkedList;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.impl.pool.ThreadTask;
import org.gvsig.raster.cache.tile.impl.pool.TilePipeImpl;
import org.gvsig.raster.cache.tile.pool.AtomicTask;
import org.gvsig.raster.cache.tile.pool.ThreadPool;
import org.gvsig.raster.cache.tile.pool.TilePipe;
import org.gvsig.raster.cache.tile.provider.TileListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolImpl
implements ThreadPool {
    private int NTHREADS_POOL = 5;
    private ThreadTask[] threadList = null;
    private LinkedList<AtomicTask> tasks = new LinkedList();
    private boolean priorityActive = false;
    private TilePipe tilePipe = null;

    public ThreadPoolImpl() {
        this.priorityActive = true;
        this.threadList = new ThreadTask[this.NTHREADS_POOL];
    }

    public ThreadPoolImpl(boolean priorityActive, int nThreads) {
        this.priorityActive = true;
        this.NTHREADS_POOL = nThreads;
        this.init();
    }

    public ThreadPoolImpl(boolean priorityActive) {
        this.priorityActive = priorityActive;
        this.init();
    }

    public void init() {
        if (this.threadList == null) {
            this.threadList = new ThreadTask[this.NTHREADS_POOL];
        }
        for (int i = 0; i < this.NTHREADS_POOL; ++i) {
            this.threadList[i] = new ThreadTask(this);
            this.threadList[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPool(TileListener listener) {
        int i;
        if (this.threadList != null) {
            for (i = 0; i < this.NTHREADS_POOL; ++i) {
                if (this.threadList[i] == null) continue;
                Runnable r = this.threadList[i].stopThread();
                try {
                    if (listener == null) continue;
                    listener.tileReady((Tile)r);
                    continue;
                }
                catch (TileGettingException tileGettingException) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            try {
                if (listener == null) continue;
                listener.tileReady((Tile)this.tasks.get(i));
                continue;
            }
            catch (TileGettingException tileGettingException) {
                // empty catch block
            }
        }
        LinkedList<AtomicTask> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.notifyAll();
        }
        this.destroyPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyPool() {
        for (int i = 0; i < this.threadList.length; ++i) {
            this.threadList[i].cancelTaskInProgress();
        }
        LinkedList<AtomicTask> i = this.tasks;
        synchronized (i) {
            this.tasks.clear();
            this.getTilePipe().clear();
            this.tasks.notifyAll();
        }
        for (int i2 = 0; i2 < this.threadList.length; ++i2) {
            this.threadList[i2].resumeTasks();
        }
    }

    public LinkedList<AtomicTask> getInputTaskList() {
        return this.tasks;
    }

    public TilePipe getTilePipe() {
        if (this.tilePipe == null) {
            this.tilePipe = new TilePipeImpl();
        }
        return this.tilePipe;
    }

    public void destroyPool() {
        for (int i = 0; i < this.NTHREADS_POOL; ++i) {
            this.threadList[i].stopThread();
            this.threadList[i] = null;
        }
        this.threadList = null;
    }

    public boolean isPoolValid() {
        return this.threadList != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(AtomicTask task) {
        LinkedList<AtomicTask> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.addLast(task);
            this.tasks.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicTask getNext() {
        AtomicTask returnVal = null;
        LinkedList<AtomicTask> linkedList = this.tasks;
        synchronized (linkedList) {
            while (this.tasks.isEmpty()) {
                try {
                    this.tasks.wait();
                }
                catch (InterruptedException ex) {
                    System.err.println("Interrupted");
                }
            }
            if (this.priorityActive) {
                this.sort(this.tasks);
            }
            returnVal = this.tasks.removeFirst();
        }
        return returnVal;
    }

    private void sort(LinkedList<AtomicTask> tasks) {
        Collections.sort(tasks);
    }
}

