/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn.lib;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.store.dgn.lib.ByteUtils;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemArc;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemCellHeader;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemCellLibrary;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemColorTable;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemComplexHeader;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemCore;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemMultiPoint;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemTCB;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemTagSet;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemTagValue;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemText;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElementInfo;
import org.gvsig.fmap.dal.store.dgn.lib.DGNInfo;
import org.gvsig.fmap.dal.store.dgn.lib.DGNLink;
import org.gvsig.fmap.dal.store.dgn.lib.DGNPoint;
import org.gvsig.fmap.dal.store.dgn.lib.DGNTagDef;
import org.gvsig.fmap.dal.store.dgn.lib.DGNViewInfo;
import org.gvsig.fmap.dal.store.dgn.lib.double64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DGNReader {
    private static Logger logger = LoggerFactory.getLogger(DGNReader.class);
    static int[][] abyDefaultPCT = new int[][]{{255, 255, 255}, {0, 0, 255}, {0, 255, 0}, {255, 0, 0}, {255, 255, 0}, {255, 0, 255}, {255, 127, 0}, {0, 255, 255}, {64, 64, 64}, {192, 192, 192}, {254, 0, 96}, {160, 224, 0}, {0, 254, 160}, {128, 0, 160}, {176, 176, 176}, {0, 240, 240}, {240, 240, 240}, {0, 0, 240}, {0, 240, 0}, {240, 0, 0}, {240, 240, 0}, {240, 0, 240}, {240, 122, 0}, {0, 240, 240}, {240, 240, 240}, {0, 0, 240}, {0, 240, 0}, {240, 0, 0}, {240, 240, 0}, {240, 0, 240}, {240, 122, 0}, {0, 225, 225}, {225, 225, 225}, {0, 0, 225}, {0, 225, 0}, {225, 0, 0}, {225, 225, 0}, {225, 0, 225}, {225, 117, 0}, {0, 225, 225}, {225, 225, 225}, {0, 0, 225}, {0, 225, 0}, {225, 0, 0}, {225, 225, 0}, {225, 0, 225}, {225, 117, 0}, {0, 210, 210}, {210, 210, 210}, {0, 0, 210}, {0, 210, 0}, {210, 0, 0}, {210, 210, 0}, {210, 0, 210}, {210, 112, 0}, {0, 210, 210}, {210, 210, 210}, {0, 0, 210}, {0, 210, 0}, {210, 0, 0}, {210, 210, 0}, {210, 0, 210}, {210, 112, 0}, {0, 195, 195}, {195, 195, 195}, {0, 0, 195}, {0, 195, 0}, {195, 0, 0}, {195, 195, 0}, {195, 0, 195}, {195, 107, 0}, {0, 195, 195}, {195, 195, 195}, {0, 0, 195}, {0, 195, 0}, {195, 0, 0}, {195, 195, 0}, {195, 0, 195}, {195, 107, 0}, {0, 180, 180}, {180, 180, 180}, {0, 0, 180}, {0, 180, 0}, {180, 0, 0}, {180, 180, 0}, {180, 0, 180}, {180, 102, 0}, {0, 180, 180}, {180, 180, 180}, {0, 0, 180}, {0, 180, 0}, {180, 0, 0}, {180, 180, 0}, {180, 0, 180}, {180, 102, 0}, {0, 165, 165}, {165, 165, 165}, {0, 0, 165}, {0, 165, 0}, {165, 0, 0}, {165, 165, 0}, {165, 0, 165}, {165, 97, 0}, {0, 165, 165}, {165, 165, 165}, {0, 0, 165}, {0, 165, 0}, {165, 0, 0}, {165, 165, 0}, {165, 0, 165}, {165, 97, 0}, {0, 150, 150}, {150, 150, 150}, {0, 0, 150}, {0, 150, 0}, {150, 0, 0}, {150, 150, 0}, {150, 0, 150}, {150, 92, 0}, {0, 150, 150}, {150, 150, 150}, {0, 0, 150}, {0, 150, 0}, {150, 0, 0}, {150, 150, 0}, {150, 0, 150}, {150, 92, 0}, {0, 135, 135}, {135, 135, 135}, {0, 0, 135}, {0, 135, 0}, {135, 0, 0}, {135, 135, 0}, {135, 0, 135}, {135, 87, 0}, {0, 135, 135}, {135, 135, 135}, {0, 0, 135}, {0, 135, 0}, {135, 0, 0}, {135, 135, 0}, {135, 0, 135}, {135, 87, 0}, {0, 120, 120}, {120, 120, 120}, {0, 0, 120}, {0, 120, 0}, {120, 0, 0}, {120, 120, 0}, {120, 0, 120}, {120, 82, 0}, {0, 120, 120}, {120, 120, 120}, {0, 0, 120}, {0, 120, 0}, {120, 0, 0}, {120, 120, 0}, {120, 0, 120}, {120, 82, 0}, {0, 105, 105}, {105, 105, 105}, {0, 0, 105}, {0, 105, 0}, {105, 0, 0}, {105, 105, 0}, {105, 0, 105}, {105, 77, 0}, {0, 105, 105}, {105, 105, 105}, {0, 0, 105}, {0, 105, 0}, {105, 0, 0}, {105, 105, 0}, {105, 0, 105}, {105, 77, 0}, {0, 90, 90}, {90, 90, 90}, {0, 0, 90}, {0, 90, 0}, {90, 0, 0}, {90, 90, 0}, {90, 0, 90}, {90, 72, 0}, {0, 90, 90}, {90, 90, 90}, {0, 0, 90}, {0, 90, 0}, {90, 0, 0}, {90, 90, 0}, {90, 0, 90}, {90, 72, 0}, {0, 75, 75}, {75, 75, 75}, {0, 0, 75}, {0, 75, 0}, {75, 0, 0}, {75, 75, 0}, {75, 0, 75}, {75, 67, 0}, {0, 75, 75}, {75, 75, 75}, {0, 0, 75}, {0, 75, 0}, {75, 0, 0}, {75, 75, 0}, {75, 0, 75}, {75, 67, 0}, {0, 60, 60}, {60, 60, 60}, {0, 0, 60}, {0, 60, 0}, {60, 0, 0}, {60, 60, 0}, {60, 0, 60}, {60, 62, 0}, {0, 60, 60}, {60, 60, 60}, {0, 0, 60}, {0, 60, 0}, {60, 0, 0}, {60, 60, 0}, {60, 0, 60}, {60, 62, 0}, {0, 45, 45}, {45, 45, 45}, {0, 0, 45}, {0, 45, 0}, {45, 0, 0}, {45, 45, 0}, {45, 0, 45}, {45, 57, 0}, {0, 45, 45}, {45, 45, 45}, {0, 0, 45}, {0, 45, 0}, {45, 0, 0}, {45, 45, 0}, {45, 0, 45}, {45, 57, 0}, {0, 30, 30}, {30, 30, 30}, {0, 0, 30}, {0, 30, 0}, {30, 0, 0}, {30, 30, 0}, {30, 0, 30}, {30, 52, 0}, {0, 30, 30}, {30, 30, 30}, {0, 0, 30}, {0, 30, 0}, {30, 0, 0}, {30, 30, 0}, {30, 0, 30}, {192, 192, 192}, {28, 0, 100}};
    private int LSB;
    private FileInputStream fin;
    private MappedByteBuffer bb;
    private int FALSE = 0;
    private int TRUE = 1;
    private DGNElemCore elemento;
    private DGNInfo info;
    private Rectangle2D.Double m_BoundingBox;
    private DGNElemColorTable m_colorTable;
    private boolean logErrors = false;

    public DGNReader(String pathFich) throws DataException {
        this(pathFich, false);
    }

    public DGNReader(String pathFich, boolean logErrors) throws DataException {
        int nType;
        this.logErrors = logErrors;
        this.info = new DGNInfo();
        DGNElemCore elemento = new DGNElemCore(this);
        boolean bReportExtents = false;
        byte[] achRaw = new byte[64];
        achRaw[63] = 1;
        double dfSFXMin = 0.0;
        double dfSFXMax = 0.0;
        double dfSFYMin = 0.0;
        double dfSFYMax = 0.0;
        this.info.fp = pathFich;
        this.info = this.DGNOpen(this.info, 0);
        this.bb.rewind();
        this.DGNSetSpatialFilter(this.info, dfSFXMin, dfSFYMin, dfSFXMax, dfSFYMax);
        int[] anLevelTypeCount = new int[8192];
        int[] anLevelCount = new int[64];
        int[] anTypeCount = new int[128];
        double[] adfExtents = new double[6];
        int[] nCount = new int[]{0};
        this.DGNGetExtents(this.info, adfExtents);
        this.logdebug("X Range:" + adfExtents[0] + ", " + adfExtents[3]);
        this.logdebug("Y Range:" + adfExtents[1] + ", " + adfExtents[4]);
        this.logdebug("Z Range:" + adfExtents[2] + ", " + adfExtents[5]);
        this.m_BoundingBox = new Rectangle2D.Double();
        this.m_BoundingBox.setRect(adfExtents[0], adfExtents[1], adfExtents[3] - adfExtents[0], adfExtents[4] - adfExtents[1]);
        DGNElementInfo[] pasEI = this.DGNGetElementIndex(this.info, nCount);
        this.logdebug("Total Elements:" + nCount[0]);
        for (int i = 0; i < nCount[0]; ++i) {
            int n = pasEI[i].level * 128 + pasEI[i].type;
            anLevelTypeCount[n] = anLevelTypeCount[n] + 1;
            int n2 = pasEI[i].level;
            anLevelCount[n2] = anLevelCount[n2] + 1;
            int n3 = pasEI[i].type;
            anTypeCount[n3] = anTypeCount[n3] + 1;
        }
        this.logdebug("Per Type Report");
        this.logdebug("===============");
        for (nType = 0; nType < 128; ++nType) {
            if (anTypeCount[nType] == 0) continue;
            this.logdebug("Type:" + this.DGNTypeToName(nType) + ":" + anTypeCount[nType]);
        }
        this.logdebug("Per Level Report\n");
        this.logdebug("================\n");
        for (int nLevel = 0; nLevel < 64; ++nLevel) {
            if (anLevelCount[nLevel] == 0) continue;
            this.logdebug("Level " + nLevel + "," + anLevelCount[nLevel] + "elements:");
            for (nType = 0; nType < 128; ++nType) {
                if (anLevelTypeCount[nLevel * 128 + nType] == 0) continue;
                this.logdebug("  Type " + this.DGNTypeToName(nType) + "," + anLevelTypeCount[nLevel * 128 + nType]);
            }
        }
        this.bb.rewind();
    }

    public boolean is3D() {
        return this.info.dimension == 3;
    }

    public DGNInfo getInfo() {
        return this.info;
    }

    public int getNumEntities() {
        return this.info.element_count;
    }

    public Rectangle2D getBoundingBox() {
        return this.m_BoundingBox;
    }

    public int DGNGotoElement(int element_id) {
        this.DGNBuildIndex(this.info);
        if (element_id < 0 || element_id >= this.info.element_count) {
            return this.FALSE;
        }
        this.bb.position((int)this.info.element_index[element_id].offset);
        this.info.next_element_id = element_id;
        this.info.in_complex_group = this.FALSE;
        return this.TRUE;
    }

    private DGNInfo DGNOpen(DGNInfo info, int bUpdate) throws DataException {
        int pos = 0;
        byte[] abyHeader = new byte[512];
        info.next_element_id = 0;
        info.got_tcb = this.FALSE;
        info.scale = 1.0;
        info.origin_x = 0.0;
        info.origin_y = 0.0;
        info.origin_z = 0.0;
        info.index_built = this.FALSE;
        info.element_count = 0;
        info.element_index = null;
        info.got_bounds = this.FALSE;
        try {
            this.fin = new FileInputStream(info.fp);
            FileChannel fc = this.fin.getChannel();
            long sz = fc.size();
            this.bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            this.bb.order(ByteOrder.nativeOrder());
            this.bb.get(abyHeader, pos, abyHeader.length);
            info.ftall = (int)(sz / 16L);
            if (this.bb.order() == ByteOrder.LITTLE_ENDIAN) {
                this.LSB = this.TRUE;
            }
            if (this.DGNTestOpen(abyHeader, abyHeader.length) != this.FALSE) {
                info.dimension = abyHeader[0] == -56 ? 3 : 2;
                info.has_spatial_filter = this.FALSE;
                info.sf_converted_to_uor = this.FALSE;
                info.select_complex_group = this.FALSE;
                info.in_complex_group = this.FALSE;
            }
        }
        catch (FileNotFoundException e) {
            throw new org.gvsig.fmap.dal.exception.FileNotFoundException(info.fp);
        }
        catch (Exception e) {
            throw new ReadException("DGNReader error", (Throwable)e);
        }
        return info;
    }

    private int DGNTestOpen(byte[] pabyHeader, int nByteCount) {
        if (nByteCount < 4) {
            return this.TRUE;
        }
        if (pabyHeader[0] == 8 && pabyHeader[1] == 5 && pabyHeader[2] == 23 && pabyHeader[3] == 0) {
            return this.TRUE;
        }
        if (pabyHeader[0] != 8 && pabyHeader[0] != -56 || pabyHeader[1] != 9 || pabyHeader[2] != -2 || pabyHeader[3] != 2) {
            return this.FALSE;
        }
        return this.TRUE;
    }

    private int DGNLoadRawElement(DGNInfo info, DGNElemCore core) {
        int nType = 0;
        int nWords = 0;
        int nLevel = 0;
        int bytesCount = 0;
        try {
            for (int i = 0; i < 4; ++i) {
                info.abyElem[i] = this.bb.get();
                if (i != 1 || info.abyElem[0] != -1 || info.abyElem[1] != -1) continue;
                return this.FALSE;
            }
            nWords = ByteUtils.byteToUnsignedInt(info.abyElem[2]) + ByteUtils.byteToUnsignedInt(info.abyElem[3]) * 256;
            nType = ByteUtils.byteToUnsignedInt(info.abyElem[1]) & 0x7F;
            nLevel = ByteUtils.byteToUnsignedInt(info.abyElem[0]) & 0x3F;
            if (nWords * 2 + 4 > info.abyElem.length) {
                return this.FALSE;
            }
            while (bytesCount < nWords * 2 && this.bb.hasRemaining()) {
                info.abyElem[bytesCount + 4] = this.bb.get();
                ++bytesCount;
            }
            info.ftall = this.bb.position();
        }
        catch (Exception e) {
            this.logwarn(MessageFormat.format("The DGN file {0} may not be loaded correctly.\nError loading:\nnWords = {1}\ninfo.next_element_id {2}\ninfo.abyElem.length =  {3}\nbb.position() =  {4}", info.fp, nWords, info.next_element_id, info.abyElem.length, this.bb.position()), e);
            return this.FALSE;
        }
        info.nElemBytes = bytesCount + 4;
        ++info.next_element_id;
        core.type = nType;
        core.level = nLevel;
        return this.TRUE;
    }

    private void DGNSpatialFilterToUOR(DGNInfo info) {
        DGNPoint sMin = new DGNPoint();
        DGNPoint sMax = new DGNPoint();
        if (info.sf_converted_to_uor == 1 || info.has_spatial_filter != 1 || info.got_tcb != 1) {
            return;
        }
        sMin.x = info.sf_min_x_geo;
        sMin.y = info.sf_min_y_geo;
        sMin.z = 0.0;
        sMax.x = info.sf_max_x_geo;
        sMax.y = info.sf_max_y_geo;
        sMax.z = 0.0;
        this.DGNInverseTransformPoint(info, sMin);
        this.DGNInverseTransformPoint(info, sMax);
        info.sf_min_x = (long)(sMin.x + 2.147483648E9);
        info.sf_min_y = (long)(sMin.y + 2.147483648E9);
        info.sf_max_x = (long)(sMax.x + 2.147483648E9);
        info.sf_max_y = (long)(sMax.y + 2.147483648E9);
        info.sf_converted_to_uor = this.TRUE;
    }

    private void DGNInverseTransformPoint(DGNInfo info, DGNPoint punto) {
        punto.x = (punto.x + info.origin_x) / info.scale;
        punto.y = (punto.y + info.origin_y) / info.scale;
        punto.z = (punto.z + info.origin_z) / info.scale;
        punto.x = Math.max(-2.147483647E9, Math.min(2.147483647E9, punto.x));
        punto.y = Math.max(-2.147483647E9, Math.min(2.147483647E9, punto.y));
        punto.z = Math.max(-2.147483647E9, Math.min(2.147483647E9, punto.z));
    }

    public DGNElemCore DGNReadElement() {
        int bInsideFilter;
        DGNElemCore elemento = new DGNElemCore(this);
        do {
            bInsideFilter = this.TRUE;
            int fin_fichero = this.DGNLoadRawElement(this.info, elemento);
            if (fin_fichero == this.FALSE) {
                return null;
            }
            if (this.info.has_spatial_filter == this.FALSE) continue;
            if (this.info.sf_converted_to_uor == this.FALSE) {
                this.DGNSpatialFilterToUOR(this.info);
            }
            if (this.DGNGetRawExtents(this.info, null, elemento) == null) {
                bInsideFilter = this.TRUE;
            } else if (this.info.min_x > (double)this.info.sf_max_x || this.info.min_y > (double)this.info.sf_max_y || this.info.max_x < (double)this.info.sf_min_x || this.info.max_y < (double)this.info.sf_min_y) {
                bInsideFilter = this.FALSE;
            }
            if (elemento.type == 12 || elemento.type == 14) {
                this.info.in_complex_group = this.TRUE;
                this.info.select_complex_group = bInsideFilter;
                continue;
            }
            if ((this.info.abyElem[0] & 0xFFFFFF80) != this.FALSE) {
                if (this.info.in_complex_group != this.TRUE) continue;
                bInsideFilter = this.info.select_complex_group;
                continue;
            }
            this.info.in_complex_group = this.FALSE;
        } while (bInsideFilter == this.FALSE);
        elemento = this.DGNProcessElement(this.info, elemento.type, elemento.level);
        return elemento;
    }

    public double[] DGNGetRawExtents(DGNInfo info, byte[] pabyRawData, DGNElemCore elemento) {
        if (pabyRawData == null) {
            pabyRawData = info.abyElem;
        }
        double[] tempo = new double[6];
        switch (elemento.type) {
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                byte[] temp = new byte[4];
                System.arraycopy(pabyRawData, 4, temp, 0, 4);
                tempo[0] = this.DGN_INT32(temp);
                System.arraycopy(pabyRawData, 8, temp, 0, 4);
                tempo[1] = this.DGN_INT32(temp);
                System.arraycopy(pabyRawData, 12, temp, 0, 4);
                tempo[2] = this.DGN_INT32(temp);
                System.arraycopy(pabyRawData, 16, temp, 0, 4);
                tempo[3] = this.DGN_INT32(temp);
                System.arraycopy(pabyRawData, 20, temp, 0, 4);
                tempo[4] = this.DGN_INT32(temp);
                System.arraycopy(pabyRawData, 24, temp, 0, 4);
                tempo[5] = this.DGN_INT32(temp);
                return tempo;
            }
        }
        return null;
    }

    private double DGN_INT32(byte[] p) {
        int x = 256;
        int x0 = p[0];
        int x1 = p[1];
        int x2 = p[2];
        int x3 = p[3];
        if (p[0] < 0) {
            x0 = x + p[0];
        }
        if (p[1] < 0) {
            x1 = x + p[1];
        }
        if (p[2] < 0) {
            x2 = x + p[2];
        }
        if (p[3] < 0) {
            x3 = x + p[3];
        }
        return x2 + x3 * 256 + x1 * 65536 * 256 + x0 * 65536;
    }

    private DGNElemCore DGNProcessElement(DGNInfo info, int nType, int nLevel) {
        DGNElemCore elemento = new DGNElemCore(this);
        switch (nType) {
            case 34: {
                this.logdebug("DGNProcessElement (DGNT_SHARED_CELL_DEFN): Type " + this.DGNTypeToName(nType));
                elemento.stype = 13;
                this.DGNParseCore(info, elemento);
                break;
            }
            case 2: {
                DGNElemCore psCell = new DGNElemCellHeader(this);
                psCell.stype = 8;
                this.DGNParseCore(info, psCell);
                psCell.totlength = ByteUtils.getUnsigned(info.abyElem[36]) + ByteUtils.getUnsigned(info.abyElem[37]) * 256;
                byte[] temp = new byte[psCell.name.length];
                System.arraycopy(psCell.name, 0, temp, 0, psCell.name.length);
                this.DGNRad50ToAscii(ByteUtils.byteToUnsignedInt(info.abyElem[38]) + ByteUtils.byteToUnsignedInt(info.abyElem[39]) * 256, temp);
                System.arraycopy(psCell.name, 3, temp, 0, psCell.name.length - 3);
                this.DGNRad50ToAscii(ByteUtils.byteToUnsignedInt(info.abyElem[40]) + ByteUtils.byteToUnsignedInt(info.abyElem[41]) * 256, temp);
                psCell.cclass = ByteUtils.byteToUnsignedInt(info.abyElem[42]) + ByteUtils.byteToUnsignedInt(info.abyElem[43]) * 256;
                psCell.levels[0] = ByteUtils.byteToUnsignedInt(info.abyElem[44]) + ByteUtils.byteToUnsignedInt(info.abyElem[45]) * 256;
                psCell.levels[1] = ByteUtils.byteToUnsignedInt(info.abyElem[46]) + ByteUtils.byteToUnsignedInt(info.abyElem[47]) * 256;
                psCell.levels[2] = ByteUtils.byteToUnsignedInt(info.abyElem[48]) + ByteUtils.byteToUnsignedInt(info.abyElem[49]) * 256;
                psCell.levels[3] = ByteUtils.byteToUnsignedInt(info.abyElem[50]) + ByteUtils.byteToUnsignedInt(info.abyElem[51]) * 256;
                psCell.color = info.abyElem[35];
                if (info.dimension == 2) {
                    byte[] temp1 = new byte[4];
                    System.arraycopy(info.abyElem, 52, temp1, 0, 4);
                    psCell.rnglow.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 56, temp1, 0, 4);
                    psCell.rnglow.y = this.DGN_INT32(temp);
                    System.arraycopy(info.abyElem, 60, temp1, 0, 4);
                    psCell.rnghigh.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 64, temp1, 0, 4);
                    psCell.rnghigh.y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 84, temp1, 0, 4);
                    psCell.origin.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 88, temp1, 0, 4);
                    psCell.origin.y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 68, temp1, 0, 4);
                    double a = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 72, temp1, 0, 4);
                    double b = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 76, temp1, 0, 4);
                    double c = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 80, temp1, 0, 4);
                    double d = this.DGN_INT32(temp1);
                    double a2 = a * a;
                    double c2 = c * c;
                    psCell.xscale = Math.sqrt(a2 + c2) / 214748.0;
                    psCell.yscale = Math.sqrt(b * b + d * d) / 214748.0;
                    psCell.rotation = Math.acos(a / Math.sqrt(a2 + c2));
                    psCell.rotation = b <= 0.0 ? psCell.rotation * 180.0 / Math.PI : 360.0 - psCell.rotation * 180.0 / Math.PI;
                } else {
                    byte[] temp1 = new byte[4];
                    System.arraycopy(info.abyElem, 52, temp1, 0, 4);
                    psCell.rnglow.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 56, temp1, 0, 4);
                    psCell.rnglow.y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 60, temp1, 0, 4);
                    psCell.rnglow.z = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 64, temp1, 0, 4);
                    psCell.rnghigh.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 68, temp1, 0, 4);
                    psCell.rnghigh.y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 72, temp1, 0, 4);
                    psCell.rnghigh.z = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 112, temp1, 0, 4);
                    psCell.origin.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 116, temp1, 0, 4);
                    psCell.origin.y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 120, temp1, 0, 4);
                    psCell.origin.z = this.DGN_INT32(temp1);
                }
                this.DGNTransformPoint(info, psCell.rnglow);
                this.DGNTransformPoint(info, psCell.rnghigh);
                this.DGNTransformPoint(info, psCell.origin);
                elemento = psCell;
                break;
            }
            case 1: {
                this.logdebug("DGNProcessElement (DGNT_CELL_LIBRARY): Type " + this.DGNTypeToName(nType));
                DGNElemCore psCell = new DGNElemCellLibrary(this);
                ((DGNElemCellLibrary)psCell).stype = 11;
                this.DGNParseCore(info, psCell);
                byte[] temp = new byte[((DGNElemCellLibrary)psCell).name.length];
                System.arraycopy(((DGNElemCellLibrary)psCell).name, 0, temp, 0, ((DGNElemCellLibrary)psCell).name.length);
                this.DGNRad50ToAscii(ByteUtils.byteToUnsignedInt(info.abyElem[32]) + ByteUtils.byteToUnsignedInt(info.abyElem[33]) * 256, temp);
                System.arraycopy(((DGNElemCellLibrary)psCell).name, 3, temp, 0, ((DGNElemCellLibrary)psCell).name.length);
                this.DGNRad50ToAscii(ByteUtils.byteToUnsignedInt(info.abyElem[34]) + ByteUtils.byteToUnsignedInt(info.abyElem[35]) * 256, temp);
                ((DGNElemCellLibrary)psCell).properties = info.abyElem[38] + info.abyElem[39] * 256;
                ((DGNElemCellLibrary)psCell).dispsymb = ByteUtils.byteToUnsignedInt(info.abyElem[40]) + ByteUtils.byteToUnsignedInt(info.abyElem[41]) * 256;
                ((DGNElemCellLibrary)psCell).cclass = ByteUtils.byteToUnsignedInt(info.abyElem[42]) + ByteUtils.byteToUnsignedInt(info.abyElem[43]) * 256;
                ((DGNElemCellLibrary)psCell).levels[0] = ByteUtils.byteToUnsignedInt(info.abyElem[44]) + ByteUtils.byteToUnsignedInt(info.abyElem[45]) * 256;
                ((DGNElemCellLibrary)psCell).levels[1] = ByteUtils.byteToUnsignedInt(info.abyElem[46]) + ByteUtils.byteToUnsignedInt(info.abyElem[47]) * 256;
                ((DGNElemCellLibrary)psCell).levels[2] = ByteUtils.byteToUnsignedInt(info.abyElem[48]) + ByteUtils.byteToUnsignedInt(info.abyElem[49]) * 256;
                ((DGNElemCellLibrary)psCell).levels[3] = ByteUtils.byteToUnsignedInt(info.abyElem[50]) + ByteUtils.byteToUnsignedInt(info.abyElem[51]) * 256;
                ((DGNElemCellLibrary)psCell).numwords = ByteUtils.byteToUnsignedInt(info.abyElem[36]) + ByteUtils.byteToUnsignedInt(info.abyElem[37]) * 256;
                for (int iWord = 0; iWord < 9; ++iWord) {
                    int iOffset = 52 + iWord * 2;
                    System.arraycopy(((DGNElemCellLibrary)psCell).name, iWord * 3, temp, 0, ((DGNElemCellLibrary)psCell).description.length);
                    this.DGNRad50ToAscii(ByteUtils.byteToUnsignedInt(info.abyElem[iOffset]) + ByteUtils.byteToUnsignedInt(info.abyElem[iOffset + 1]) * 256, temp);
                }
                elemento = psCell;
                break;
            }
            case 3: {
                DGNElemMultiPoint psLine = new DGNElemMultiPoint(this);
                psLine.stype = 2;
                this.DGNParseCore(info, psLine);
                psLine.num_vertices = 2;
                psLine.vertices = new DGNPoint[psLine.num_vertices];
                if (info.dimension == 2) {
                    byte[] temp1 = new byte[4];
                    System.arraycopy(info.abyElem, 36, temp1, 0, 4);
                    psLine.vertices[0] = new DGNPoint();
                    psLine.vertices[0].x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 40, temp1, 0, 4);
                    psLine.vertices[0].y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 44, temp1, 0, 4);
                    psLine.vertices[1] = new DGNPoint();
                    psLine.vertices[1].x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 48, temp1, 0, 4);
                    psLine.vertices[1].y = this.DGN_INT32(temp1);
                } else {
                    byte[] temp1 = new byte[4];
                    System.arraycopy(info.abyElem, 36, temp1, 0, 4);
                    psLine.vertices[0] = new DGNPoint();
                    psLine.vertices[0].x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 40, temp1, 0, 4);
                    psLine.vertices[0].y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 44, temp1, 0, 4);
                    psLine.vertices[0].z = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 48, temp1, 0, 4);
                    psLine.vertices[1] = new DGNPoint();
                    psLine.vertices[1].x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 52, temp1, 0, 4);
                    psLine.vertices[1].y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 56, temp1, 0, 4);
                    psLine.vertices[1].z = this.DGN_INT32(temp1);
                }
                this.DGNTransformPoint(info, psLine.vertices[0]);
                this.DGNTransformPoint(info, psLine.vertices[1]);
                elemento = psLine;
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 21: {
                DGNElemMultiPoint psLine = new DGNElemMultiPoint(this);
                int pntsize = info.dimension * 4;
                int count = ByteUtils.byteToUnsignedInt(info.abyElem[36]) + ByteUtils.byteToUnsignedInt(info.abyElem[37]) * 256;
                psLine.stype = 2;
                this.DGNParseCore(info, psLine);
                if (info.nElemBytes < 38 + count * pntsize) {
                    this.logdebug("Error en los vertices de multipunto");
                    count = (info.nElemBytes - 38) / pntsize;
                    return null;
                }
                psLine.num_vertices = count;
                psLine.vertices = new DGNPoint[psLine.num_vertices];
                for (int i = 0; i < psLine.num_vertices; ++i) {
                    byte[] temp1 = new byte[4];
                    System.arraycopy(info.abyElem, 38 + i * pntsize, temp1, 0, 4);
                    psLine.vertices[i] = new DGNPoint();
                    psLine.vertices[i].x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 42 + i * pntsize, temp1, 0, 4);
                    psLine.vertices[i].y = this.DGN_INT32(temp1);
                    if (info.dimension == 3) {
                        System.arraycopy(info.abyElem, 46 + i * pntsize, temp1, 0, 4);
                        psLine.vertices[i].z = this.DGN_INT32(temp1);
                    }
                    this.DGNTransformPoint(info, psLine.vertices[i]);
                }
                elemento = psLine;
                break;
            }
            case 5: {
                if (nLevel == 1) {
                    elemento = this.DGNParseColorTable(info);
                    break;
                }
                elemento.stype = 1;
                this.DGNParseCore(info, elemento);
                break;
            }
            case 15: {
                DGNElemArc psEllipse = new DGNElemArc(this);
                psEllipse.stype = 5;
                this.DGNParseCore(info, psEllipse);
                int[] fin = new int[]{0};
                byte[] temp1 = new byte[8];
                System.arraycopy(info.abyElem, 36, temp1, 0, 8);
                fin[0] = 0;
                psEllipse.primary_axis = this.DGNParseIEEE(temp1);
                psEllipse.primary_axis *= info.scale;
                System.arraycopy(info.abyElem, 44, temp1, 0, 8);
                fin[0] = 0;
                psEllipse.secondary_axis = this.DGNParseIEEE(temp1);
                psEllipse.secondary_axis *= info.scale;
                if (info.dimension == 2) {
                    System.arraycopy(info.abyElem, 52, temp1, 0, 4);
                    psEllipse.rotation = this.DGN_INT32(temp1);
                    psEllipse.rotation /= 360000.0;
                    System.arraycopy(info.abyElem, 56, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.x = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 64, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.y = this.DGNParseIEEE(temp1);
                } else {
                    System.arraycopy(info.abyElem, 68, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.x = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 76, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.y = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 84, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.z = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 52, temp1, 0, 4);
                    psEllipse.quat[0] = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 56, temp1, 0, 4);
                    psEllipse.quat[1] = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 60, temp1, 0, 4);
                    psEllipse.quat[2] = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 64, temp1, 0, 4);
                    psEllipse.quat[3] = this.DGN_INT32(temp1);
                }
                this.DGNTransformPoint(info, psEllipse.origin);
                psEllipse.startang = 0.0;
                psEllipse.sweepang = 360.0;
                elemento = psEllipse;
                break;
            }
            case 16: {
                double nSweepVal;
                DGNElemArc psEllipse = new DGNElemArc(this);
                psEllipse.stype = 5;
                this.DGNParseCore(info, psEllipse);
                int[] fin = new int[]{0};
                byte[] temp1 = new byte[8];
                System.arraycopy(info.abyElem, 36, temp1, 0, 4);
                psEllipse.startang = this.DGN_INT32(temp1);
                psEllipse.startang /= 360000.0;
                if ((info.abyElem[41] & 0xFFFFFF80) != this.FALSE) {
                    info.abyElem[41] = (byte)(info.abyElem[41] & 0x7F);
                    System.arraycopy(info.abyElem, 40, temp1, 0, 4);
                    nSweepVal = -1.0 * this.DGN_INT32(temp1);
                } else {
                    System.arraycopy(info.abyElem, 40, temp1, 0, 4);
                    nSweepVal = this.DGN_INT32(temp1);
                }
                psEllipse.sweepang = nSweepVal == 0.0 ? 360.0 : nSweepVal / 360000.0;
                System.arraycopy(info.abyElem, 44, temp1, 0, 8);
                fin[0] = 0;
                psEllipse.primary_axis = this.DGNParseIEEE(temp1);
                psEllipse.primary_axis *= info.scale;
                System.arraycopy(info.abyElem, 52, temp1, 0, 8);
                fin[0] = 0;
                psEllipse.secondary_axis = this.DGNParseIEEE(temp1);
                psEllipse.secondary_axis *= info.scale;
                if (info.dimension == 2) {
                    System.arraycopy(info.abyElem, 60, temp1, 0, 4);
                    psEllipse.rotation = this.DGN_INT32(temp1);
                    psEllipse.rotation /= 360000.0;
                    System.arraycopy(info.abyElem, 64, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.x = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 72, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.y = this.DGNParseIEEE(temp1);
                } else {
                    psEllipse.rotation = 0.0;
                    System.arraycopy(info.abyElem, 76, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.x = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 84, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.y = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 92, temp1, 0, 8);
                    fin[0] = 0;
                    psEllipse.origin.z = this.DGNParseIEEE(temp1);
                    System.arraycopy(info.abyElem, 60, temp1, 0, 4);
                    psEllipse.quat[0] = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 64, temp1, 0, 4);
                    psEllipse.quat[1] = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 68, temp1, 0, 4);
                    psEllipse.quat[2] = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 72, temp1, 0, 4);
                    psEllipse.quat[3] = this.DGN_INT32(temp1);
                }
                this.DGNTransformPoint(info, psEllipse.origin);
                elemento = psEllipse;
                break;
            }
            case 17: {
                int text_off;
                DGNElemText psText = new DGNElemText(this);
                int num_chars = info.dimension == 2 ? ByteUtils.byteToUnsignedInt(info.abyElem[58]) : ByteUtils.byteToUnsignedInt(info.abyElem[74]);
                psText.stype = 6;
                this.DGNParseCore(info, psText);
                psText.font_id = ByteUtils.byteToUnsignedInt(info.abyElem[36]);
                psText.justification = ByteUtils.byteToUnsignedInt(info.abyElem[37]);
                byte[] temp1 = new byte[8];
                System.arraycopy(info.abyElem, 38, temp1, 0, 4);
                psText.length_mult = this.DGN_INT32(temp1) * info.scale * 6.0 / 1000.0;
                System.arraycopy(info.abyElem, 42, temp1, 0, 4);
                psText.height_raw = this.DGN_INT32(temp1);
                psText.height_mult = psText.height_raw * info.scale * 6.0 / 1000.0;
                int[] fin = new int[]{0};
                if (info.dimension == 2) {
                    System.arraycopy(info.abyElem, 46, temp1, 0, 4);
                    psText.rotation = this.DGN_INT32(temp1);
                    psText.rotation /= 360000.0;
                    System.arraycopy(info.abyElem, 50, temp1, 0, 4);
                    psText.origin.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 54, temp1, 0, 4);
                    psText.origin.y = this.DGN_INT32(temp1);
                    text_off = 60;
                } else {
                    System.arraycopy(info.abyElem, 62, temp1, 0, 4);
                    psText.origin.x = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 66, temp1, 0, 4);
                    psText.origin.y = this.DGN_INT32(temp1);
                    System.arraycopy(info.abyElem, 70, temp1, 0, 4);
                    psText.origin.z = this.DGN_INT32(temp1);
                    text_off = 76;
                }
                this.DGNTransformPoint(info, psText.origin);
                byte[] temp = new byte[num_chars];
                System.arraycopy(info.abyElem, text_off, temp, 0, num_chars);
                Object strAux = null;
                try {
                    psText.string = new String(temp, "ISO-8859-1");
                }
                catch (Exception e) {
                    this.logwarn("Can't create java string from byte array (" + this.dumpBuffer(temp) + ").", e);
                }
                elemento = psText;
                break;
            }
            case 9: {
                if (info.got_tcb != this.FALSE) break;
                elemento = this.DGNParseTCB(info);
                elemento.level = nLevel;
                elemento.type = nType;
                break;
            }
            case 12: 
            case 14: {
                DGNElemComplexHeader psHdr = new DGNElemComplexHeader(this);
                psHdr.stype = 7;
                this.DGNParseCore(info, psHdr);
                psHdr.totlength = ByteUtils.byteToUnsignedInt(info.abyElem[36]) + ByteUtils.byteToUnsignedInt(info.abyElem[37]) * 256;
                psHdr.numelems = ByteUtils.byteToUnsignedInt(info.abyElem[38]) + ByteUtils.byteToUnsignedInt(info.abyElem[39]) * 256;
                elemento = psHdr;
                break;
            }
            case 37: {
                DGNElemTagValue psTag = new DGNElemTagValue(this);
                psTag.stype = 9;
                this.DGNParseCore(info, psTag);
                int[] fin = new int[]{0};
                byte[] temp1 = new byte[8];
                psTag.tagType = ByteUtils.byteToUnsignedInt(info.abyElem[74]) + ByteUtils.byteToUnsignedInt(info.abyElem[75]) * 256;
                System.arraycopy(info.abyElem, 68, temp1, 0, 4);
                fin[0] = 0;
                psTag.tagSet = ByteUtils.bytesToInt(temp1, fin);
                psTag.tagSet = this.CPL_LSBWORD32(psTag.tagSet);
                psTag.tagIndex = ByteUtils.byteToUnsignedInt(info.abyElem[72]) + ByteUtils.byteToUnsignedInt(info.abyElem[73]) * 256;
                psTag.tagLength = ByteUtils.byteToUnsignedInt(info.abyElem[150]) + ByteUtils.byteToUnsignedInt(info.abyElem[151]) * 256;
                if (psTag.tagType == 1) {
                    byte[] temp = new byte[info.abyElem.length - 154];
                    System.arraycopy(info.abyElem, 4, temp1, 0, 4);
                    fin[0] = 0;
                    psTag.tagValue.string = ByteUtils.bytesToString(temp1, fin).toCharArray();
                } else if (psTag.tagType == 3) {
                    byte[] temp = new byte[4];
                    System.arraycopy(info.abyElem, 154, temp1, 0, 4);
                    fin[0] = 0;
                    psTag.tagValue.integer = ByteUtils.bytesToInt(temp1, fin);
                    psTag.tagValue.integer = this.CPL_LSBWORD32((int)psTag.tagValue.integer);
                } else if (psTag.tagType == 4) {
                    byte[] temp = new byte[8];
                    System.arraycopy(info.abyElem, 154, temp1, 0, 8);
                    fin[0] = 0;
                    psTag.tagValue.real = this.DGNParseIEEE(temp1);
                }
                elemento = psTag;
                break;
            }
            default: {
                elemento.stype = 1;
                this.DGNParseCore(info, elemento);
            }
        }
        if (elemento.stype == 1 || (info.options & 1) != this.FALSE) {
            elemento.raw_bytes = info.nElemBytes;
            elemento.raw_data = new byte[elemento.raw_bytes];
            int[] fin = new int[]{0};
            System.arraycopy(info.abyElem, 0, elemento.raw_data, 0, elemento.raw_bytes);
        }
        elemento.element_id = info.next_element_id - 1;
        elemento.offset = info.ftall - info.nElemBytes;
        elemento.size = info.nElemBytes;
        return elemento;
    }

    private String numberFormat(String fmt, byte number) {
        Formatter out = new Formatter();
        return out.format(fmt, number).toString();
    }

    private String numberFormat(String fmt, int number) {
        Formatter out = new Formatter();
        return out.format(fmt, number).toString();
    }

    private String numberFormat(String fmt, double number) {
        Formatter out = new Formatter();
        return out.format(fmt, number).toString();
    }

    private String dumpBuffer(byte[] buffer) {
        StringBuffer out = new StringBuffer();
        StringBuffer out1 = new StringBuffer();
        Formatter out2 = new Formatter();
        int n = 0;
        for (int i = 0; i < buffer.length; ++i) {
            int ch = buffer[i] & 0xFF;
            if (Character.isLetterOrDigit(ch)) {
                out1.append(Character.valueOf((char)ch));
            } else {
                out1.append("-");
            }
            out2.format("0x%02X ", ch);
            if (++n < 8) continue;
            n = 0;
            out.append(out1);
            out.append("|");
            out.append(out2);
            out.append("\n");
            out1 = new StringBuffer();
            out2 = new Formatter();
        }
        if (out1.length() > 0) {
            out.append(out1);
            out.append("|");
            out.append(out2);
            out.append("\n");
        }
        return out.toString();
    }

    private double DGNParseIEEE(double d) {
        byte[] temp = new byte[8];
        int[] f = new int[]{0};
        ByteUtils.doubleToBytes(d, temp, f);
        return this.DGNParseIEEE(temp);
    }

    private double DGNParseIEEE(byte[] b) {
        byte BYTE2 = b[7];
        byte BYTE3 = b[6];
        byte BYTE0 = b[5];
        byte BYTE1 = b[4];
        byte BYTE6 = b[3];
        byte BYTE7 = b[2];
        byte BYTE4 = b[1];
        byte BYTE5 = b[0];
        byte[] temp = new byte[4];
        byte[] temp1 = new byte[4];
        temp[3] = BYTE7;
        temp[2] = BYTE6;
        temp[1] = BYTE5;
        temp[0] = BYTE4;
        int[] f = new int[]{0};
        int hi = ByteUtils.bytesToInt(temp, f);
        int sign = hi & Integer.MIN_VALUE;
        int exponent = hi >> 23;
        if ((exponent &= 0xFF) != 0) {
            exponent = exponent - 129 + 1023;
        }
        temp[3] = BYTE3;
        temp[2] = BYTE2;
        temp[1] = BYTE1;
        temp[0] = BYTE0;
        f[0] = 0;
        int lo = ByteUtils.bytesToInt(temp, f);
        int rndbits = lo & 7;
        lo >>= 3;
        lo = lo & 0x1FFFFFFF | hi << 29;
        if (rndbits != 0) {
            lo |= 1;
        }
        hi >>= 3;
        hi &= 0xFFFFF;
        hi = hi | exponent << 20 | sign;
        f[0] = 0;
        ByteUtils.intToBytes(hi, temp, f);
        f[0] = 0;
        ByteUtils.intToBytes(lo, temp1, f);
        byte[] result = new byte[8];
        result[7] = temp1[3];
        result[6] = temp1[2];
        result[5] = temp1[1];
        result[4] = temp1[0];
        result[3] = temp[3];
        result[2] = temp[2];
        result[1] = temp[1];
        result[0] = temp[0];
        f[0] = 0;
        double value = ByteUtils.bytesToDouble(result, f);
        return value;
    }

    private double DGN2IEEEDouble(double dbl) {
        int tempInt = (int)Double.doubleToLongBits(dbl);
        int high = (tempInt & 0xFFFF) << 16;
        int low = (tempInt & 0xFFFF0000) >>> 16;
        int s = (tempInt = high | low) >> 31 == 0 ? 1 : -1;
        int e = tempInt >> 23 & 0xFF;
        int m = tempInt & 0x7FFFFF | 0x800000;
        return (double)(s * m * 2) * Math.pow(2.0, e - 128 - 25);
    }

    private double IEEE2DGNDouble(double dbl) {
        double64 dt = new double64();
        dt.hi = 0L;
        dt.lo = 0L;
        byte[] srclo = new byte[4];
        byte[] srchi = new byte[4];
        byte[] destlo = new byte[4];
        byte[] desthi = new byte[4];
        byte[] src = new byte[8];
        byte[] dest = new byte[8];
        for (int i = 0; i < 8; ++i) {
            src[i] = 48;
            dest[i] = 48;
        }
        int[] fin = new int[1];
        if (this.LSB == this.TRUE) {
            fin[0] = 0;
            ByteUtils.doubleToBytes(dbl, src, fin);
            dest[0] = src[4];
            dest[1] = src[5];
            dest[2] = src[6];
            dest[3] = src[7];
            dest[4] = src[0];
            dest[5] = src[1];
            dest[6] = src[2];
            dest[7] = src[3];
        }
        long sign = dt.hi & Integer.MIN_VALUE;
        long exponent = dt.hi >> 20;
        if ((exponent &= 0x7FFL) != (long)this.FALSE) {
            exponent = exponent - 1023L + 129L;
        }
        if (exponent > 255L) {
            fin[0] = 0;
            ByteUtils.doubleToBytes(dbl, dest, fin);
            dest[1] = sign != (long)this.FALSE ? 15 : 127;
            dest[0] = 15;
            dest[2] = 15;
            dest[3] = 15;
            dest[4] = 15;
            dest[5] = 15;
            dest[6] = 15;
            dest[7] = 15;
            return ByteUtils.bytesToDouble(dest, new int[0]);
        }
        if (exponent < 0L || exponent == 0L && sign == 0L) {
            fin[0] = 0;
            ByteUtils.doubleToBytes(dbl, dest, fin);
            dest[0] = 0;
            dest[1] = 0;
            dest[2] = 0;
            dest[3] = 0;
            dest[4] = 0;
            dest[5] = 0;
            dest[6] = 0;
            dest[7] = 0;
            return 0.0;
        }
        System.arraycopy(dest, 0, destlo, 0, 4);
        fin[0] = 0;
        dt.lo = ByteUtils.bytesToLong(destlo, fin);
        System.arraycopy(dest, 4, desthi, 0, 4);
        fin[0] = 0;
        dt.hi = ByteUtils.bytesToLong(desthi, fin);
        dt.hi <<= 3;
        dt.hi |= dt.lo >> 29;
        dt.hi &= 0x7FFFFFL;
        dt.hi = dt.hi | exponent << 23 | sign;
        dt.lo <<= 3;
        fin[0] = 0;
        ByteUtils.longToBytes(dt.lo, srclo, fin);
        fin[0] = 0;
        ByteUtils.longToBytes(dt.hi, srchi, fin);
        if (this.LSB == this.TRUE) {
            dest[2] = srclo[0];
            dest[3] = srclo[1];
            dest[0] = srclo[2];
            dest[1] = srclo[3];
            dest[6] = srchi[0];
            dest[7] = srchi[1];
            dest[4] = srchi[2];
            dest[5] = srchi[3];
        } else {
            dest[1] = srclo[0];
            dest[0] = srclo[1];
            dest[3] = srclo[2];
            dest[2] = srclo[3];
            dest[5] = srchi[0];
            dest[4] = srchi[1];
            dest[7] = srchi[2];
            dest[6] = srchi[3];
        }
        fin[0] = 0;
        dbl = ByteUtils.bytesToDouble(dest, fin);
        return dbl;
    }

    private int DGNElemTypeHasDispHdr(int nElemType) {
        switch (nElemType) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 32: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 63: {
                return this.FALSE;
            }
        }
        return this.TRUE;
    }

    private int DGNParseCore(DGNInfo info, DGNElemCore elemento) {
        int nAttIndex;
        int numBytes;
        byte[] psData = info.abyElem;
        elemento.level = psData[0] & 0x3F;
        elemento.complex = psData[0] & 0xFFFFFF80;
        elemento.deleted = psData[1] & 0xFFFFFF80;
        elemento.type = psData[1] & 0x7F;
        if (info.nElemBytes >= 36 && this.DGNElemTypeHasDispHdr(elemento.type) == this.TRUE) {
            elemento.graphic_group = psData[28] + psData[29] * 256;
            elemento.properties = psData[32] + psData[33] * 256;
            elemento.style = psData[34] & 7;
            elemento.weight = (psData[34] & 0xFFFFFFF8) >> 3;
            byte aux = psData[35];
            elemento.color = ByteUtils.getUnsigned(aux);
        } else {
            elemento.graphic_group = 0;
            elemento.properties = 0;
            elemento.style = 0;
            elemento.weight = 0;
            elemento.color = 0;
        }
        if ((elemento.properties & 0x800) != 0 && (numBytes = info.nElemBytes - (nAttIndex = ByteUtils.getUnsigned(psData[30]) + ByteUtils.getUnsigned(psData[31]) * 256) * 2 - 32) > 0) {
            elemento.attr_bytes = numBytes;
            elemento.attr_data = new byte[elemento.attr_bytes];
            System.arraycopy(psData, nAttIndex * 2 + 32, elemento.attr_data, 0, elemento.attr_bytes);
        }
        return this.TRUE;
    }

    private void DGNRad50ToAscii(int rad50, byte[] str) {
        int ch = 0;
        int i = 0;
        while (rad50 > 0) {
            int value = rad50;
            int cTimes = 0;
            while (value >= 40) {
                value /= 40;
                cTimes = (byte)(cTimes + 1);
            }
            byte[] abc = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
            byte[] num = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
            if (value == 0) {
                ch = 32;
            } else if (value >= 1 && value <= 26) {
                ch = abc[value - 1];
            } else if (value == 27) {
                ch = 36;
            } else if (value == 28) {
                ch = 46;
            } else if (value == 29) {
                ch = 32;
            } else if (value >= 30 && value <= 39) {
                try {
                    ch = num[value - 30];
                }
                catch (Exception ex) {
                    this.logwarn("Invalid char in rad50 conversion, asume blank (rad50=" + rad50 + ", value=" + value + ".", ex);
                    ch = 32;
                }
            }
            str[i] = ch;
            ++i;
            int temp = 1;
            while (true) {
                int n = cTimes;
                cTimes = (byte)(cTimes - 1);
                if (n <= 0) break;
                temp *= 40;
            }
            rad50 -= value * temp;
        }
        str[i] = 0;
    }

    private void DGNTransformPoint(DGNInfo info, DGNPoint psPoint) {
        psPoint.x = psPoint.x * info.scale - info.origin_x;
        psPoint.y = psPoint.y * info.scale - info.origin_y;
        psPoint.z = psPoint.z * info.scale - info.origin_z;
    }

    private DGNElemCore DGNParseColorTable(DGNInfo psDGN) {
        DGNElemColorTable psColorTable = new DGNElemColorTable(this);
        psColorTable.stype = 3;
        this.DGNParseCore(psDGN, psColorTable);
        psColorTable.screen_flag = ByteUtils.byteToUnsignedInt(psDGN.abyElem[36]) + ByteUtils.byteToUnsignedInt(psDGN.abyElem[37]) * 256;
        int[] fin = new int[]{0};
        byte[] temp = new byte[3];
        System.arraycopy(psDGN.abyElem, 38, temp, 0, 3);
        psColorTable.color_info[255] = temp;
        byte[] temp2 = new byte[765];
        System.arraycopy(psDGN.abyElem, 41, temp2, 0, 765);
        int k = 0;
        this.logdebug("Color table");
        this.logdebug("==============");
        for (int i = 0; i < 255; ++i) {
            for (int j = 0; j < 3; ++j) {
                psColorTable.color_info[i][j] = temp2[k];
                ++k;
            }
            this.logdebug("Color[" + i + "] {" + psColorTable.color_info[i][0] + ", " + psColorTable.color_info[i][1] + ", " + psColorTable.color_info[i][2] + "}");
        }
        if (psDGN.got_color_table == this.FALSE) {
            psDGN.color_table = psColorTable.color_info;
            psDGN.got_color_table = 1;
        }
        return psColorTable;
    }

    private DGNElemCore DGNParseTCB(DGNInfo psDGN) {
        DGNElemTCB psTCB = new DGNElemTCB(this);
        int[] fin = new int[1];
        psTCB.stype = 4;
        this.DGNParseCore(psDGN, psTCB);
        psTCB.dimension = (psDGN.abyElem[1214] & 0x40) != this.FALSE ? 3 : 2;
        fin[0] = 0;
        byte[] temp1 = new byte[8];
        System.arraycopy(psDGN.abyElem, 1112, temp1, 0, 4);
        psTCB.subunits_per_master = this.DGN_INT32(temp1);
        psTCB.master_units[0] = (char)psDGN.abyElem[1120];
        psTCB.master_units[1] = (char)psDGN.abyElem[1121];
        psTCB.master_units[2] = '\u0000';
        System.arraycopy(psDGN.abyElem, 1116, temp1, 0, 4);
        psTCB.uor_per_subunit = this.DGN_INT32(temp1);
        psTCB.sub_units[0] = (char)psDGN.abyElem[1122];
        psTCB.sub_units[1] = (char)psDGN.abyElem[1123];
        psTCB.sub_units[2] = '\u0000';
        System.arraycopy(psDGN.abyElem, 1240, temp1, 0, 8);
        ByteBuffer buffer = ByteBuffer.wrap(psDGN.abyElem);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        psTCB.origin_x = buffer.getDouble(1240);
        psTCB.origin_y = buffer.getDouble(1248);
        psTCB.origin_z = buffer.getDouble(1256);
        psTCB.origin_x = this.DGN2IEEEDouble(psTCB.origin_x);
        psTCB.origin_y = this.DGN2IEEEDouble(psTCB.origin_y);
        psTCB.origin_z = this.DGN2IEEEDouble(psTCB.origin_z);
        if (psTCB.uor_per_subunit != 0.0 && psTCB.subunits_per_master != 0.0) {
            psTCB.origin_x /= psTCB.uor_per_subunit * psTCB.subunits_per_master;
            psTCB.origin_y /= psTCB.uor_per_subunit * psTCB.subunits_per_master;
            psTCB.origin_z /= psTCB.uor_per_subunit * psTCB.subunits_per_master;
        }
        if (psDGN.got_tcb == this.FALSE) {
            psDGN.got_tcb = this.TRUE;
            psDGN.origin_x = psTCB.origin_x;
            psDGN.origin_y = psTCB.origin_y;
            psDGN.origin_z = psTCB.origin_z;
            if (psTCB.uor_per_subunit != 0.0 && psTCB.subunits_per_master != 0.0) {
                psDGN.scale = 1.0 / (psTCB.uor_per_subunit * psTCB.subunits_per_master);
            }
        }
        this.logdebug("Datos del TCB: " + psTCB.origin_x + " " + psTCB.origin_y);
        this.logdebug("psTCB.uor_per_subunit: " + psTCB.uor_per_subunit);
        this.logdebug("psTCB.subunits_per_master: " + psTCB.subunits_per_master);
        this.logdebug("psTCB.origen = " + psTCB.origin_x + " " + psTCB.origin_y);
        this.logdebug("psDGN.scale = " + psDGN.scale);
        this.logdebug("psDGN.origen = " + psDGN.origin_x + " " + psDGN.origin_y);
        this.logdebug("psDGN.dimension = " + psDGN.dimension);
        for (int iView = 0; iView < 8; ++iView) {
            byte[] pabyRawView = new byte[psDGN.abyElem.length];
            fin[0] = 0;
            System.arraycopy(psDGN.abyElem, 46 + iView * 118, pabyRawView, 0, psDGN.abyElem.length - (46 + iView * 118));
            psTCB.views[iView] = new DGNViewInfo();
            psTCB.views[iView].flags = ByteUtils.byteToUnsignedInt(pabyRawView[0]) + ByteUtils.byteToUnsignedInt(pabyRawView[1]) * 256;
            byte[] temp2 = new byte[4];
            int f = 0;
            for (int j = 0; j < 8; ++j) {
                System.arraycopy(pabyRawView, j + 2, temp2, 0, 1);
                fin[0] = 0;
                psTCB.views[iView].levels[f] = temp2[0];
                ++f;
            }
            psTCB.views[iView].origin = new DGNPoint();
            System.arraycopy(pabyRawView, 10, temp1, 0, 4);
            psTCB.views[iView].origin.x = this.DGN_INT32(temp1);
            System.arraycopy(pabyRawView, 14, temp1, 0, 4);
            psTCB.views[iView].origin.y = this.DGN_INT32(temp1);
            System.arraycopy(pabyRawView, 18, temp1, 0, 4);
            psTCB.views[iView].origin.z = this.DGN_INT32(temp1);
            this.DGNTransformPoint(psDGN, psTCB.views[iView].origin);
            psTCB.views[iView].delta = new DGNPoint();
            System.arraycopy(pabyRawView, 22, temp1, 0, 4);
            psTCB.views[iView].delta.x = this.DGN_INT32(temp1);
            System.arraycopy(pabyRawView, 26, temp1, 0, 4);
            psTCB.views[iView].delta.y = this.DGN_INT32(temp1);
            System.arraycopy(pabyRawView, 30, temp1, 0, 4);
            psTCB.views[iView].delta.z = this.DGN_INT32(temp1);
            psTCB.views[iView].delta.x *= psDGN.scale;
            psTCB.views[iView].delta.y *= psDGN.scale;
            psTCB.views[iView].delta.z *= psDGN.scale;
            psTCB.views[iView].transmatrx = new double[9];
            for (int k = 0; k < 9; ++k) {
                System.arraycopy(pabyRawView, 34 + 8 * k, temp1, 0, 8);
                fin[0] = 0;
                psTCB.views[iView].transmatrx[k] = this.DGNParseIEEE(temp1);
            }
            System.arraycopy(pabyRawView, 106, temp1, 0, 8);
            fin[0] = 0;
            psTCB.views[iView].conversion = ByteUtils.bytesToLong(temp1, fin);
            fin[0] = 0;
            psTCB.views[iView].conversion = ByteUtils.bytesToDouble(temp1, fin);
            this.DGNParseIEEE(psTCB.views[iView].conversion);
            System.arraycopy(pabyRawView, 114, temp1, 0, 8);
            psTCB.views[iView].activez = this.DGN_INT32(temp1);
        }
        return psTCB;
    }

    private int CPL_LSBWORD32(int x) {
        return (x & 0xFF) << 24 | (x & 0xFF00) << 8 | (x & 0xFF0000) >> 8 | (x & 0xFF000000) >> 24;
    }

    private DGNElemCore DGNParseTagSet(DGNInfo psDGN) {
        DGNElemTagSet psTagSet = new DGNElemTagSet(this);
        psTagSet.stype = 10;
        this.DGNParseCore(psDGN, psTagSet);
        psTagSet.tagCount = ByteUtils.byteToUnsignedInt(psDGN.abyElem[44]) + ByteUtils.byteToUnsignedInt(psDGN.abyElem[45]) * 256;
        psTagSet.flags = ByteUtils.byteToUnsignedInt(psDGN.abyElem[46]) + ByteUtils.byteToUnsignedInt(psDGN.abyElem[47]) * 256;
        int[] fin = new int[]{0};
        byte[] temp = new byte[this.elemento.attr_bytes];
        System.arraycopy(psDGN.abyElem, 48, temp, 0, psDGN.abyElem.length - 48);
        psTagSet.tagSetName = ByteUtils.bytesToString(temp, fin).toCharArray();
        psTagSet.tagSet = -1;
        if (psTagSet.attr_bytes >= 8 && psTagSet.attr_data[0] == 3 && psTagSet.attr_data[1] == 16 && psTagSet.attr_data[2] == 47 && psTagSet.attr_data[3] == 125) {
            psTagSet.tagSet = psTagSet.attr_data[4] + psTagSet.attr_data[5] * 256;
        }
        int nDataOffset = 48 + psTagSet.tagSetName.length + 1 + 1;
        for (int iTag = 0; iTag < psTagSet.tagCount; ++iTag) {
            DGNTagDef tagDef = new DGNTagDef();
            tagDef.id = iTag;
            System.arraycopy(psDGN.abyElem, nDataOffset, temp, 0, psDGN.abyElem.length);
            fin[0] = 0;
            tagDef.name = ByteUtils.bytesToString(temp, fin).toCharArray();
            tagDef.id = ByteUtils.byteToUnsignedInt(psDGN.abyElem[nDataOffset += tagDef.name.length + 1]) + ByteUtils.byteToUnsignedInt(psDGN.abyElem[nDataOffset + 1]) * 256;
            System.arraycopy(psDGN.abyElem, nDataOffset += 2, temp, 0, psDGN.abyElem.length);
            fin[0] = 0;
            tagDef.prompt = ByteUtils.bytesToString(temp, fin).toCharArray();
            tagDef.type = ByteUtils.byteToUnsignedInt(psDGN.abyElem[nDataOffset += tagDef.prompt.length + 1]) + ByteUtils.byteToUnsignedInt(psDGN.abyElem[nDataOffset + 1]) * 256;
            nDataOffset += 2;
            nDataOffset += 5;
            if (tagDef.type == 1) {
                System.arraycopy(psDGN.abyElem, nDataOffset, temp, 0, psDGN.abyElem.length);
                fin[0] = 0;
                tagDef.defaultValue.string = ByteUtils.bytesToString(temp, fin).toCharArray();
                nDataOffset += tagDef.defaultValue.string.length + 1;
                continue;
            }
            if (tagDef.type == 3 || tagDef.type == 5) {
                System.arraycopy(psDGN.abyElem, nDataOffset, temp, 0, 4);
                fin[0] = 0;
                tagDef.defaultValue.integer = ByteUtils.bytesToLong(temp, fin);
                tagDef.defaultValue.integer = this.CPL_LSBWORD32((int)tagDef.defaultValue.integer);
                nDataOffset += 4;
                continue;
            }
            if (tagDef.type == 4) {
                System.arraycopy(psDGN.abyElem, nDataOffset, temp, 0, 8);
                fin[0] = 0;
                tagDef.defaultValue.real = ByteUtils.bytesToDouble(temp, fin);
                this.DGNParseIEEE(tagDef.defaultValue.real);
                nDataOffset += 8;
                continue;
            }
            nDataOffset += 4;
        }
        return psTagSet;
    }

    private void DGNSetOptions(DGNInfo psDGN, int nOptions) {
        psDGN.options = nOptions;
    }

    private void DGNSetSpatialFilter(DGNInfo psDGN, double dfXMin, double dfYMin, double dfXMax, double dfYMax) {
        if (dfXMin == 0.0 && dfXMax == 0.0 && dfYMin == 0.0 && dfYMax == 0.0) {
            psDGN.has_spatial_filter = this.FALSE;
            return;
        }
        psDGN.has_spatial_filter = this.TRUE;
        psDGN.sf_converted_to_uor = this.FALSE;
        psDGN.sf_min_x_geo = dfXMin;
        psDGN.sf_min_y_geo = dfYMin;
        psDGN.sf_max_x_geo = dfXMax;
        psDGN.sf_max_y_geo = dfYMax;
        this.DGNSpatialFilterToUOR(psDGN);
    }

    private String DGNDumpPoint(DGNPoint point) {
        StringBuffer out = new StringBuffer();
        out.append("(");
        out.append(point.x).append(",");
        out.append(point.y).append(",");
        out.append(point.z).append(")");
        return out.toString();
    }

    private String DGNDumpColor(byte[] color) {
        StringBuffer out = new StringBuffer();
        out.append("(");
        out.append(color[0]).append(",");
        out.append(color[1]).append(",");
        out.append(color[2]).append(")");
        return out.toString();
    }

    public String DGNDumpElement(DGNInfo psInfo, DGNElemCore psElement) {
        XMLTag elememtTag = new XMLTag("element", 1);
        elememtTag.addAttribute("type", psElement.type);
        elememtTag.addAttribute("typename", this.DGNTypeToName(psElement.type));
        elememtTag.addAttribute("stype", psElement.stype);
        elememtTag.addTag("dimension", psInfo.dimension);
        elememtTag.addTag("level", psElement.level);
        elememtTag.addTag("id", psElement.element_id);
        elememtTag.addTag("complex", psElement.complex);
        elememtTag.addTag("deleted", psElement.deleted);
        elememtTag.addTag("offset", psElement.offset);
        elememtTag.addTag("size", psElement.size);
        elememtTag.addTag("graphic_group", psElement.graphic_group);
        elememtTag.addTag("color", psElement.color);
        elememtTag.addTag("weight", psElement.weight);
        elememtTag.addTag("style", psElement.style);
        XMLTag propertiesTag = elememtTag.addTag("properties");
        propertiesTag.addAttribute("value", this.numberFormat("0x%08x", psElement.properties));
        if (psElement.properties != 0) {
            int nClass;
            if ((psElement.properties & 0x8000) != 0) {
                propertiesTag.addValue(" HOLE");
            }
            if ((psElement.properties & 0x4000) != 0) {
                propertiesTag.addValue(" SNAPPABLE");
            }
            if ((psElement.properties & 0x2000) != 0) {
                propertiesTag.addValue(" PLANAR");
            }
            if ((psElement.properties & 0x1000) != 0) {
                propertiesTag.addValue(" ORIENTATION");
            }
            if ((psElement.properties & 0x800) != 0) {
                propertiesTag.addValue(" ATTRIBUTES");
            }
            if ((psElement.properties & 0x400) != 0) {
                propertiesTag.addValue(" MODIFIED");
            }
            if ((psElement.properties & 0x200) != 0) {
                propertiesTag.addValue(" NEW");
            }
            if ((psElement.properties & 0x100) != 0) {
                propertiesTag.addValue(" LOCKED");
            }
            if ((nClass = psElement.properties & 0xF) == 1) {
                propertiesTag.addValue(" PATTERN_COMPONENT");
            } else if (nClass == 2) {
                propertiesTag.addValue(" CONSTRUCTION_ELEMENT");
            } else if (nClass == 3) {
                propertiesTag.addValue(" DIMENSION_ELEMENT");
            } else if (nClass == 4) {
                propertiesTag.addValue(" PRIMARY_RULE_ELEMENT");
            } else if (nClass == 5) {
                propertiesTag.addValue(" LINEAR_PATTERNED_ELEMENT");
            } else if (nClass == 6) {
                propertiesTag.addValue(" CONSTRUCTION_RULE_ELEMENT");
            }
        }
        switch (psElement.stype) {
            case 2: {
                DGNElemMultiPoint psLine = (DGNElemMultiPoint)psElement;
                XMLTag multipointTag = elememtTag.addTag("multipoint");
                for (int i = 0; i < psLine.num_vertices; ++i) {
                    multipointTag.addTag("point", psLine.vertices[i]);
                }
                break;
            }
            case 8: {
                DGNElemCellHeader psCellHeader = (DGNElemCellHeader)psElement;
                XMLTag headerTag = elememtTag.addTag("header");
                headerTag.addTag("totlength", psCellHeader.totlength);
                headerTag.addTag("name", psCellHeader.name.toString());
                headerTag.addTag("cclass", psCellHeader.cclass);
                headerTag.addTag("levels", psCellHeader.levels);
                headerTag.addTag("rnglow", psCellHeader.rnglow);
                headerTag.addTag("rnghigh", psCellHeader.rnghigh);
                headerTag.addTag("origin", psCellHeader.origin);
                headerTag.addTag("xscale", psCellHeader.xscale);
                headerTag.addTag("yscale", psCellHeader.yscale);
                headerTag.addTag("rotation", psCellHeader.rotation);
                break;
            }
            case 11: {
                DGNElemCellLibrary psCellLib = (DGNElemCellLibrary)psElement;
                XMLTag libraryTag = elememtTag.addTag("library");
                libraryTag.addTag("name", psCellLib.name);
                libraryTag.addTag("cclass", psCellLib.cclass);
                libraryTag.addTag("levels", psCellLib.levels);
                libraryTag.addTag("numwords", psCellLib.numwords);
                libraryTag.addTag("dispsymb", psCellLib.dispsymb);
                libraryTag.addTag("description", psCellLib.description);
                break;
            }
            case 5: {
                DGNElemArc psArc = (DGNElemArc)psElement;
                XMLTag arcTag = elememtTag.addTag("arc");
                if (psInfo.dimension == 2) {
                    arcTag.addTag("origin", psArc.origin);
                    arcTag.addTag("rotation", psArc.rotation);
                    arcTag.addTag("quat").addRemark("not supported when dimension is 2");
                } else {
                    arcTag.addTag("origin", psArc.origin);
                    arcTag.addTag("rotation").addRemark("not supported when dimension not is 2");
                    arcTag.addTag("quat", psArc.quat);
                }
                arcTag.addTag("primary_axis", psArc.primary_axis);
                arcTag.addTag("secondary_axis", psArc.secondary_axis);
                arcTag.addTag("startang", psArc.startang);
                arcTag.addTag("sweepang", psArc.sweepang);
                break;
            }
            case 6: {
                DGNElemText psText = (DGNElemText)psElement;
                XMLTag textTag = elememtTag.addTag("text");
                textTag.addTag("origin", psText.origin);
                textTag.addTag("rotation", psText.rotation);
                textTag.addTag("font_id", psText.font_id);
                textTag.addTag("justification", psText.justification);
                textTag.addTag("length_mult", psText.length_mult);
                textTag.addTag("height_mult", psText.height_mult);
                textTag.addTag("height_raw", psText.height_raw);
                textTag.addTag("string", psText.string);
                break;
            }
            case 7: {
                DGNElemComplexHeader psHdr = (DGNElemComplexHeader)psElement;
                XMLTag complexHeaderTag = elememtTag.addTag("complexheader");
                complexHeaderTag.addTag("totlength", psHdr.totlength);
                complexHeaderTag.addTag("numelems", psHdr.numelems);
                break;
            }
            case 3: {
                DGNElemColorTable psCT = (DGNElemColorTable)psElement;
                XMLTag colortableTag = elememtTag.addTag("colortable");
                colortableTag.addAttribute("screen_flag", psCT.screen_flag);
                for (int i = 0; i < 256; ++i) {
                    colortableTag.addTag("color").addAttribute("index", i).addAttribute("r", psCT.color_info[i][0]).addAttribute("g", psCT.color_info[i][1]).addAttribute("b", psCT.color_info[i][2]);
                }
                break;
            }
            case 4: {
                DGNElemTCB psTCB = (DGNElemTCB)psElement;
                XMLTag tcbTag = elememtTag.addTag("TCB");
                tcbTag.addTag("dimension", psTCB.dimension);
                tcbTag.addTag("uor_per_subunit", psTCB.uor_per_subunit);
                tcbTag.addTag("subunits_per_master", psTCB.subunits_per_master);
                tcbTag.addPointTag("origin", psTCB.origin_x, psTCB.origin_y, psTCB.origin_z);
                for (int iView = 0; iView < 8; ++iView) {
                    DGNViewInfo psView = psTCB.views[iView];
                    XMLTag viewTag = tcbTag.addTag("view");
                    viewTag.addAttribute("index", iView);
                    viewTag.addTag("flags", this.numberFormat("0x%08x", psView.flags));
                    viewTag.addTag("levels", psView.levels);
                    viewTag.addTag("origin", psView.origin);
                    viewTag.addTag("transmatrx", psView.transmatrx);
                    viewTag.addTag("levels", psView.levels);
                }
                break;
            }
            case 10: {
                DGNElemTagSet psTagSet = (DGNElemTagSet)psElement;
                XMLTag setTag = elememtTag.addTag("tagset");
                setTag.addTag("tagSetName", psTagSet.tagSetName);
                setTag.addTag("tagSet", psTagSet.tagSet);
                setTag.addTag("flags", "0x" + Integer.toHexString(psTagSet.flags));
                setTag.addTag("tagCount", psTagSet.tagCount);
                for (int iTag = 0; iTag < psTagSet.tagCount; ++iTag) {
                    DGNTagDef psTagDef = psTagSet.tagList[iTag];
                    XMLTag tagTag = setTag.addTag("tag");
                    tagTag.addAttribute("index", iTag);
                    tagTag.addTag("name", psTagDef.name);
                    tagTag.addTag("type", psTagDef.type);
                    tagTag.addTag("prompt", psTagDef.prompt);
                    tagTag.addTag("default_string", psTagDef.defaultValue.string);
                    tagTag.addTag("default_integer", psTagDef.defaultValue.integer);
                    tagTag.addTag("default_real", psTagDef.defaultValue.real);
                }
                break;
            }
            case 9: {
                DGNElemTagValue psTag = (DGNElemTagValue)psElement;
                XMLTag tagvalueTag = elememtTag.addTag("tagvalue");
                tagvalueTag.addTag("tagType", psTag.tagType);
                tagvalueTag.addTag("tagSet", psTag.tagSet);
                tagvalueTag.addTag("tagIndex", psTag.tagIndex);
                tagvalueTag.addTag("tagLength", psTag.tagLength);
                tagvalueTag.addTag("value_string", psTag.tagValue.string);
                tagvalueTag.addTag("value_integer", psTag.tagValue.integer);
                tagvalueTag.addTag("value_real", psTag.tagValue.real);
                break;
            }
            case 12: {
                break;
            }
        }
        if (psElement.attr_bytes > 0) {
            DGNLink dgnlink;
            elememtTag.addTag("attr_bytes", psElement.attr_bytes);
            Iterator it = this.linksiterator(psElement);
            while (it.hasNext() && (dgnlink = (DGNLink)it.next()) != null) {
                XMLTag linkTag = elememtTag.addTag("link");
                linkTag.addAttribute("index", dgnlink.index);
                linkTag.addAttribute("entitynum", dgnlink.entityNum);
                linkTag.addAttribute("mslink", dgnlink.msLink);
                linkTag.setValue(this.dumpBuffer(dgnlink.data));
                linkTag.setUseCDATA(true);
            }
        }
        return elememtTag.toString();
    }

    public DGNLink DGNGetLinkage(DGNElemCore psElement, Integer index, Integer type, Integer entityCode, Integer mslink, Pattern data) {
        Iterator it = this.linksiterator(psElement);
        while (it.hasNext()) {
            DGNLink link = (DGNLink)it.next();
            if (index != null && index.intValue() != link.getIndex() || type != null && type.intValue() != link.getType() || entityCode != null && entityCode.intValue() != link.getEntityCode() || mslink != null && mslink.intValue() != link.getMSLink() || data != null && !data.matcher(link.getDataAsHexadecimal()).matches()) continue;
            return link;
        }
        return null;
    }

    public Iterator linksiterator(DGNElemCore psElement) {
        return new LinksIterator(psElement);
    }

    public int DGNGetLinkageCount(DGNElemCore psElement) {
        int count = 0;
        Iterator it = this.linksiterator(psElement);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    private DGNLink DGNGetLinkage(DGNInfo psDGN, DGNElemCore psElement, int iIndex) {
        int iLinkage = 0;
        try {
            int nLinkSize;
            iLinkage = 0;
            int nAttrOffset = 0;
            while ((nLinkSize = this.DGNGetAttrLinkSize(psDGN, psElement, nAttrOffset)) != 0) {
                if (iLinkage == iIndex) {
                    int nLinkageType = 0;
                    int nEntityNum = 0;
                    int nMSLink = 0;
                    if (psElement.attr_data[nAttrOffset + 0] == 0 && (psElement.attr_data[nAttrOffset + 1] == 0 || psElement.attr_data[nAttrOffset + 1] == -128)) {
                        nLinkageType = 0;
                        nEntityNum = psElement.attr_data[nAttrOffset + 2] + psElement.attr_data[nAttrOffset + 3] * 256;
                        nMSLink = psElement.attr_data[nAttrOffset + 4] + psElement.attr_data[nAttrOffset + 5] * 256 + psElement.attr_data[nAttrOffset + 6] * 65536;
                    } else {
                        nLinkageType = psElement.attr_data[nAttrOffset + 2] + psElement.attr_data[nAttrOffset + 3] * 256;
                    }
                    if (nLinkSize == 16 && nLinkageType != 65) {
                        nEntityNum = psElement.attr_data[nAttrOffset + 6] + psElement.attr_data[nAttrOffset + 7] * 256;
                        nMSLink = psElement.attr_data[nAttrOffset + 8] + psElement.attr_data[nAttrOffset + 9] * 256 + psElement.attr_data[nAttrOffset + 10] * 65536 + psElement.attr_data[nAttrOffset + 11] * 65536 * 256;
                    }
                    DGNLink dgnlink = new DGNLink();
                    dgnlink.type = nLinkageType;
                    dgnlink.entityNum = nEntityNum;
                    dgnlink.msLink = nMSLink;
                    dgnlink.length = nLinkSize;
                    byte[] temp = new byte[psElement.attr_data.length - nAttrOffset];
                    System.arraycopy(psElement.attr_data, nAttrOffset, temp, 0, psElement.attr_data.length - nAttrOffset);
                    dgnlink.type = nLinkageType;
                    dgnlink.entityNum = nEntityNum;
                    dgnlink.msLink = nMSLink;
                    dgnlink.length = nLinkSize;
                    dgnlink.data = temp;
                    return dgnlink;
                }
                ++iLinkage;
                nAttrOffset += nLinkSize;
            }
        }
        catch (Exception ex) {
            this.logwarn("Can't get an external database linkage (iLinkage=" + iLinkage + ").", ex);
        }
        return null;
    }

    private int DGNGetAttrLinkSize(DGNInfo psDGN, DGNElemCore psElement, int nOffset) {
        if (psElement.attr_bytes < nOffset + 4) {
            return 0;
        }
        if (psElement.attr_data[nOffset + 0] == 0 && psElement.attr_data[nOffset + 1] == 0 || psElement.attr_data[nOffset + 0] == 0 && psElement.attr_data[nOffset + 1] == -128) {
            return 8;
        }
        if ((psElement.attr_data[nOffset + 1] & 0x10) != this.FALSE) {
            return psElement.attr_data[nOffset + 0] * 2 + 2;
        }
        return 0;
    }

    String DGNTypeToName(int nType) {
        switch (nType) {
            case 1: {
                return "Cell Library";
            }
            case 2: {
                return "Cell Header";
            }
            case 3: {
                return "Line";
            }
            case 4: {
                return "Line String";
            }
            case 5: {
                return "Group Data";
            }
            case 6: {
                return "Shape";
            }
            case 7: {
                return "Text Node";
            }
            case 8: {
                return "Digitizer Setup";
            }
            case 9: {
                return "TCB";
            }
            case 10: {
                return "Level Symbology";
            }
            case 11: {
                return "Curve";
            }
            case 12: {
                return "Complex Chain Header";
            }
            case 14: {
                return "Complex Shape Header";
            }
            case 15: {
                return "Ellipse";
            }
            case 16: {
                return "Arc";
            }
            case 17: {
                return "Text";
            }
            case 21: {
                return "B-Spline";
            }
            case 66: {
                return "Application Element";
            }
            case 34: {
                return "Shared Cell Definition";
            }
            case 35: {
                return "Shared Cell Element";
            }
            case 37: {
                return "Tag Value";
            }
        }
        this.logwarn("Can't get element type name for value '" + nType + "'.", null);
        return "Unknown";
    }

    private void DGNDumpRawElement(DGNInfo psDGN, DGNElemCore psCore, String fpOut) {
        int iChar = 0;
        byte[] szLine = new byte[80];
        for (int i = 0; i < psCore.raw_bytes; ++i) {
            byte[] temp;
            int[] f;
            byte[] szHex = new byte[3];
            if (i % 16 == 0) {
                f = new int[1];
                temp = new byte[4];
                f[0] = 0;
                ByteUtils.intToBytes(i, temp, f);
                System.arraycopy(temp, 0, szLine, 0, 4);
                iChar = 0;
            }
            szHex[0] = psCore.raw_data[i];
            szHex[1] = 0;
            System.arraycopy(szHex, 0, szLine, 8 + iChar * 2, 2);
            szLine[42 + iChar] = psCore.raw_data[i] < 32 || psCore.raw_data[i] > 127 ? 46 : psCore.raw_data[i];
            if (i == psCore.raw_bytes - 1 || (i + 1) % 16 == 0) {
                f = new int[]{0};
                temp = new byte[1];
                byte[] temp1 = new byte[16];
                int k = 0;
                for (int j = 1; j < 32; j += 2) {
                    System.arraycopy(szLine, j + 7, temp, 0, 1);
                    temp1[k] = temp[0];
                    ++k;
                }
                f[0] = 42;
                char[] tempchar = new char[16];
                for (int j = 0; j < 16; ++j) {
                    tempchar[j] = (char)szLine[42 + j];
                }
            }
            ++iChar;
        }
    }

    private int DGNGetExtents(DGNInfo psDGN, double[] padfExtents) {
        DGNPoint sMin = new DGNPoint();
        DGNPoint sMax = new DGNPoint();
        this.DGNBuildIndex(psDGN);
        if (psDGN.got_bounds == this.FALSE) {
            return this.FALSE;
        }
        double minX = psDGN.min_x;
        double minY = psDGN.min_y;
        double minZ = psDGN.min_z;
        this.logdebug("psDGN.min: x= " + minX + ", y= " + minY + ", z= " + minZ);
        if (minX < 0.0) {
            minX += 4.294967296E9;
        }
        if (minY < 0.0) {
            minY += 4.294967296E9;
        }
        if (minZ < 0.0) {
            minZ += 4.294967296E9;
        }
        this.logdebug("psDGN.min fixed: x= " + minX + ", y= " + minY + ", z= " + minZ);
        sMin.x = minX - 2.147483648E9;
        sMin.y = minY - 2.147483648E9;
        sMin.z = minZ - 2.147483648E9;
        this.DGNTransformPoint(psDGN, sMin);
        padfExtents[0] = sMin.x;
        padfExtents[1] = sMin.y;
        padfExtents[2] = sMin.z;
        double maxX = psDGN.max_x;
        double maxY = psDGN.max_y;
        double maxZ = psDGN.max_z;
        this.logdebug("psDGN.max: x= " + maxX + ", y= " + maxY + ", z= " + maxZ);
        if (maxX < 0.0) {
            maxX += 4.294967296E9;
        }
        if (maxY < 0.0) {
            maxY += 4.294967296E9;
        }
        if (maxZ < 0.0) {
            maxZ += 4.294967296E9;
        }
        this.logdebug("psDGN.max fixed: x= " + maxX + ", y= " + maxY + ", z= " + maxZ);
        sMax.x = maxX - 2.147483648E9;
        sMax.y = maxY - 2.147483648E9;
        sMax.z = maxZ - 2.147483648E9;
        this.DGNTransformPoint(psDGN, sMax);
        padfExtents[3] = sMax.x;
        padfExtents[4] = sMax.y;
        padfExtents[5] = sMax.z;
        return this.TRUE;
    }

    private void DGNBuildIndex(DGNInfo psDGN) {
        DGNElemCore elemento = new DGNElemCore(this);
        if (psDGN.index_built != this.FALSE) {
            return;
        }
        psDGN.index_built = this.TRUE;
        int nMaxElements = 0;
        long nLastOffset = this.bb.position();
        while (this.DGNLoadRawElement(psDGN, elemento) != this.FALSE) {
            if (psDGN.element_count == nMaxElements) {
                int oldMax = nMaxElements;
                nMaxElements = (int)((double)nMaxElements * 1.5) + 500;
                DGNElementInfo[] nuevo = new DGNElementInfo[nMaxElements];
                for (int i = 0; i < oldMax; ++i) {
                    nuevo[i] = psDGN.element_index[i];
                }
                psDGN.element_index = nuevo;
            }
            psDGN.element_index[psDGN.element_count] = new DGNElementInfo();
            DGNElementInfo psEI = psDGN.element_index[psDGN.element_count];
            psEI.level = elemento.level;
            psEI.type = elemento.type;
            psEI.flags = 0;
            psEI.offset = nLastOffset;
            if (psDGN.abyElem[0] * -128 == -128) {
                psEI.flags |= 2;
            }
            if (psDGN.abyElem[1] * -128 == -128) {
                psEI.flags |= 1;
            }
            if (elemento.type == 3 || elemento.type == 4 || elemento.type == 6 || elemento.type == 11 || elemento.type == 21) {
                psEI.stype = 2;
            } else if (elemento.type == 5 && elemento.level == 1) {
                DGNElemCore psCT = this.DGNParseColorTable(psDGN);
                this.logdebug("TABLA DE COLORES!!");
                psEI.stype = 3;
                this.m_colorTable = (DGNElemColorTable)psCT;
            } else if (elemento.type == 15 || elemento.type == 16) {
                psEI.stype = 5;
            } else if (elemento.type == 14 || elemento.type == 12) {
                psEI.stype = 7;
            } else if (elemento.type == 17) {
                psEI.stype = 6;
            } else if (elemento.type == 37) {
                psEI.stype = 9;
            } else if (elemento.type == 66) {
                psEI.stype = elemento.level == 24 ? 10 : 1;
            } else if (elemento.type == 9) {
                DGNElemCore psTCB = this.DGNParseTCB(psDGN);
                psEI.stype = 4;
            } else {
                psEI.stype = 1;
            }
            double[] anRegion = this.DGNGetRawExtents(psDGN, null, elemento);
            if ((psEI.flags & 1) == this.FALSE & (psEI.flags & 2) == this.FALSE & anRegion != null) {
                if (psDGN.got_bounds != this.FALSE) {
                    psDGN.min_x = Math.min(psDGN.min_x, anRegion[0]);
                    psDGN.min_y = Math.min(psDGN.min_y, anRegion[1]);
                    psDGN.min_z = Math.min(psDGN.min_z, anRegion[2]);
                    psDGN.max_x = Math.max(psDGN.max_x, anRegion[3]);
                    psDGN.max_y = Math.max(psDGN.max_y, anRegion[4]);
                    psDGN.max_z = Math.max(psDGN.max_z, anRegion[5]);
                } else {
                    psDGN.min_x = anRegion[0];
                    psDGN.min_y = anRegion[1];
                    psDGN.min_z = anRegion[2];
                    psDGN.max_x = anRegion[3];
                    psDGN.max_y = anRegion[4];
                    psDGN.max_z = anRegion[5];
                    psDGN.got_bounds = this.TRUE;
                }
            }
            ++psDGN.element_count;
            nLastOffset = this.bb.position();
        }
        psDGN.max_element_count = nMaxElements;
    }

    private int DGNGetElementExtents(DGNInfo psDGN, DGNElemCore psElement, DGNPoint psMin, DGNPoint psMax) {
        double[] bResult;
        long[] anMin = new long[3];
        long[] anMax = new long[3];
        DGNInfo tempo = new DGNInfo();
        if (psElement.raw_data != null) {
            bResult = this.DGNGetRawExtents(psDGN, psElement.raw_data, psElement);
        } else if (psElement.element_id == psDGN.next_element_id - 1) {
            bResult = this.DGNGetRawExtents(psDGN, psDGN.abyElem, psElement);
        } else {
            return this.FALSE;
        }
        if (bResult == null) {
            return this.FALSE;
        }
        psMin.x = tempo.min_x - 2.147483648E9;
        psMin.y = tempo.min_y - 2.147483648E9;
        psMin.z = tempo.min_z - 2.147483648E9;
        psMax.x = tempo.max_x - 2.147483648E9;
        psMax.y = tempo.max_y - 2.147483648E9;
        psMax.z = tempo.max_z - 2.147483648E9;
        this.DGNTransformPoint(psDGN, psMin);
        this.DGNTransformPoint(psDGN, psMax);
        return this.TRUE;
    }

    private DGNElementInfo[] DGNGetElementIndex(DGNInfo psDGN, int[] pnElementCount) {
        this.DGNBuildIndex(psDGN);
        if (pnElementCount[0] != -1) {
            pnElementCount[0] = psDGN.element_count;
        }
        return psDGN.element_index;
    }

    public Color DGNLookupColor(int color_index) {
        int b;
        int g;
        int r;
        if (color_index < 0 || color_index > 255) {
            return null;
        }
        if (this.info.got_color_table == 0) {
            r = abyDefaultPCT[color_index][0];
            g = abyDefaultPCT[color_index][1];
            b = abyDefaultPCT[color_index][2];
        } else {
            r = ByteUtils.getUnsigned(this.m_colorTable.color_info[color_index][0]);
            g = ByteUtils.getUnsigned(this.m_colorTable.color_info[color_index][1]);
            b = ByteUtils.getUnsigned(this.m_colorTable.color_info[color_index][2]);
        }
        if (r == 255 && g == 255 && b == 255) {
            b = 0;
            g = 0;
            r = 0;
        }
        return new Color(r, g, b);
    }

    public int DGNGetShapeFillInfo(DGNElemCore psElem) {
        DGNLink dgnlink;
        int color_index = -1;
        int iLink = 0;
        while (true) {
            if ((dgnlink = this.DGNGetLinkage(this.info, psElem, iLink)) == null) {
                return -1;
            }
            if (dgnlink.type == 65 && dgnlink.length >= 7) break;
            ++iLink;
        }
        color_index = ByteUtils.getUnsigned(dgnlink.data[8]);
        return color_index;
    }

    int DGNGetAssocID(DGNElemCore psElem) {
        int iLink = 0;
        DGNLink dgnlink;
        while ((dgnlink = this.DGNGetLinkage(this.info, psElem, iLink)) != null) {
            if (dgnlink.type == 32047 && dgnlink.length >= 8) {
                byte[] pabyData = dgnlink.data;
                return ByteUtils.getUnsigned(pabyData[4]) + ByteUtils.getUnsigned(pabyData[5]) * 256 + ByteUtils.getUnsigned(pabyData[6]) * 256 * 256 + ByteUtils.getUnsigned(pabyData[7]) * 256 * 256 * 256;
            }
            ++iLink;
        }
        return -1;
    }

    private void logwarn(String msg, Throwable cause) {
        if (this.logErrors) {
            if (cause == null) {
                logger.warn(msg);
            } else {
                logger.warn(msg, cause);
            }
        }
    }

    private void loginfo(String msg, Throwable cause) {
        if (this.logErrors) {
            logger.info(msg);
        }
    }

    private void logdebug(String msg) {
        if (this.logErrors) {
            logger.debug(msg);
        }
    }

    private class LinksIterator
    implements Iterator {
        private DGNElemCore psElement;
        private int link;
        private DGNLink nextLink;

        LinksIterator(DGNElemCore psElement) {
            this.psElement = psElement;
            this.link = 0;
            this.nextLink = null;
        }

        @Override
        public boolean hasNext() {
            this.nextLink = DGNReader.this.DGNGetLinkage(DGNReader.this.getInfo(), this.psElement, this.link);
            return this.nextLink != null;
        }

        public Object next() {
            DGNLink x = this.nextLink;
            if (x != null) {
                ++this.link;
            }
            return x;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class XMLTag {
        private List<XMLTag> tags = null;
        private String name = null;
        private int indent;
        private String value = null;
        private Map<String, String> attributes = null;
        private boolean useCDATA;
        private String remarks = null;

        XMLTag(String name, int indent) {
            this.name = name;
            this.indent = indent;
        }

        public XMLTag addAttribute(String name, byte value) {
            this.addAttribute(name, Integer.toString(value & 0xFF));
            return this;
        }

        public XMLTag addAttribute(String name, int value) {
            this.addAttribute(name, Integer.toString(value));
            return this;
        }

        public XMLTag addAttribute(String name, double value) {
            this.addAttribute(name, Double.toString(value));
            return this;
        }

        public XMLTag addAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public XMLTag setValue(String value) {
            this.value = value;
            return this;
        }

        public XMLTag addValue(String value) {
            this.value = this.value == null ? value : this.value + value;
            return this;
        }

        public XMLTag addRemark(String remark) {
            this.remarks = this.remarks == null ? remark : this.remarks + remark;
            return this;
        }

        public XMLTag createTag(String name, int indent) {
            return new XMLTag(name, indent);
        }

        public XMLTag addTag(XMLTag tag) {
            if (this.tags == null) {
                this.tags = new ArrayList<XMLTag>();
            }
            this.tags.add(tag);
            return tag;
        }

        public XMLTag addPointTag(String name, double x, double y, double z) {
            XMLTag point = this.addTag(name);
            point.addAttribute("x", x);
            point.addAttribute("y", y);
            point.addAttribute("z", z);
            return point;
        }

        public XMLTag addTag(String name, DGNPoint point) {
            return this.addPointTag(name, point.x, point.y, point.z);
        }

        public XMLTag addTag(String name, int[] values) {
            XMLTag tag = this.addTag(name);
            for (int i = 0; i < values.length; ++i) {
                tag.addTag("value", values[i]);
            }
            return tag;
        }

        public XMLTag addTag(String name, short[] values) {
            XMLTag tag = this.addTag(name);
            for (int i = 0; i < values.length; ++i) {
                tag.addTag("value", values[i]);
            }
            return tag;
        }

        public XMLTag addTag(String name, double[] values) {
            XMLTag tag = this.addTag(name);
            for (int i = 0; i < values.length; ++i) {
                tag.addTag("value", values[i]);
            }
            return tag;
        }

        public XMLTag addTag(String name) {
            return this.addTag(name, (String)null);
        }

        public XMLTag addTag(String name, int value) {
            return this.addTag(name, Integer.toString(value));
        }

        public XMLTag addTag(String name, double value) {
            return this.addTag(name, Double.toString(value));
        }

        public XMLTag addTag(String name, byte[] value) {
            return this.addTag(name, value.toString());
        }

        public XMLTag addTag(String name, char[] value) {
            return this.addTag(name, value.toString());
        }

        public XMLTag addTag(String name, String value) {
            XMLTag tag = this.createTag(name, this.indent + 1);
            if (value != null) {
                tag.setValue(value);
            }
            return this.addTag(tag);
        }

        private void setUseCDATA(boolean useCDATA) {
            this.useCDATA = useCDATA;
        }

        private String spaces(int n) {
            String s = "                                                                                                                                                                                                                                                                                                           ";
            return s.substring(1, n);
        }

        private String getHTMLRemarks() {
            if (this.remarks == null) {
                return "";
            }
            if (this.remarks.contains("\n")) {
                return "<!-- \n" + this.remarks + "\n-->";
            }
            return " <!-- " + this.remarks + " -->";
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append(this.spaces(this.indent * 4)).append("<").append(this.name);
            if (this.attributes != null) {
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    out.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                }
            }
            if (this.tags == null && this.value == null) {
                out.append("/>");
                out.append(this.getHTMLRemarks());
                out.append("\n");
            } else {
                out.append(">");
                if (this.tags != null && !this.tags.isEmpty()) {
                    out.append(this.getHTMLRemarks());
                    out.append("\n");
                    for (int i = 0; i < this.tags.size(); ++i) {
                        out.append(this.tags.get(i).toString());
                    }
                    if (this.value != null) {
                        out.append(this.value);
                    }
                    out.append(this.spaces(this.indent * 4));
                    out.append("</").append(this.name).append(">\n");
                } else {
                    if (this.value != null) {
                        if (this.value.contains("\n")) {
                            out.append("\n");
                            out.append(this.value);
                            out.append(this.spaces(this.indent * 4));
                        } else {
                            out.append(this.value);
                        }
                    }
                    out.append("</").append(this.name).append(">");
                    out.append(this.getHTMLRemarks());
                    out.append("\n");
                }
            }
            return out.toString();
        }
    }
}

