/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;

public class ArcEditVertexOperation
implements EditVertexOperation {
    @Override
    public Geometry insertVertex(Primitive geom, int index) throws CreateGeometryException {
        return null;
    }

    @Override
    public Geometry removeVertex(Primitive geom, int index) throws CreateGeometryException {
        return null;
    }

    @Override
    public Geometry moveVertex(Primitive geom, int index, Point point) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Arc arc = (Arc)geom;
        Arc result = (Arc)arc.cloneGeometry();
        Point center = result.getCenterPoint();
        if (center == null) {
            Envelope envelope = arc.getEnvelope();
            center = geometryManager.createPoint(envelope.getCenter(0), envelope.getCenter(1), geom.getGeometryType().getSubType());
        }
        Point initPoint = result.getInitPoint();
        Point middlePoint = result.getMiddlePoint();
        Point endPoint = result.getEndPoint();
        double radius = center.distance((Geometry)initPoint);
        double angle = this.getAngle(center, point);
        switch (index) {
            case 0: {
                double dx = point.getX() - center.getX();
                double dy = point.getY() - center.getY();
                initPoint.setX(initPoint.getX() + dx);
                initPoint.setY(initPoint.getY() + dy);
                middlePoint.setX(middlePoint.getX() + dx);
                middlePoint.setY(middlePoint.getY() + dy);
                endPoint.setX(endPoint.getX() + dx);
                endPoint.setY(endPoint.getY() + dy);
                result.setPoints(initPoint, middlePoint, endPoint);
                break;
            }
            case 1: {
                initPoint.setX(center.getX() + Math.cos(angle) * radius);
                initPoint.setY(center.getY() + Math.sin(angle) * radius);
                result.setPoints(initPoint, middlePoint, endPoint);
                break;
            }
            case 2: {
                endPoint.setX(center.getX() + Math.cos(angle) * radius);
                endPoint.setY(center.getY() + Math.sin(angle) * radius);
                result.setPoints(initPoint, middlePoint, endPoint);
                break;
            }
            case 3: {
                middlePoint.setX(center.getX() + Math.cos(angle) * radius);
                middlePoint.setY(center.getY() + Math.sin(angle) * radius);
                result.setPoints(initPoint, middlePoint, endPoint);
                break;
            }
        }
        return result;
    }

    @Override
    public List<Point> getVertexesList(Primitive geom) throws CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        ArrayList<Point> vertexList = new ArrayList<Point>();
        Arc arc = (Arc)geom;
        Point center = arc.getCenterPoint();
        if (center == null) {
            Envelope envelope = arc.getEnvelope();
            center = geometryManager.createPoint(envelope.getCenter(0), envelope.getCenter(1), geom.getGeometryType().getSubType());
        }
        vertexList.add(center);
        vertexList.add(arc.getInitPoint());
        vertexList.add(arc.getEndPoint());
        vertexList.add(arc.getMiddlePoint());
        return vertexList;
    }

    @Override
    public int getNumVertex(Primitive geom) {
        return 4;
    }

    @Override
    public boolean canInsertVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canRemoveVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canMoveVertex(int index, Point point) {
        return true;
    }

    public double getAngle(Point start, Point end) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double angle = Math.acos((end.getX() - start.getX()) / start.distance((Geometry)end));
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    @Override
    public void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Primitive primitive) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        Arc arc = (Arc)primitive;
        Point center = arc.getCenterPoint();
        if (center == null) {
            Envelope envelope = arc.getEnvelope();
            center = geometryManager.createPoint(envelope.getCenter(0), envelope.getCenter(1), primitive.getGeometryType().getSubType());
        }
        Line auxLine = geometryManager.createLine(primitive.getGeometryType().getSubType());
        auxLine.setPoints(center, arc.getInitPoint());
        drawingStatus.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
        Line auxLine2 = geometryManager.createLine(primitive.getGeometryType().getSubType());
        auxLine2.setPoints(center, arc.getEndPoint());
        drawingStatus.addStatus((Geometry)auxLine2, auxiliaryLineSymbolEditing, "");
        Line auxLine3 = geometryManager.createLine(primitive.getGeometryType().getSubType());
        auxLine3.setPoints(center, arc.getMiddlePoint());
        drawingStatus.addStatus((Geometry)auxLine3, auxiliaryLineSymbolEditing, "");
        drawingStatus.addStatus((Geometry)arc.getInitPoint(), auxiliaryPointSymbolEditing, "");
        drawingStatus.addStatus((Geometry)arc.getEndPoint(), auxiliaryPointSymbolEditing, "");
        drawingStatus.addStatus((Geometry)arc.getMiddlePoint(), auxiliaryPointSymbolEditing, "");
        drawingStatus.addStatus((Geometry)primitive, drawingStatus.getPreviewSymbol(), "");
        drawingStatus.addStatus((Geometry)primitive, lineSymbolEditing, "");
    }
}

