/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.FilledSpline;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperationUtils;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.SplineCalculator;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;

public class FilledSplineEditVertexOperation
implements EditVertexOperation {
    @Override
    public Geometry insertVertex(Primitive geom, int index) throws CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        GeometryType geomType = geom.getGeometryType();
        FilledSpline result = (FilledSpline)geometryManager.create(25, geomType.getSubType());
        FilledSpline filledSpline = (FilledSpline)geom;
        int numVertices = filledSpline.getNumVertices();
        double[][] values = new double[geom.getDimension()][numVertices];
        for (int v = 0; v < numVertices; ++v) {
            for (int d = 0; d < filledSpline.getDimension(); ++d) {
                values[d][v] = filledSpline.getCoordinateAt(v, d);
            }
        }
        int auxIndex = index;
        if (index == 0) {
            auxIndex = numVertices - 1;
        }
        for (int i = 0; i < numVertices; ++i) {
            Point point = filledSpline.getVertex(i);
            if (i > 0 && i == auxIndex) {
                Point newPoint;
                try {
                    newPoint = (Point)geometryManager.create(geometryManager.getGeometryType(1, geomType.getSubType()));
                }
                catch (GeometryTypeNotSupportedException | GeometryTypeNotValidException e) {
                    throw new CreateGeometryException(1, geomType.getSubType(), e);
                }
                for (int d = 0; d < geom.getDimension(); ++d) {
                    SplineCalculator splineDim = new SplineCalculator(values[d]);
                    newPoint.setCoordinateAt(d, splineDim.fn(i - 1, 0.5));
                }
                result.addVertex(newPoint);
            }
            result.addVertex(point);
        }
        return result;
    }

    @Override
    public Geometry removeVertex(Primitive geom, int index) throws CreateGeometryException {
        FilledSpline filledSpline = (FilledSpline)geom.cloneGeometry();
        if (index < 0) {
            return filledSpline;
        }
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        int numVertices = filledSpline.getNumVertices();
        if (index >= numVertices) {
            return filledSpline;
        }
        if (filledSpline.getVertex(0).equals(filledSpline.getVertex(numVertices - 1))) {
            if (numVertices <= 4) {
                return filledSpline;
            }
            if (index == 0 || index == numVertices - 1) {
                filledSpline.removeVertex(numVertices - 1);
                filledSpline.removeVertex(0);
                filledSpline.addVertex(filledSpline.getVertex(0));
                --numVertices;
                return filledSpline;
            }
            --numVertices;
        } else if (numVertices <= 3) {
            return filledSpline;
        }
        filledSpline.removeVertex(index);
        return filledSpline;
    }

    @Override
    public Geometry moveVertex(Primitive geom, int index, Point point) {
        FilledSpline result = (FilledSpline)geom.cloneGeometry();
        int numVertices = result.getNumVertices();
        if (result.getVertex(0).equals(result.getVertex(numVertices - 1)) && (index == 0 || index == result.getNumVertices() - 1)) {
            EditVertexOperationUtils.setVertex((OrientablePrimitive)result, 0, point);
            EditVertexOperationUtils.setVertex((OrientablePrimitive)result, result.getNumVertices() - 1, point.cloneGeometry());
            return result;
        }
        EditVertexOperationUtils.setVertex((OrientablePrimitive)result, index, point);
        return result;
    }

    @Override
    public List<Point> getVertexesList(Primitive geom) {
        ArrayList<Point> vertexList = new ArrayList<Point>();
        if (geom instanceof OrientablePrimitive) {
            OrientablePrimitive orientable = (OrientablePrimitive)geom;
            orientable.getNumVertices();
            for (int i = 0; i < orientable.getNumVertices(); ++i) {
                vertexList.add(orientable.getVertex(i));
            }
        }
        return vertexList;
    }

    @Override
    public int getNumVertex(Primitive geom) {
        if (geom instanceof OrientablePrimitive) {
            OrientablePrimitive orientable = (OrientablePrimitive)geom;
            return orientable.getNumVertices();
        }
        return 0;
    }

    @Override
    public boolean canInsertVertex(Primitive geom, int index) {
        return true;
    }

    @Override
    public boolean canRemoveVertex(Primitive geom, int index) {
        return true;
    }

    @Override
    public boolean canMoveVertex(int index, Point point) {
        return true;
    }

    @Override
    public void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Primitive primitive) {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        drawingStatus.addStatus((Geometry)primitive, drawingStatus.getPreviewSymbol(), "");
        drawingStatus.addStatus((Geometry)primitive, lineSymbolEditing, "");
    }
}

