/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperationUtils;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;

public class LineEditVertexOperation
implements EditVertexOperation {
    @Override
    public Geometry insertVertex(Primitive geom, int index) throws CreateGeometryException {
        if (index == 0) {
            return geom;
        }
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        GeometryType geomType = geom.getGeometryType();
        Line result = geometryManager.createLine(geomType.getSubType());
        Line line = (Line)geom;
        int numVertices = line.getNumVertices();
        Point antPoint = null;
        for (int i = 0; i < numVertices; ++i) {
            Point point = line.getVertex(i);
            if (i == index) {
                Point newPoint = geometryManager.createPoint((point.getX() + antPoint.getX()) / 2.0, (point.getY() + antPoint.getY()) / 2.0, geomType.getSubType());
                for (int j = 2; j < geom.getDimension(); ++j) {
                    newPoint.setCoordinateAt(j, (point.getCoordinateAt(j) + antPoint.getCoordinateAt(j)) / 2.0);
                }
                result.addVertex(newPoint);
            }
            result.addVertex(point);
            antPoint = point;
        }
        return result;
    }

    @Override
    public Geometry removeVertex(Primitive geom, int index) throws CreateGeometryException {
        if (index < 0) {
            return geom;
        }
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Line result = geometryManager.createLine(geom.getGeometryType().getSubType());
        Line line = (Line)geom;
        int numVertices = line.getNumVertices();
        for (int i = 0; i < numVertices; ++i) {
            Point point = line.getVertex(i);
            if (i == index) continue;
            result.addVertex(point);
        }
        return result;
    }

    @Override
    public Geometry moveVertex(Primitive geom, int index, Point point) {
        Line result = (Line)geom.cloneGeometry();
        EditVertexOperationUtils.setVertex((OrientablePrimitive)result, index, point);
        return result;
    }

    @Override
    public List<Point> getVertexesList(Primitive geom) {
        ArrayList<Point> vertexList = new ArrayList<Point>();
        if (geom instanceof OrientablePrimitive) {
            OrientablePrimitive orientable = (OrientablePrimitive)geom;
            orientable.getNumVertices();
            for (int i = 0; i < orientable.getNumVertices(); ++i) {
                vertexList.add(orientable.getVertex(i));
            }
        }
        return vertexList;
    }

    @Override
    public int getNumVertex(Primitive geom) {
        if (geom instanceof OrientablePrimitive) {
            OrientablePrimitive orientable = (OrientablePrimitive)geom;
            return orientable.getNumVertices();
        }
        return 0;
    }

    @Override
    public boolean canInsertVertex(Primitive geom, int index) {
        return index != 0;
    }

    @Override
    public boolean canRemoveVertex(Primitive geom, int index) {
        return true;
    }

    @Override
    public boolean canMoveVertex(int index, Point point) {
        return true;
    }

    @Override
    public void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Primitive primitive) {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        drawingStatus.addStatus((Geometry)primitive, lineSymbolEditing, "");
        drawingStatus.addStatus((Geometry)primitive, drawingStatus.getPreviewSymbol(), "");
    }
}

