/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.buffer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.swing.buffer.SelectableBandsTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class DefaultSelectableBandsTableModel
extends AbstractTableModel
implements SelectableBandsTableModel {
    private static final long serialVersionUID = -6739781555636046945L;
    private List<SelectableBand> bands = new ArrayList<SelectableBand>();
    private static final int COLUMNS = 4;
    private static final int COLUMN_SELECTED = 0;
    private static final int COLUMN_NUMBER = 1;
    private static final int COLUMN_BAND_NAME = 2;
    private static final int COLUMN_BAND_DESCRIPTION = 3;

    public DefaultSelectableBandsTableModel(BandInfo[] bandsInfo) {
        for (int i = 0; i < bandsInfo.length; ++i) {
            SelectableBand selectableBand = new SelectableBand(i, bandsInfo[i], true);
            this.bands.add(selectableBand);
        }
    }

    @Override
    public int getRowCount() {
        return this.bands.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.bands.get(rowIndex).isSelected();
            }
            case 1: {
                return this.bands.get(rowIndex).getNumber();
            }
            case 2: {
                return this.bands.get(rowIndex).getBandInfo().getName();
            }
            case 3: {
                return this.bands.get(rowIndex).getBandInfo().getDescription();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.bands.size() && columnIndex < 4) {
            switch (columnIndex) {
                case 0: {
                    if (aValue == null) {
                        this.bands.get(rowIndex).setSelected(false);
                        break;
                    }
                    if (!(aValue instanceof Boolean)) {
                        throw new IllegalArgumentException("The object '" + aValue.toString() + "' must be a Boolean.");
                    }
                    this.bands.get(rowIndex).setSelected((Boolean)aValue);
                    this.fireTableDataChanged();
                    break;
                }
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        switch (column) {
            case 0: {
                return i18nManager.getTranslation("_selected");
            }
            case 1: {
                return i18nManager.getTranslation("_number");
            }
            case 2: {
                return i18nManager.getTranslation("_band_name");
            }
            case 3: {
                return i18nManager.getTranslation("_band_description");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return Boolean.class;
        }
        return super.getColumnClass(col);
    }

    public void up(int rowIndex) {
        if (rowIndex > 0) {
            SelectableBand aux = this.bands.get(rowIndex);
            this.bands.set(rowIndex, this.bands.get(rowIndex - 1));
            this.bands.set(rowIndex - 1, aux);
            this.fireTableDataChanged();
        }
    }

    public void down(int rowIndex) {
        if (rowIndex < this.bands.size() - 1) {
            SelectableBand aux = this.bands.get(rowIndex);
            this.bands.set(rowIndex, this.bands.get(rowIndex + 1));
            this.bands.set(rowIndex + 1, aux);
            this.fireTableDataChanged();
        }
    }

    public List<Integer> getSelectedBands() {
        ArrayList<Integer> selectedBands = new ArrayList<Integer>();
        for (SelectableBand selBand : this.bands) {
            if (!selBand.isSelected()) continue;
            selectedBands.add(selBand.getNumber());
        }
        return Collections.unmodifiableList(selectedBands);
    }

    public void selectBand(int band) {
        this.bands.get(band).setSelected(true);
        this.fireTableDataChanged();
    }

    public void unselectBand(int band) {
        this.bands.get(band).setSelected(false);
        this.fireTableDataChanged();
    }

    public void selectAllBands() {
        for (SelectableBand selBand : this.bands) {
            selBand.setSelected(true);
            this.fireTableDataChanged();
        }
    }

    public void unselectAllBands() {
        for (SelectableBand selBand : this.bands) {
            selBand.setSelected(false);
            this.fireTableDataChanged();
        }
    }

    public static class SelectableBand {
        private boolean selected;
        private int number;
        private BandInfo bandInfo;

        public SelectableBand(int number, BandInfo bandInfo, boolean selected) {
            this.setNumber(number);
            this.setBandInfo(bandInfo);
            this.setSelected(selected);
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public BandInfo getBandInfo() {
            return this.bandInfo;
        }

        public void setBandInfo(BandInfo bandInfo) {
            this.bandInfo = bandInfo;
        }
    }
}

