/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.buffer.impl.save;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.NewRasterStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemFileFilter;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.spi.DALSPILocator;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.swing.buffer.save.SaveBufferDialog;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSaveBufferDialog
extends JFileChooser
implements SaveBufferDialog {
    private static final long serialVersionUID = 3382921398256836543L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultSaveBufferDialog.class);
    private Iterator<FilesystemServerExplorerProvider> fileFilters;
    private Buffer buffer;
    private DataStoreParametersPanel panelProperty;
    private JPanel emptyAccessoryPanel;

    public DefaultSaveBufferDialog() {
        super(BufferLocator.getBufferManager().getLastFolderUsedToSaveRaster());
        this.setAccessory(this.getEmptyAccessoryPanel());
    }

    public DefaultSaveBufferDialog(Buffer buffer) {
        this();
        this.setBuffer(buffer);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setFilters(Iterator<FilesystemServerExplorerProvider> fileFilters) {
        this.fileFilters = fileFilters;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    private void initializeComponents() {
        while (this.getFileFilters().hasNext()) {
            FilesystemServerExplorerProvider provider = this.fileFilters.next();
            if (!provider.canCreate()) continue;
            this.addChoosableFileFilter(new MyFileFilter((FilesystemFileFilter)provider));
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                evt.getNewValue();
                if (evt.getNewValue() instanceof MyFileFilter) {
                    String dataStoreProviderName = ((MyFileFilter)evt.getNewValue()).getFileFilter().getDataStoreProviderName();
                    final NewRasterStoreParameters params = DefaultSaveBufferDialog.this.getParams(dataStoreProviderName);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultSaveBufferDialog.this.panelProperty = DefaultSaveBufferDialog.this.loadPanelProperties(params);
                            if (DefaultSaveBufferDialog.this.panelProperty != null) {
                                DefaultSaveBufferDialog.this.setAccessory(DefaultSaveBufferDialog.this.panelProperty.asJComponent());
                                Dimension dimension = DefaultSaveBufferDialog.this.getPreferredSize();
                                DefaultSaveBufferDialog.this.getParent().setPreferredSize(new Dimension(dimension.width * 2, dimension.height));
                            } else {
                                JPanel panel = DefaultSaveBufferDialog.this.getEmptyAccessoryPanel();
                                DefaultSaveBufferDialog.this.setAccessory(panel);
                            }
                            DefaultSaveBufferDialog.this.revalidate();
                            DefaultSaveBufferDialog.this.repaint();
                        }
                    });
                }
            }
        });
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
    }

    private Iterator<FilesystemServerExplorerProvider> getFileFilters() {
        if (this.fileFilters == null) {
            DataManager dm = DALLocator.getDataManager();
            FilesystemServerExplorer explorer = null;
            try {
                FilesystemServerExplorerParameters param = (FilesystemServerExplorerParameters)dm.createServerExplorerParameters("FilesystemExplorer");
                explorer = (FilesystemServerExplorer)dm.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)param);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.fileFilters = explorer.getFilters(4);
        }
        return this.fileFilters;
    }

    public NewRasterStoreParameters getParameters() {
        MyFileFilter fileFilter = (MyFileFilter)this.getFileFilter();
        FilesystemFileFilter fileSystemFilter = fileFilter.getFileFilter();
        String providerName = fileSystemFilter.getDataStoreProviderName();
        NewRasterStoreParameters params = this.getParams(providerName);
        File selectedFile = this.getSelectedFile();
        if (this.panelProperty != null && this.panelProperty instanceof DataStoreParametersPanel) {
            this.panelProperty.fetchParameters((DynObject)params);
        }
        params.setBuffer(this.buffer);
        ((FilesystemStoreParameters)params).setFile(selectedFile);
        return params;
    }

    public String getProviderName() {
        FilesystemFileFilter fileSystemFilter = ((MyFileFilter)this.getFileFilter()).getFileFilter();
        return fileSystemFilter.getDataStoreProviderName();
    }

    private NewRasterStoreParameters getParams(String dataStoreProviderName) {
        NewRasterStoreParameters params;
        DataServerExplorer serverExplorer;
        DataManagerProviderServices dataManager = null;
        try {
            dataManager = DALSPILocator.getDataManagerProviderServices();
        }
        catch (LocatorException e) {
            logger.warn("Can't get data manager.", (Throwable)e);
            return null;
        }
        DataServerExplorerParameters eparams = null;
        try {
            serverExplorer = dataManager.openServerExplorer("FilesystemExplorer", eparams);
        }
        catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException e) {
            logger.warn("Can't open explorer.", e);
            return null;
        }
        try {
            params = (NewRasterStoreParameters)serverExplorer.getAddParameters(dataStoreProviderName);
        }
        catch (DataException e) {
            logger.warn("Can't create store parameters.", (Throwable)e);
            return null;
        }
        return params;
    }

    protected DataStoreParametersPanel loadPanelProperties(NewRasterStoreParameters params) {
        if (params != null) {
            DataStoreParametersPanelManager manager = DALSwingLocator.getDataStoreParametersPanelManager();
            DataStoreParametersPanel panel = manager.createDataStoreParametersPanel((DynObject)params);
            panel.setExcludeGeometryOptions(false);
            JDynForm form = panel.getForm();
            if (form != null) {
                int cnt = 0;
                DynFormDefinition def = form.getDefinition();
                for (DynFormFieldDefinition fieldDef : def.getDefinitions()) {
                    if (fieldDef.getType() == 13 && fieldDef.isMandatory()) {
                        fieldDef.setHidden(true);
                        continue;
                    }
                    if ("providername".equalsIgnoreCase(fieldDef.getName())) {
                        fieldDef.setHidden(true);
                        continue;
                    }
                    if (fieldDef.isHidden()) continue;
                    ++cnt;
                }
                if (cnt == 0) {
                    return null;
                }
                form.setLayoutMode(2);
            }
            return panel;
        }
        return null;
    }

    @Override
    public void approveSelection() {
        BufferLocator.getBufferManager().setLastFolderUsedToSaveRaster(this.getSelectedFile().getParentFile());
        super.approveSelection();
    }

    private JPanel getEmptyAccessoryPanel() {
        if (this.emptyAccessoryPanel == null) {
            this.emptyAccessoryPanel = new JPanel();
            this.emptyAccessoryPanel.setPreferredSize(new Dimension(500, 250));
        }
        return this.emptyAccessoryPanel;
    }

    public void showDialog(Component parent) {
        this.initializeComponents();
        boolean exit = false;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        while (!exit) {
            if (super.showSaveDialog(parent) == 0) {
                NewRasterStoreParameters params = this.getParameters();
                String providerName = this.getProviderName();
                File file = ((FilesystemStoreParameters)params).getFile();
                ThreadSafeDialogsManager dlgManager = ToolsSwingLocator.getThreadSafeDialogsManager();
                try {
                    if (file.exists()) {
                        String title;
                        String message = i18nManager.getTranslation("_File_exists_Overwrite_question");
                        int confirm = dlgManager.confirmDialog(message, title = i18nManager.getTranslation("_export_raster"), 0, 3);
                        if (confirm != 0) continue;
                        DALLocator.getDataManager().createFileStore(providerName, (NewDataStoreParameters)params, true);
                        exit = true;
                        continue;
                    }
                    DALLocator.getDataManager().createFileStore(providerName, (NewDataStoreParameters)params, true);
                    exit = true;
                    continue;
                }
                catch (DataException | LocatorException e) {
                    logger.warn("Can't export buffer from view's image.", e);
                    String message = i18nManager.getTranslation("_error_exporting_buffer");
                    String title = i18nManager.getTranslation("_export_raster");
                    dlgManager.messageDialog(message, title, 2);
                    return;
                }
            }
            exit = true;
        }
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    private static class MyFileFilter
    extends FileFilter {
        private FilesystemFileFilter fileFilter;

        public MyFileFilter(FilesystemFileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return this.getFileFilter().accept(f);
        }

        @Override
        public String getDescription() {
            return this.getFileFilter().getDescription();
        }

        public FilesystemFileFilter getFileFilter() {
            return this.fileFilter;
        }
    }
}

