/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml;

import org.gvsig.compat.CompatLibrary;
import org.gvsig.gpe.lib.api.GPELibrary;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.exceptions.ParserNotRegisteredException;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerNotRegisteredException;
import org.gvsig.gpe.lib.spi.GPEProviderLocator;
import org.gvsig.gpe.lib.spi.GPEProviderManager;
import org.gvsig.gpe.prov.gml.parser.GPEGmlSFP0Parser;
import org.gvsig.gpe.prov.gml.writer.GPEGmlSFP0WriterHandlerImplementor;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.tools.locator.Locator;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;
import org.gvsig.xmlpull.lib.api.XmlPullLibrary;
import org.gvsig.xmlschema.lib.api.XMLSchemaLocator;
import org.gvsig.xmlschema.lib.api.XMLSchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GmlLibrary
extends AbstractLibrary {
    private static final Logger logger = LoggerFactory.getLogger(GmlLibrary.class);
    private static final String GMLFORMAT = "gml";

    public void doRegistration() {
        this.registerAsServiceOf(GPELibrary.class);
        this.require(CompatLibrary.class);
        this.require(XmlPullLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        GPEManager gpeManager = GPELocator.getGPEManager();
        if (gpeManager == null) {
            throw new ReferenceNotRegisteredException("GPEManager", (Locator)GPELocator.getInstance());
        }
        GPEProviderManager gpeProviderManager = GPEProviderLocator.getGPEProviderManager();
        if (gpeProviderManager == null) {
            throw new ReferenceNotRegisteredException("GPEProviderManager", (Locator)GPEProviderLocator.getInstance());
        }
        gpeManager.setProperty("decimal", (Object)".");
        gpeManager.setProperty("coordinatesSeparator", (Object)",");
        gpeManager.setProperty("tuplesSeparator", (Object)" ");
        gpeManager.setProperty("featureCollection", (Object)"FeatureCollection");
        gpeManager.setProperty("feature", (Object)"Feature");
        gpeManager.setProperty("srsBasedOnXml", (Object)true);
        try {
            gpeProviderManager.addGpeParser("GMLSFP0", "Parser for GML", GPEGmlSFP0Parser.class);
        }
        catch (ParserNotRegisteredException e) {
            logger.error("Impossible to register a GML parser");
        }
        try {
            gpeProviderManager.addGpeWriterHandlerImplementor("GMLSFP0", "Writer for GML", GPEGmlSFP0WriterHandlerImplementor.class);
        }
        catch (WriterHandlerNotRegisteredException e) {
            logger.error("Impossible to register a GML writer");
        }
        XMLSchemaManager xmlSchemaManager = XMLSchemaLocator.getXMLSchemaManager();
        if (xmlSchemaManager != null) {
            xmlSchemaManager.registerFormat("text/xml; subtype=gml/2.0.0", GMLFORMAT);
            xmlSchemaManager.registerFormat("text/xml; subtype=gml/2.1.0", GMLFORMAT);
            xmlSchemaManager.registerFormat("text/xml; subtype=gml/3.2", GMLFORMAT);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"Point", 1);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"LineString", 2);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"LinearRing", 3);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"Polygon", 3);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiGeometry", 6);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiPoint", 7);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiLineString", 8);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiPolygon", 9);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiCurve", 8);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiSurface", 9);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"Curve", 2);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"Surface", 3);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"PointPropertyType", 1);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"LineStringPropertyType", 2);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"LinearRingPropertyType", 3);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"PolygonPropertyType", 3);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiGeometryPropertyType", 6);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiPointPropertyType", 7);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiLineStringPropertyType", 8);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiPolygonPropertyType", 9);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiCurvePropertyType", 8);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"MultiSurfacePropertyType", 9);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"CurvePropertyType", 2);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"SurfacePropertyType", 3);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"GeometryPropertyType", 0);
            xmlSchemaManager.addParserGeometryType(GMLFORMAT, (Object)"GeometryAssociationType", 0);
        }
    }
}

