/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.writer.v2.features;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.gpe.prov.gml.utils.GmlUtilsParser;
import org.gvsig.gpe.prov.gml.writer.GPEGmlWriterHandlerImplementor;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamWriter;

public class FeatureCollectionWriter {
    private static GPEManager gpeManager = GPELocator.getGPEManager();

    public void start(IXmlStreamWriter writer, GPEGmlWriterHandlerImplementor handler, String fid, String namespace, String name) throws IOException {
        String myName = GmlUtilsParser.addBlancSymbol(name);
        String myNamespace = namespace;
        if (name == null) {
            QName qname = GmlUtilsParser.createDefaultFeatureCollection();
            myName = qname.getLocalPart();
            myNamespace = qname.getNamespaceURI();
        } else if (namespace == null) {
            myNamespace = gpeManager.getStringProperty("namespaceURI");
        }
        writer.writeStartElement(myNamespace, myName);
        if (fid != null) {
            writer.writeStartAttribute(GmlTags.GML_FID);
            writer.writeValue(fid);
        }
        writer.writeStartAttribute("http://www.w3.org/2000/xmlns/", "xmlns:xsi");
        writer.writeValue("http://www.w3.org/2001/XMLSchema-instance");
        writer.writeStartAttribute("http://www.w3.org/2000/xmlns/", "xmlns:xlink");
        writer.writeValue("http://www.w3.org/1999/xlink");
        writer.writeStartAttribute("http://www.w3.org/2000/xmlns/", "xmlns:gml");
        writer.writeValue("http://www.opengis.net/gml");
        writer.writeStartAttribute("http://www.w3.org/2000/xmlns/", "xmlns:" + gpeManager.getStringProperty("namespacePrefix"));
        writer.writeValue(gpeManager.getStringProperty("namespaceURI"));
        writer.writeStartAttribute("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
        String schemaLocation = gpeManager.getStringProperty("namespaceURI") + " " + gpeManager.getStringProperty("schemaName");
        writer.writeValue(schemaLocation);
    }

    public void start(IXmlStreamWriter writer, GPEGmlWriterHandlerImplementor handler, String fid, String namespace, String name, String description, String srs) throws IOException {
        this.start(writer, handler, fid, namespace, name);
        writer.writeEndAttributes();
        handler.getProfile().getNameWriter().write(writer, handler, name);
        handler.getProfile().getDescriptionWriter().write(writer, handler, description);
    }

    public void end(IXmlStreamWriter writer, GPEGmlWriterHandlerImplementor handler) throws IOException {
        writer.writeEndElement();
    }
}

