/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.wizard;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageService;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.swing.impl.creation.DefaultMakePluginPackageWizard;
import org.gvsig.installer.swing.impl.creation.panel.AntScriptPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntScriptWizard
extends AntScriptPanel
implements OptionPanel {
    private static final long serialVersionUID = -4741237867123090223L;
    private DefaultMakePluginPackageWizard installerCreationWizard;
    private static final Logger log = LoggerFactory.getLogger(AntScriptWizard.class);

    public AntScriptWizard(DefaultMakePluginPackageWizard installerCreationWizard) {
        this.installerCreationWizard = installerCreationWizard;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.swingInstallerManager.getText("_ant_script");
    }

    public void lastPanel() {
    }

    public void nextPanel() throws NotContinueWizardException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.parse(new ByteArrayInputStream(this.getAntScript().getBytes()));
        }
        catch (Exception e) {
            throw new NotContinueWizardException("not_valid_xml", (Throwable)e, (Component)this.installerCreationWizard);
        }
        PackageInfo packageInfo = this.installerCreationWizard.getSelectedPackageInfo();
        packageInfo.setAntScript(this.getAntScript());
    }

    public void updatePanel() {
        try {
            MakePluginPackageService installerCreationService = this.installerCreationWizard.getInstallerCreationService();
            PackageInfo installerInfo = this.installerCreationWizard.getSelectedPackageInfo();
            if (installerInfo.getAntScript() != null) {
                this.setAntScript(installerInfo.getAntScript());
            } else {
                this.setAntScript(installerCreationService.getDefaultAntScript());
            }
        }
        catch (MakePluginPackageServiceException e) {
            log.error("There is not a selected installer info", (Throwable)e);
        }
    }
}

