/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.packagebuilder.options;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.creation.JOutputPanel;
import org.gvsig.installer.swing.impl.packagebuilder.BasePackageWizard;

public class OutputOption
implements OptionPanel {
    private final JOutputPanel outputPanel;
    private final BasePackageWizard wizard;

    public OutputOption(BasePackageWizard wizard) {
        this.wizard = wizard;
        SwingInstallerManager installerManager = SwingInstallerLocator.getSwingInstallerManager();
        this.outputPanel = installerManager.createOutputPanel();
        this.outputPanel.setPackageInfo((PackageInfo)wizard.getPackageInfo());
    }

    public JPanel getJPanel() {
        return this.outputPanel;
    }

    private String getText(String msg) {
        return Messages.getText((String)msg);
    }

    public String getPanelTitle() {
        return this.getText("_output_options");
    }

    public void lastPanel() {
    }

    public void nextPanel() throws NotContinueWizardException {
        File file = this.outputPanel.getPackageFile();
        File filePath = new File(file.getParent());
        if (!filePath.exists()) {
            JOptionPane.showMessageDialog((Component)this.outputPanel, this.getText("_the_package_file_folder_does_not_exist") + ": " + filePath);
            throw new NotContinueWizardException("", null, false);
        }
        if (this.outputPanel.isCreatePackageIndex()) {
            URL url = this.outputPanel.getDownloadURL();
            if (url == null) {
                throw new NotContinueWizardException("", null, false);
            }
            File indexFile = this.outputPanel.getPackageIndexFile();
            File indexFilePath = new File(indexFile.getParent());
            if (!indexFilePath.exists()) {
                JOptionPane.showMessageDialog((Component)this.outputPanel, this.getText("_the_package_index_file_folder_does_not_exist") + ": " + indexFilePath);
                throw new NotContinueWizardException("", null, false);
            }
        }
    }

    public void updatePanel() {
        this.outputPanel.setPackageFile(this.wizard.getDefaultPackageBundleFile());
        this.outputPanel.setPackageIndexFile(this.wizard.getDefaultPackageIndexBundleFile());
    }

    public URL getDownloadURL() {
        return this.outputPanel.getDownloadURL();
    }

    public File getPackageIndexFile() {
        return this.outputPanel.getPackageIndexFile();
    }

    public boolean shouldCreateIndex() {
        return this.outputPanel.isCreatePackageIndex();
    }

    public File getPackageFile() {
        return this.outputPanel.getPackageFile();
    }
}

