/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.complexlabel.app.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.gui.labeling.LabelClassEditor;
import org.gvsig.complexlabel.app.editor.LabelClassScalePanel;
import org.gvsig.complexlabel.impl.ComplexLabelClassFactory;
import org.gvsig.complexlabel.impl.DefaultComplexLabelClass;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.labeling.gui.layerproperties.LabelClassProperties;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexLabelClassEditor
extends JPanel
implements LabelClassEditor,
IWindow,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ComplexLabelClassEditor.class);
    private LabelClassProperties labelClassEditorPanel;
    private LabelClassScalePanel labelClassScalePanel;
    private AcceptCancelPanel acceptCancelPanel;
    private JTabbedPane mainPanel;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();
    private FeatureStore fstore;
    private DefaultComplexLabelClass complexLabelClass;

    public ComplexLabelClassEditor(FeatureStore store) {
        this(store, null);
    }

    public ComplexLabelClassEditor(FeatureStore store, DefaultComplexLabelClass labelClass) {
        this.fstore = store;
        this.initialize();
        if (labelClass == null) {
            ComplexLabelClassFactory factory = (ComplexLabelClassFactory)SymbologyLocator.getSymbologyManager().getLabelClassFactory("MultipleLabelByScale");
            this.complexLabelClass = (DefaultComplexLabelClass)factory.create();
        } else {
            this.complexLabelClass = labelClass;
        }
        this.setLabelClass((ILabelClass)this.complexLabelClass);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JTabbedPane();
        this.mainPanel.addTab(this.i18nManager.getTranslation("Label_definition"), this.getPropertiesPanel().asJComponent());
        this.mainPanel.addTab(this.i18nManager.getTranslation("Label_scale_definition"), this.getScaledPanel().asJComponent());
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.getAcceptCancelPanelButton(), "South");
    }

    private AcceptCancelPanel getAcceptCancelPanelButton() {
        if (this.acceptCancelPanel == null) {
            this.acceptCancelPanel = new AcceptCancelPanel((ActionListener)this, (ActionListener)this);
            this.acceptCancelPanel.setVisible(true);
        }
        return this.acceptCancelPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.labelClassEditorPanel.actionPerformed(new ActionEvent(this, 1, "other"));
            this.getLabelClass();
            try {
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
            }
            catch (Exception ex) {
                logger.warn("While closing window.", (Throwable)ex);
            }
        } else if ("CANCEL".equals(e.getActionCommand())) {
            try {
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
            }
            catch (Exception ex) {
                logger.warn("While closing window.", (Throwable)ex);
            }
        }
    }

    private LabelClassProperties getPropertiesPanel() {
        if (this.labelClassEditorPanel == null) {
            this.labelClassEditorPanel = new LabelClassProperties(this.fstore);
            this.labelClassEditorPanel.setAcceptCancelVisible(false);
        }
        return this.labelClassEditorPanel;
    }

    private LabelClassScalePanel getScaledPanel() {
        if (this.labelClassScalePanel == null) {
            this.labelClassScalePanel = new LabelClassScalePanel();
        }
        return this.labelClassScalePanel;
    }

    public JComponent asJComponent() {
        return this;
    }

    public ILabelClass getLabelClass() {
        this.labelClassEditorPanel.doAccept();
        this.complexLabelClass = (DefaultComplexLabelClass)this.labelClassEditorPanel.getLabelClass();
        this.complexLabelClass.setMaxScale(this.labelClassScalePanel.getMaxScale());
        this.complexLabelClass.setMinScale(this.labelClassScalePanel.getMinScale());
        return this.complexLabelClass;
    }

    public void setLabelClass(ILabelClass labelClass) {
        this.complexLabelClass = (DefaultComplexLabelClass)labelClass;
        this.labelClassEditorPanel.setLabelClass((ILabelClass)this.complexLabelClass);
        this.labelClassScalePanel.setMaxScale(this.complexLabelClass.getMaxScale());
        this.labelClassScalePanel.setMinScale(this.complexLabelClass.getMinScale());
    }

    public void showDialog() {
        ApplicationLocator.getManager().getUIManager().addWindow((IWindow)this);
    }

    public boolean isAccepted() {
        return this.getPropertiesPanel().isAccepted() && this.getScaledPanel().isAccepted();
    }

    public WindowInfo getWindowInfo() {
        WindowInfo wi = new WindowInfo(9);
        wi.setTitle(this.i18nManager.getTranslation("complex_label_class_properties"));
        wi.setWidth(this.getPreferredSize().width + 8);
        wi.setHeight(this.getPreferredSize().height);
        return wi;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

