/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.complexlabel.app.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.gvsig.complexlabel.impl.DefaultComplexLabelClass;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class LabelClassScalePanel
extends JPanel {
    private static final long serialVersionUID = -7443140994364499103L;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();
    private JSpinner maxScaleTXT;
    private JSpinner minScaleTXT;
    private JCheckBox minScaleCk;
    private JCheckBox maxScaleCk;

    public LabelClassScalePanel() {
        this.initialize();
    }

    public LabelClassScalePanel(DefaultComplexLabelClass labelClass) {
        this();
        this.setModel(labelClass);
    }

    private void setModel(DefaultComplexLabelClass labelClass) {
        this.setMinScale(labelClass.getMinScale());
        this.setMaxScale(labelClass.getMaxScale());
    }

    public boolean isAccepted() {
        return this.getMaxScaleField().getValue() != null && this.getMinScaleField().getValue() != null;
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(450, 160));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setPreferredSize(new Dimension(440, 100));
        JPanel mainDataPanel = new JPanel();
        mainDataPanel.setPreferredSize(new Dimension(200, 100));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[]{150, 180, 70};
        gridBagLayout2.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        mainDataPanel.setLayout(gridBagLayout2);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        c.ipadx = 10;
        c.gridx = 0;
        c.gridy = 0;
        JLabel labelURL = new JLabel(this.i18nManager.getTranslation("MinScale") + ":");
        mainDataPanel.add((Component)labelURL, c);
        c.gridx = 1;
        c.gridwidth = 2;
        mainDataPanel.add((Component)this.getMinScaleField(), c);
        c.gridy = 1;
        mainDataPanel.add((Component)this.getWithoutMinScale(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        JLabel labelUser = new JLabel(this.i18nManager.getTranslation("MaxScale") + ":");
        mainDataPanel.add((Component)labelUser, c);
        c.gridx = 1;
        c.gridwidth = 2;
        mainDataPanel.add((Component)this.getMaxScaleField(), c);
        c.gridy = 3;
        mainDataPanel.add((Component)this.getWithoutMaxScale(), c);
        mainPanel.add((Component)mainDataPanel, "Center");
        this.add((Component)mainPanel, "Center");
    }

    private JSpinner getMaxScaleField() {
        if (this.maxScaleTXT == null) {
            SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 1000000000, 1000000);
            this.maxScaleTXT = new JSpinner(model);
        }
        return this.maxScaleTXT;
    }

    private JSpinner getMinScaleField() {
        if (this.minScaleTXT == null) {
            SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 1000000000, 1000000);
            this.minScaleTXT = new JSpinner(model);
        }
        return this.minScaleTXT;
    }

    public double getMinScale() {
        if (this.getWithoutMinScale().isSelected()) {
            return -1.0;
        }
        Object obj = this.getMinScaleField().getValue();
        if (obj instanceof Integer) {
            Integer x = (Integer)obj;
            return x.doubleValue();
        }
        return (Double)obj;
    }

    public double getMaxScale() {
        if (this.getWithoutMaxScale().isSelected()) {
            return 1.000000001E9;
        }
        Object obj = this.getMaxScaleField().getValue();
        if (obj instanceof Integer) {
            Integer x = (Integer)obj;
            return x.doubleValue();
        }
        return (Double)obj;
    }

    public void setMinScale(double scale) {
        if (scale != -1.0) {
            this.getMinScaleField().setValue(scale);
        } else {
            this.getWithoutMinScale().setSelected(true);
        }
    }

    public void setMaxScale(double scale) {
        if (scale != 1.000000001E9) {
            this.getMaxScaleField().setValue(scale);
        } else {
            this.getWithoutMaxScale().setSelected(true);
        }
    }

    private JCheckBox getWithoutMinScale() {
        if (this.minScaleCk == null) {
            this.minScaleCk = new JCheckBox(this.i18nManager.getTranslation("without_min_scale"));
            this.minScaleCk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LabelClassScalePanel.this.getMinScaleField().setEnabled(!LabelClassScalePanel.this.minScaleCk.isSelected());
                }
            });
        }
        return this.minScaleCk;
    }

    private JCheckBox getWithoutMaxScale() {
        if (this.maxScaleCk == null) {
            this.maxScaleCk = new JCheckBox(this.i18nManager.getTranslation("without_max_scale"));
            this.maxScaleCk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LabelClassScalePanel.this.getMaxScaleField().setEnabled(!LabelClassScalePanel.this.maxScaleCk.isSelected());
                }
            });
        }
        return this.maxScaleCk;
    }

    public Component asJComponent() {
        return this;
    }
}

