/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.annotation.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.gvsig.annotation.AnnotationCreationException;
import org.gvsig.annotation.AnnotationCreationService;
import org.gvsig.annotation.AnnotationCreationServiceException;
import org.gvsig.annotation.swing.AnnotationSwingManager;
import org.gvsig.annotation.swing.JAnnotationCreationServicePanel;
import org.gvsig.annotation.swing.impl.DefaultAnnotationSwingManager;
import org.gvsig.annotation.swing.impl.WizardListenerAdapter;
import org.gvsig.annotation.swing.impl.wizard.AnnotationProgressWizard;
import org.gvsig.annotation.swing.impl.wizard.MainOptionsWizard;
import org.gvsig.annotation.swing.impl.wizard.OptionalOptionsWizard;
import org.gvsig.annotation.swing.impl.wizard.SelectOutputFileWizard;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.gui.beans.wizard.WizardPanel;
import org.gvsig.gui.beans.wizard.WizardPanelActionListener;
import org.gvsig.gui.beans.wizard.WizardPanelWithLogo;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJAnnotationCreationServicePanel
extends JAnnotationCreationServicePanel
implements WizardPanel {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJAnnotationCreationServicePanel.class);
    private static final long serialVersionUID = 2965442763236823977L;
    private AnnotationCreationService annotationCreationService;
    private AnnotationSwingManager annotationSwingManager;
    private WizardPanelWithLogo wizardPanelWithLogo = null;
    private MainOptionsWizard mainOptionsWizard = null;
    private OptionalOptionsWizard optionalOptionsWizard = null;
    private SelectOutputFileWizard selectOutputFileWizard = null;
    private AnnotationProgressWizard annotationProgressWizard = null;
    private WizardListenerAdapter wizardListenerAdapter = null;

    public DefaultJAnnotationCreationServicePanel(DefaultAnnotationSwingManager annotationSwingManager, AnnotationCreationService annotationCreationService) throws ServiceException {
        IconThemeManager themeManager = ToolsSwingLocator.getIconThemeManager();
        this.wizardPanelWithLogo = new WizardPanelWithLogo(themeManager.getCurrent().get("wizard-annotation"));
        this.annotationCreationService = annotationCreationService;
        this.annotationSwingManager = annotationSwingManager;
        try {
            this.mainOptionsWizard = new MainOptionsWizard(this);
            this.optionalOptionsWizard = new OptionalOptionsWizard(this);
            this.selectOutputFileWizard = new SelectOutputFileWizard(this);
            this.annotationProgressWizard = new AnnotationProgressWizard(this);
        }
        catch (DataException e) {
            new AnnotationCreationServiceException("Exception creating the wizard forms", (Throwable)e);
        }
        this.addWizards();
        this.wizardPanelWithLogo.setWizardListener((WizardPanel)this);
        this.setFinishButtonEnabled(false);
        this.wizardPanelWithLogo.getWizardComponents().getFinishButton().setText(Messages.getText((String)"Comenzar"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.wizardPanelWithLogo, "Center");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                TaskStatus taskStatus = DefaultJAnnotationCreationServicePanel.this.getAnnotationCreationService().getTaskStatus();
                taskStatus.getManager().remove(taskStatus);
            }
        });
    }

    private void addWizards() {
        this.wizardPanelWithLogo.addOptionPanel((OptionPanel)this.mainOptionsWizard);
        this.wizardPanelWithLogo.addOptionPanel((OptionPanel)this.optionalOptionsWizard);
        this.wizardPanelWithLogo.addOptionPanel((OptionPanel)this.selectOutputFileWizard);
        this.wizardPanelWithLogo.addOptionPanel((OptionPanel)this.annotationProgressWizard);
    }

    public AnnotationCreationService getAnnotationCreationService() {
        return this.annotationCreationService;
    }

    public void setFinishButtonEnabled(boolean isEnabled) {
        this.wizardPanelWithLogo.setFinishButtonEnabled(isEnabled);
    }

    public void setCancellButtonEnabled(boolean isEnabled) {
        this.wizardPanelWithLogo.setCancelButtonEnabled(isEnabled);
    }

    public String getTextValueAttribute() {
        return this.mainOptionsWizard.getTextValueAttribute();
    }

    public String getTextRotationAttribute() {
        return this.optionalOptionsWizard.getRotationAttribute();
    }

    public String getTextColorAttribute() {
        return this.optionalOptionsWizard.getColorAttribute();
    }

    public String getTextHeightAttribute() {
        return this.optionalOptionsWizard.getHeightAttribute();
    }

    public String getTextTypeAttribute() {
        return this.optionalOptionsWizard.getFontAttribute();
    }

    public WizardPanelActionListener getWizardPanelActionListener() {
        if (this.wizardListenerAdapter == null && this.getAnnotationServicePanelActionListener() != null) {
            return new WizardListenerAdapter(this);
        }
        return this.wizardListenerAdapter;
    }

    public void setWizardPanelActionListener(WizardPanelActionListener wizardActionListener) {
    }

    public String getDestinationShapeFile() {
        return this.selectOutputFileWizard.getSelectedFileName();
    }

    public void setNextButtonEnabled(boolean isEnabled) {
        this.wizardPanelWithLogo.setNextButtonEnabled(isEnabled);
    }

    public AnnotationSwingManager getAnnotationSwingManager() {
        return this.annotationSwingManager;
    }

    public void setCancelButtonText(String translation) {
        this.wizardPanelWithLogo.getWizardComponents().getCancelButton().setText(translation);
    }

    public void createAnnotation() {
        this.lastWizard();
        Annotation annotation = new Annotation(this.getDestinationShapeFile(), this.getTextValueAttribute(), this.getTextRotationAttribute(), this.getTextColorAttribute(), this.getTextHeightAttribute(), this.getTextTypeAttribute());
        annotation.start();
    }

    public void lastWizard() {
        this.wizardPanelWithLogo.getWizardComponents().getNextButton().getActionListeners()[0].actionPerformed(null);
    }

    private void showError(AnnotationCreationException e, TaskStatus taskStatus) {
        String message = e.getMessage();
        if (e.getCause() != null) {
            message = e.getCause().getMessage();
        }
        JOptionPane.showMessageDialog(this.annotationProgressWizard, message);
    }

    private class Annotation
    extends Thread {
        private String file;
        private String textValueAttributeName;
        private String attrRotation;
        private String attrColor;
        private String attrHeight;
        private String attrType;

        public Annotation(String file, String textValueAttributeName, String attrRotation, String attrColor, String attrHeight, String attrType) {
            this.file = file;
            this.textValueAttributeName = textValueAttributeName;
            this.attrColor = attrColor;
            this.attrHeight = attrHeight;
            this.attrRotation = attrRotation;
            this.attrType = attrType;
        }

        @Override
        public synchronized void run() {
            AnnotationCreationService annotationCreationService = DefaultJAnnotationCreationServicePanel.this.getAnnotationCreationService();
            DefaultJAnnotationCreationServicePanel.this.annotationProgressWizard.bind(annotationCreationService.getTaskStatus());
            try {
                if (this.attrRotation != null) {
                    annotationCreationService.setFontRotationAttribute(this.attrRotation);
                }
                if (this.attrColor != null) {
                    annotationCreationService.setFontColorAttribute(this.attrColor);
                }
                if (this.attrHeight != null) {
                    annotationCreationService.setFontHeigthAttribute(this.attrHeight);
                }
                if (this.attrType != null) {
                    annotationCreationService.setFontTypeAttribute(this.attrType);
                }
                annotationCreationService.createAnnotationStore(this.file, this.textValueAttributeName);
            }
            catch (AnnotationCreationException e) {
                LOG.error("Error creating the annotation", (Throwable)e);
                DefaultJAnnotationCreationServicePanel.this.showError(e, annotationCreationService.getTaskStatus());
            }
            catch (DataException e) {
                LOG.error("Error assigning properties to the annotation layer", (Throwable)e);
            }
        }
    }
}

