/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.ods.lib.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.gvsig.ods.lib.api.ODSDocument;
import org.gvsig.ods.lib.impl.Spread;
import org.gvsig.ods.lib.impl.SpreadJOpenDocument;
import org.gvsig.ods.lib.impl.SpreadSODS;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.lib.api.PDFWriter;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.ODTRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultODSDocument
implements ODSDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultODSDocument.class);
    private Object source;
    private Locale locale;
    private Spread spread;

    public void setSource(File source) {
        this.setSource((Object)source);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void close() {
        this.source = null;
        this.locale = null;
        IOUtils.closeQuietly((Closeable)this.spread);
        this.spread = null;
    }

    public File getFile() {
        if (this.source instanceof File) {
            return (File)this.source;
        }
        return null;
    }

    private Spread getSpread() {
        if (this.spread == null) {
            if (this.getFile() != null) {
                try {
                    this.spread = new SpreadJOpenDocument();
                    this.spread.open(this.getFile(), this.locale);
                }
                catch (Exception ex) {
                    IOUtils.closeQuietly((Closeable)this.spread);
                    this.spread = null;
                    throw new RuntimeException("Can't load spread.", ex);
                }
            }
            SpreadSODS theSpread = new SpreadSODS();
            InputStream is = null;
            try {
                is = this.getInputStream();
                theSpread.open(is, this.locale);
            }
            catch (Exception ex) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((Closeable)theSpread);
                throw new RuntimeException("Can't load spread.", ex);
            }
            this.spread = theSpread;
        }
        return this.spread;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof File) {
            File fileSource = (File)this.source;
            try {
                is = new FileInputStream(fileSource);
            }
            catch (IOException ex) {
                LOGGER.warn("Not been able to convert file to input stream", (Throwable)ex);
                throw new IOException(ex);
            }
        } else if (this.source instanceof URL) {
            URL urlSource = (URL)this.source;
            try {
                is = urlSource.openStream();
            }
            catch (IOException ex) {
                LOGGER.warn("Not been able to open URL stream", (Throwable)ex);
                throw new IOException(ex);
            }
        } else if (this.source instanceof String) {
            String strSource = (String)this.source;
            File f = new File(strSource);
            if (f.exists()) {
                try {
                    is = new FileInputStream(f);
                }
                catch (FileNotFoundException ex) {
                    LOGGER.warn("Not been able to load existing file", (Throwable)ex);
                    throw new IOException(ex);
                }
            } else {
                try {
                    URL url = new URL(strSource);
                    is = url.openStream();
                    is.available();
                }
                catch (Exception ex) {
                    try {
                        byte[] data = Hex.decodeHex((char[])strSource.toCharArray());
                        is = new ByteArrayInputStream(data);
                    }
                    catch (DecoderException ex2) {
                        try {
                            byte[] data = Base64.decodeBase64((String)strSource);
                            is = new ByteArrayInputStream(data);
                        }
                        catch (Exception ex3) {
                            throw new IOException(ex3);
                        }
                    }
                }
            }
        } else if (this.source instanceof byte[]) {
            byte[] byteSource = (byte[])this.source;
            is = new ByteArrayInputStream(byteSource);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        if (this.source != null) {
            InputStream is = null;
            try {
                is = this.getInputStream();
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            catch (IOException ex) {
                LOGGER.warn("Not been able to convert to byte array", (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return null;
    }

    private String bytearray_hex(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte abyte : data) {
            int v = abyte & 0xFF;
            builder.append(String.format("%02x", v));
        }
        return builder.toString();
    }

    public String toHexString() {
        byte[] data = this.toByteArray();
        return this.bytearray_hex(data);
    }

    public PDFDocument createPDF(int pageSize) {
        PDFManager pdfManager = PDFLocator.getPDFManager();
        OpenDocument doc = new OpenDocument();
        doc.loadFrom(this.getFile());
        PDFWriter writer = pdfManager.createPDFWriter();
        writer.open(pageSize);
        Graphics2D g = writer.getGraphics2D();
        ODTRenderer renderer = new ODTRenderer(doc);
        renderer.setIgnoreMargins(true);
        renderer.setPaintMaxResolution(true);
        renderer.setResizeFactor(renderer.getPrintWidth() / (double)writer.getWidth());
        renderer.paintComponent((Graphics)g);
        writer.close();
        return writer.toDocument();
    }

    public ODSDocument.Sheet getSheet(int sheetIndex) {
        if (this.getSpread() == null || sheetIndex < 0) {
            return null;
        }
        return this.getSpread().getSheet(sheetIndex);
    }

    public List<String> getSheetNames() {
        if (this.getSpread() == null) {
            return null;
        }
        return this.getSpread().getSheetNames();
    }
}

