/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.additionalResults;

import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.additionalResults.AdditionalResults;
import es.unex.sextante.gui.additionalResults.AdditionalResultsTreeCellRenderer;
import es.unex.sextante.gui.algorithm.GenericFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class AdditionalResultsDialog
extends JDialog {
    private JSplitPane jSplitPane;
    private JTree jTree;
    private TreePath m_Path;
    private JScrollPane jScrollPane;
    private JMenuItem menuItemSave;
    private JPopupMenu popupMenu;
    private JMenuItem menuItemRemove;
    private JMenuItem menuItemRename;

    public AdditionalResultsDialog(ArrayList components, Frame mainFrame) {
        super(mainFrame, Sextante.getText((String)"Result"), true);
        this.initGUI(components);
        this.setLocationRelativeTo(null);
    }

    private boolean initGUI(ArrayList components) {
        JPanel panel = new JPanel();
        BorderLayout thisLayout = new BorderLayout();
        panel.setLayout(thisLayout);
        this.setContentPane(panel);
        if (components.size() == 0) {
            return false;
        }
        try {
            this.setPreferredSize(new Dimension(700, 350));
            this.setSize(new Dimension(700, 350));
            this.jSplitPane = new JSplitPane();
            panel.add((Component)this.jSplitPane, "Center");
            this.jTree = new JTree();
            this.jTree.setCellRenderer(new AdditionalResultsTreeCellRenderer());
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DefaultMutableTreeNode node;
                    AdditionalResultsDialog.this.m_Path = AdditionalResultsDialog.this.jTree.getPathForLocation(e.getX(), e.getY());
                    AdditionalResultsDialog.this.showComponent();
                    if (e.getButton() == 3 && AdditionalResultsDialog.this.m_Path != null && (node = (DefaultMutableTreeNode)AdditionalResultsDialog.this.m_Path.getLastPathComponent()).getUserObject() instanceof ObjectAndDescription) {
                        AdditionalResultsDialog.this.showPopupMenu(e);
                    }
                }
            };
            this.jTree.addMouseListener(ml);
            this.fillTree(components);
            if (components.size() > 0) {
                DefaultMutableTreeNode node = this.findNode((ObjectAndDescription)components.get(components.size() - 1));
                DefaultTreeModel model = (DefaultTreeModel)this.jTree.getModel();
                TreePath path = new TreePath(model.getPathToRoot(node));
                this.jTree.setSelectionPath(path);
                this.jTree.scrollPathToVisible(path);
                this.m_Path = path;
                this.showComponent();
            }
            this.jScrollPane = new JScrollPane(this.jTree, 22, 30);
            this.jScrollPane.setPreferredSize(new Dimension(200, 450));
            this.jScrollPane.setMinimumSize(new Dimension(200, 450));
            this.jScrollPane.setMaximumSize(new Dimension(200, 450));
            this.jSplitPane.add((Component)this.jScrollPane, "left");
            this.popupMenu = new JPopupMenu("Menu");
            this.menuItemSave = new JMenuItem(Sextante.getText((String)"Save"));
            this.menuItemSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AdditionalResultsDialog.this.m_Path != null) {
                        try {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdditionalResultsDialog.this.m_Path.getLastPathComponent();
                            if (node.getUserObject() instanceof ObjectAndDescription) {
                                AdditionalResultsDialog.this.save();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.popupMenu.add(this.menuItemSave);
            this.menuItemRemove = new JMenuItem(Sextante.getText((String)"Remove"));
            this.menuItemRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AdditionalResultsDialog.this.m_Path != null) {
                        try {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdditionalResultsDialog.this.m_Path.getLastPathComponent();
                            if (node.getUserObject() instanceof ObjectAndDescription) {
                                AdditionalResultsDialog.this.remove();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.popupMenu.add(this.menuItemRemove);
            this.menuItemRename = new JMenuItem(Sextante.getText((String)"Rename"));
            this.menuItemRename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AdditionalResultsDialog.this.m_Path != null) {
                        try {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdditionalResultsDialog.this.m_Path.getLastPathComponent();
                            if (node.getUserObject() instanceof ObjectAndDescription) {
                                AdditionalResultsDialog.this.rename();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.popupMenu.add(this.menuItemRename);
            panel.updateUI();
            return true;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        this.jTree.setSelectionPath(this.m_Path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
        ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
        Component c = (Component)oad.getObject();
        this.menuItemSave.setEnabled(true);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void rename() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                String sName = oad.getDescription();
                JOptionPane pane = new JOptionPane();
                pane.setMessage(Sextante.getText((String)"introduce_nombre"));
                pane.setMessageType(3);
                pane.setWantsInput(true);
                pane.setInitialSelectionValue(sName);
                pane.setInputValue(sName);
                JDialog dlg = pane.createDialog(null, Sextante.getText((String)"renombrar"));
                dlg.setModal(true);
                dlg.setVisible(true);
                String sNewName = pane.getInputValue().toString().trim();
                if (sNewName != null && sNewName.length() != 0) {
                    oad.setDescription(sNewName);
                }
                this.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void remove() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                AdditionalResults.removeComponent(oad);
                this.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void save() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                Component c = (Component)oad.getObject();
                if (c instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)c;
                    Component view = pane.getViewport().getView();
                    if (view instanceof JTextPane) {
                        JTextPane text = (JTextPane)pane.getViewport().getView();
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new GenericFileFilter(new String[]{"htm"}, "HTML"));
                        int returnVal = fc.showSaveDialog(this);
                        if (returnVal == 0) {
                            try {
                                File file = fc.getSelectedFile();
                                FileWriter fileWriter = new FileWriter(file);
                                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                bufferedWriter.write(text.getText());
                                bufferedWriter.close();
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(null, "Could not save selected result", Sextante.getText((String)"Warning"), 2);
                            }
                        }
                    } else if (view instanceof JTable) {
                        JTable table = (JTable)pane.getViewport().getView();
                        TableModel model = table.getModel();
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new GenericFileFilter(new String[]{"csv"}, "Comma-Separated Values (csv)"));
                        int returnVal = fc.showSaveDialog(this);
                        if (returnVal == 0) {
                            try {
                                File file = fc.getSelectedFile();
                                FileWriter fileWriter = new FileWriter(file);
                                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                for (int j = 0; j < model.getColumnCount(); ++j) {
                                    bufferedWriter.write(model.getColumnName(j));
                                    if (j == model.getColumnCount() - 1) {
                                        bufferedWriter.write("\n");
                                        continue;
                                    }
                                    bufferedWriter.write(",");
                                }
                                for (int i = 0; i < model.getRowCount(); ++i) {
                                    for (int j = 0; j < model.getColumnCount(); ++j) {
                                        bufferedWriter.write(model.getValueAt(i, j).toString());
                                        if (j == model.getColumnCount() - 1) {
                                            bufferedWriter.write("\n");
                                            continue;
                                        }
                                        bufferedWriter.write(",");
                                    }
                                }
                                bufferedWriter.close();
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(null, "Could not save selected result", Sextante.getText((String)"Warning"), 2);
                            }
                        }
                    }
                } else if (c instanceof ChartPanel) {
                    ChartPanel panel = (ChartPanel)c;
                    JFileChooser fc = new JFileChooser();
                    fc.setFileFilter(new GenericFileFilter(new String[]{"png"}, "png"));
                    int returnVal = fc.showSaveDialog(this);
                    if (returnVal == 0) {
                        ChartUtilities.saveChartAsPNG((File)fc.getSelectedFile(), (JFreeChart)panel.getChart(), (int)600, (int)350);
                    }
                }
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    protected void showComponent() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                Component c = (Component)oad.getObject();
                c.setMinimumSize(new Dimension(300, 200));
                this.jSplitPane.setRightComponent(c);
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    public void fillTree(ArrayList components) {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Toolbox"));
        DefaultMutableTreeNode componentsNode = new DefaultMutableTreeNode(Sextante.getText((String)"Result"));
        for (int i = 0; i < components.size(); ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(components.get(i));
            componentsNode.add(node);
        }
        mainNode.add(componentsNode);
        this.jTree.setModel(new DefaultTreeModel(mainNode));
    }

    public void update() {
        if (!this.initGUI(AdditionalResults.getComponents())) {
            this.dispose();
            this.setVisible(false);
        }
    }

    private DefaultMutableTreeNode findNode(ObjectAndDescription oad) {
        DefaultTreeModel data2 = (DefaultTreeModel)this.jTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)data2.getRoot();
        DefaultMutableTreeNode node = null;
        if (root != null) {
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
                Object ob = current.getUserObject();
                if (!(ob instanceof ObjectAndDescription) || ob != oad) continue;
                node = current;
                break;
            }
        }
        return node;
    }
}

