/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.GenericFileFilter;
import es.unex.sextante.parameters.FixedTableModel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class FixedTableDialog
extends JDialog {
    private final FixedTableModel m_TableModel;
    private final FixedTableModel m_TableModelOrg;
    private JPanel jPanelMain;
    private JPanel jPanelAddRemoveRows;
    private JSeparator jSeparator;
    private JScrollPane jScrollPane;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonRemoveRow;
    private JButton jButtonAddRow;
    private JTable jTable;
    private boolean m_bAccepted;
    private JPanel jPanelOpenSave;
    private JButton jButtonOpen;
    private JButton jButtonSave;

    public FixedTableDialog(Frame window, FixedTableModel tableModel) {
        super(window, "", true);
        this.setResizable(false);
        this.m_TableModelOrg = tableModel;
        this.m_TableModel = FixedTableModel.newInstance((FixedTableModel)tableModel);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(Sextante.getText((String)"Fixed_table"));
            this.jPanelMain = new JPanel();
            this.getContentPane().add((Component)this.jPanelMain, "Center");
            TableLayout jPanelMainLayout = new TableLayout((double[][])new double[][]{{3.0, -1.0, -1.0, -1.0, -1.0, 3.0}, {3.0, 75.0, -1.0, 75.0, 5.0, 30.0, 3.0}});
            jPanelMainLayout.setHGap(5);
            jPanelMainLayout.setVGap(5);
            this.jPanelMain.setLayout((LayoutManager)jPanelMainLayout);
            this.jPanelMain.setPreferredSize(new Dimension(564, 322));
            this.jScrollPane = new JScrollPane();
            this.jPanelMain.add((Component)this.jScrollPane, "1, 1, 3, 3");
            this.jScrollPane.setPreferredSize(new Dimension(432, 256));
            this.jTable = new JTable();
            this.jScrollPane.setViewportView(this.jTable);
            this.jTable.setModel((TableModel)this.m_TableModel);
            this.jPanelOpenSave = new JPanel();
            this.jPanelMain.add((Component)this.jPanelOpenSave, "4, 3");
            TableLayout jPanelAddOpenSaveLayout = new TableLayout((double[][])new double[][]{{-3.0, -1.0, -3.0}, {-3.0, -1.0, -1.0, -3.0}});
            jPanelAddOpenSaveLayout.setHGap(5);
            jPanelAddOpenSaveLayout.setVGap(5);
            this.jPanelOpenSave.setLayout((LayoutManager)jPanelAddOpenSaveLayout);
            this.jPanelOpenSave.setPreferredSize(new Dimension(116, 56));
            this.jPanelAddRemoveRows = new JPanel();
            TableLayout jPanelAddRemoveRowsLayout = new TableLayout((double[][])new double[][]{{-3.0, -1.0, -3.0}, {-3.0, -1.0, -1.0, -3.0}});
            jPanelAddRemoveRowsLayout.setHGap(5);
            jPanelAddRemoveRowsLayout.setVGap(5);
            this.jPanelAddRemoveRows.setLayout((LayoutManager)jPanelAddRemoveRowsLayout);
            this.jPanelMain.add((Component)this.jPanelAddRemoveRows, "4, 1");
            this.jPanelAddRemoveRows.setPreferredSize(new Dimension(116, 56));
            this.jButtonRemoveRow = new JButton();
            this.jPanelAddRemoveRows.add((Component)this.jButtonRemoveRow, "1, 2");
            this.jButtonRemoveRow.setText(Sextante.getText((String)"Delete_row"));
            this.jButtonRemoveRow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FixedTableDialog.this.removeRow();
                }
            });
            if (this.m_TableModel.isNumberOfRowsFixed()) {
                this.jButtonRemoveRow.setEnabled(false);
                this.jButtonRemoveRow.setSize(100, 22);
            }
            this.jButtonAddRow = new JButton();
            this.jPanelAddRemoveRows.add((Component)this.jButtonAddRow, "1, 1");
            this.jButtonAddRow.setText(Sextante.getText((String)"Add_row"));
            this.jButtonAddRow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FixedTableDialog.this.addRow();
                }
            });
            if (this.m_TableModel.isNumberOfRowsFixed()) {
                this.jButtonAddRow.setEnabled(false);
                this.jButtonAddRow.setSize(100, 22);
            }
            this.jButtonOpen = new JButton();
            this.jPanelOpenSave.add((Component)this.jButtonOpen, "1, 2");
            this.jButtonOpen.setText(Sextante.getText((String)"Open"));
            this.jButtonOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FixedTableDialog.this.open();
                }
            });
            this.jButtonSave = new JButton();
            this.jPanelOpenSave.add((Component)this.jButtonSave, "1, 1");
            this.jButtonSave.setText(Sextante.getText((String)"Save"));
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FixedTableDialog.this.save();
                }
            });
            this.jSeparator = new JSeparator();
            this.jPanelMain.add((Component)this.jSeparator, "1, 4, 4, 4");
            this.jSeparator.setPreferredSize(new Dimension(565, 20));
            this.jButtonOK = new JButton();
            this.jPanelMain.add((Component)this.jButtonOK, "3, 5");
            this.jButtonOK.setText(Sextante.getText((String)"OK"));
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FixedTableDialog.this.btnOKActionPerformed();
                }
            });
            this.jButtonCancel = new JButton();
            this.jPanelMain.add((Component)this.jButtonCancel, "4, 5");
            this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FixedTableDialog.this.btnCancelActionPerformed();
                }
            });
            this.setSize(580, 350);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        JFileChooser fc = new JFileChooser();
        GenericFileFilter filter = new GenericFileFilter("csv", "Comma-Separated Values");
        fc.setFileFilter(filter);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(".csv")) {
                file = new File(file.getAbsoluteFile() + ".csv");
            }
            Writer output = null;
            try {
                output = new BufferedWriter(new FileWriter(file));
                int iRows = this.m_TableModel.getRowCount();
                int iCols = this.m_TableModel.getColumnCount();
                for (int iRow = 0; iRow < iRows; ++iRow) {
                    for (int iCol = 0; iCol < iCols; ++iCol) {
                        String s = this.m_TableModel.getValueAt(iRow, iCol).toString();
                        output.write(s);
                        if (iCol >= iCols - 1) continue;
                        output.write("|");
                    }
                    output.write("\n");
                }
            }
            catch (IOException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
            }
        }
    }

    private void open() {
        try {
            JFileChooser fc = new JFileChooser();
            GenericFileFilter filter = new GenericFileFilter("csv", "Comma-Separated Values");
            fc.setFileFilter(filter);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                BufferedReader input = null;
                int iRows = this.m_TableModel.getRowCount();
                input = new BufferedReader(new FileReader(file));
                String sLine = null;
                int i = 1;
                while ((sLine = input.readLine()) != null) {
                    if (i > iRows && !this.m_TableModel.isNumberOfRowsFixed()) {
                        this.m_TableModel.addRow();
                    }
                    this.processLine(sLine, this.m_TableModel, i - 1);
                    ++i;
                }
                input.close();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Sextante.getText((String)"Could_not_open_selected_file"), Sextante.getText((String)"Error"), 0);
        }
    }

    private void processLine(String line, FixedTableModel table, int iRow) {
        try {
            String[] tokens = line.split("\\|");
            for (int i = 0; i < tokens.length; ++i) {
                table.setValueAt((Object)tokens[i], iRow, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnOKActionPerformed() {
        if (this.checkData()) {
            this.m_TableModelOrg.setAttributes(this.m_TableModel.getColumnNames(), this.m_TableModel.getData(), this.m_TableModel.isNumberOfRowsFixed());
            this.m_bAccepted = true;
            this.dispose();
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, Sextante.getText((String)"Wrong_values_in_table"), Sextante.getText((String)"Error"), 0);
        }
    }

    private boolean checkData() {
        try {
            for (int i = 0; i < this.m_TableModel.getData().length; ++i) {
                ArrayList list = this.m_TableModel.getData()[i];
                for (int j = 0; j < list.size(); ++j) {
                    if (!list.get(j).toString().isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void btnCancelActionPerformed() {
        this.m_bAccepted = false;
        this.dispose();
        this.setVisible(false);
    }

    private void addRow() {
        this.m_TableModel.addRow();
    }

    private void removeRow() {
        int iRow = this.jTable.getSelectedRow();
        if (iRow != -1) {
            this.m_TableModel.removeRow(iRow);
        }
    }

    public boolean accepted() {
        return this.m_bAccepted;
    }
}

