/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.NamedPoint;
import es.unex.sextante.gui.core.SextanteGUI;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PointSelectionPanel
extends JPanel {
    private JTextField textFieldX;
    private JButton jButton;
    private JTextField textFieldY;
    private JLabel labelX;
    private JLabel labelY;

    PointSelectionPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.textFieldX = new JTextField("0");
        this.textFieldY = new JTextField("0");
        this.labelX = new JLabel(" X:");
        this.labelY = new JLabel(" Y:");
        this.jButton = new JButton();
        this.jButton.setText("...");
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{25.0, -1.0, 25.0, -1.0, 5.0, 25.0, 5.0}, {-1.0}});
        this.setLayout((LayoutManager)thisLayout);
        this.setPreferredSize(new Dimension(128, 22));
        this.add((Component)this.labelX, "0,  0");
        this.add((Component)this.textFieldX, "1,  0");
        this.add((Component)this.labelY, "2,  0");
        this.add((Component)this.textFieldY, "3,  0");
        this.add((Component)this.jButton, "5, 0");
        this.jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointSelectionPanel.this.showPointSelector();
            }
        });
    }

    protected void showPointSelector() {
        List<NamedPoint> coordsList = SextanteGUI.getGUIFactory().getCoordinatesList();
        if (!coordsList.isEmpty()) {
            Object[] pts = coordsList.toArray(new NamedPoint[0]);
            NamedPoint pt = (NamedPoint)JOptionPane.showInputDialog(this, Sextante.getText((String)"Select_coordinates"), Sextante.getText((String)"Coordinates"), -1, null, pts, null);
            if (pt != null) {
                this.textFieldX.setText(Double.toString(pt.getPoint().getX()));
                this.textFieldY.setText(Double.toString(pt.getPoint().getY()));
            }
        }
    }

    public Point2D getPoint() {
        try {
            Point2D.Double pt = new Point2D.Double(Double.parseDouble(this.textFieldX.getText()), Double.parseDouble(this.textFieldY.getText()));
            return pt;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setPoint(Point2D point) {
        this.textFieldX.setText(Double.toString(Math.floor(point.getX() * 10000.0) / 10000.0));
        this.textFieldY.setText(Double.toString(Math.floor(point.getY() * 10000.0) / 10000.0));
    }
}

